##-------------------------------------------------------------------------------
##--                            Ken Campbell
##--                        No Rights Reserved
##-------------------------------------------------------------------------------
##-- $Author: ken $
##--
##-- $Date: 2005/12/09 15:14:08 $
##--
##-- $Name:  $
##--
##-- $Id: $
##--
##-- $Source: $
##--
##-- Description :
##--      
##------------------------------------------------------------------------------
##-- This software contains concepts 
##-- 
##-- 
##-------------------------------------------------------------------------------
## package requires
package require Iwidgets 4.0


proc sdk_print {} {
	
    global vrow_v1 vrow_v2 vrow_v3 vrow_v4 vrow_v5 vrow_v6 vrow_v7 vrow_v8 vrow_v9
    global row_v1 row_v2 row_v3 row_v4 row_v5 row_v6 row_v7 row_v8 row_v9
    global gnumb glevel pcanvs
    

    	
    set pw .tmp
    toplevel $pw
    wm title $pw "Sudoku Print"

    set pcanvs [canvas $pw.cv1 -height 480 -width 450]
    
    $pcanvs create line 3 3 3 447 -width 4
    $pcanvs create line 3 447 447 447 -width 4
    $pcanvs create line 3 3 447 3 -width 4
    $pcanvs create line 447 3 447 447 -width 4
    #$pcanvs create line 3 447 -width 4
    #$pcanvs create line 3 447 -width 4
    $pcanvs create line 50  3 50  447 -width 1
    $pcanvs create line 100 3 100 447 -width 1
    $pcanvs create line 150 3 150 447 -width 4
    $pcanvs create line 200 3 200 447 -width 1
    $pcanvs create line 250 3 250 447 -width 1
    $pcanvs create line 300 3 300 447 -width 4
    $pcanvs create line 350 3 350 447 -width 1
    $pcanvs create line 400 3 400 447 -width 1

    $pcanvs create line 3 50  447 50  -width 1
    $pcanvs create line 3 100 447 100 -width 1
    $pcanvs create line 3 150 447 150 -width 4
    $pcanvs create line 3 200 447 200 -width 1
    $pcanvs create line 3 250 447 250 -width 1
    $pcanvs create line 3 300 447 300 -width 4
    $pcanvs create line 3 350 447 350 -width 1
    $pcanvs create line 3 400 447 400 -width 1
    
    $pcanvs create text 200 460 -font bline -text "Sudoku  by Sckoarn           sckoarn.com" \
         -anchor w
    set pbf [frame $pw.pbf1]
    set print_but [button $pbf.pb1 -text "Print to File" -command "print_screen"]
    ##set font_but [button $pbf.fb1 -text "Change Font" -command "font_change"]
    ##set printf_but [button $pbf.pb2 -text "Print to File" -command "print_tofile"]
    set ex_but [button $pbf.exb1 -text "Exit" -command sdk_kill]
    
    pack $pcanvs
    pack $print_but -padx 10 -side left 
    ##pack $font_but -padx 10 -side left
    pack $ex_but -side left -padx 10
    pack $pbf

    set lv [$glevel get]
    set game [$gnumb get]

    $pcanvs create text 10 460 -font bline -text "Game: $game  Level: $lv" \
         -anchor w
         
    
    set c_r 25
    set c_c 25
    # go through all the locations
    for {set i 1} {$i < 10} {incr i} {
        switch $i {
            "1" {set vrow $vrow_v1; set row $row_v1}
            "2" {set vrow $vrow_v2; set row $row_v2}
            "3" {set vrow $vrow_v3; set row $row_v3}
            "4" {set vrow $vrow_v4; set row $row_v4}
            "5" {set vrow $vrow_v5; set row $row_v5}
            "6" {set vrow $vrow_v6; set row $row_v6}
            "7" {set vrow $vrow_v7; set row $row_v7}
            "8" {set vrow $vrow_v8; set row $row_v8}
            "9" {set vrow $vrow_v9; set row $row_v9}
        }
        
        for {set j 0} {$j < 9} {incr j} {
            set c [lindex $vrow $j]
            if {$c == 1} {
	            
                set val [lindex $row $j]
                $pcanvs create text $c_r $c_c -text $val -font shwn -tag numb_set
            }
            set c_r [expr {$c_r + 50}]
        }
        
        set c_c [expr {$c_c + 50}]
        set c_r 25
    }


}
##  kill the print display window
proc sdk_kill {} {
	destroy .tmp
}
###################################
##  Change the font for shown numbers
proc font_change {} {
	global pcanvs
	
    set pfnt [choosefont "shwn" "new font"]
    
    $pcanvs itemconfigre numb_set -font $pfnt
}

#####################
##   Print the window proc
proc print_screen {} {
	global gnumb glevel pcanvs
	
	set game [$gnumb get]
	set lev [$glevel get]
	set fn ""
	append fn "Sudoku_g" $game "l" $lev ".ps"
	
	$pcanvs postscript -file $fn
}

#####################################
##  Debug screen
proc dbg_print {r1 r2 r3 r4 r5 r6 r7 r8 r9 lst blk_num count} {
	
    global vrow_v1 vrow_v2 vrow_v3 vrow_v4 vrow_v5 vrow_v6 vrow_v7 vrow_v8 vrow_v9
    global row_v1 row_v2 row_v3 row_v4 row_v5 row_v6 row_v7 row_v8 row_v9
    global gnumb glevel pcanvs blocked
    

    	
    set pw .dbtmp
    toplevel $pw
    wm title $pw "Sudoku Debug Print"

    set pcanvs [canvas $pw.cv2 -height 500 -width 490]
    
    
    foreach {loc val} [array get blocked] {
	    switch $loc {
		    "b1r1" { $pcanvs create text 455 10  -text "$loc $val" -anchor w; }
		    "b1r2" { $pcanvs create text 455 20  -text "$loc $val" -anchor w; }
		    "b1r3" { $pcanvs create text 455 30  -text "$loc $val" -anchor w; }
		    "b2r1" { $pcanvs create text 455 60  -text "$loc $val" -anchor w; }
		    "b2r2" { $pcanvs create text 455 70  -text "$loc $val" -anchor w; }
		    "b2r3" { $pcanvs create text 455 80  -text "$loc $val" -anchor w; }
		    "b3r1" { $pcanvs create text 455 110 -text "$loc $val" -anchor w; }
		    "b3r2" { $pcanvs create text 455 120 -text "$loc $val" -anchor w; }
		    "b3r3" { $pcanvs create text 455 130 -text "$loc $val" -anchor w; }
		    "b4r1" { $pcanvs create text 455 160 -text "$loc $val" -anchor w; }
		    "b4r2" { $pcanvs create text 455 170 -text "$loc $val" -anchor w; }
		    "b4r3" { $pcanvs create text 455 180 -text "$loc $val" -anchor w; }
		    "b5r1" { $pcanvs create text 455 210 -text "$loc $val" -anchor w; }
		    "b5r2" { $pcanvs create text 455 220 -text "$loc $val" -anchor w; }
		    "b5r3" { $pcanvs create text 455 230 -text "$loc $val" -anchor w; }
		    "b6r1" { $pcanvs create text 455 260 -text "$loc $val" -anchor w; }
		    "b6r2" { $pcanvs create text 455 270 -text "$loc $val" -anchor w; }
		    "b6r3" { $pcanvs create text 455 280 -text "$loc $val" -anchor w; }
		    "b7r1" { $pcanvs create text 455 310 -text "$loc $val" -anchor w; }
		    "b7r2" { $pcanvs create text 455 320 -text "$loc $val" -anchor w; }
		    "b7r3" { $pcanvs create text 455 330 -text "$loc $val" -anchor w; }
		    "b8r1" { $pcanvs create text 455 360 -text "$loc $val" -anchor w; }
		    "b8r2" { $pcanvs create text 455 370 -text "$loc $val" -anchor w; }
		    "b8r3" { $pcanvs create text 455 380 -text "$loc $val" -anchor w; }
		    "b9r1" { $pcanvs create text 455 410 -text "$loc $val" -anchor w; }
		    "b9r2" { $pcanvs create text 455 420 -text "$loc $val" -anchor w; }
		    "b9r3" { $pcanvs create text 455 430 -text "$loc $val" -anchor w; }
		    
		    "b1c1" { $pcanvs create text 10  455 -text "$loc $val" -anchor w; }
		    "b1c2" { $pcanvs create text 10  465 -text "$loc $val" -anchor w; }
		    "b1c3" { $pcanvs create text 10  475 -text "$loc $val" -anchor w; }
		    "b2c1" { $pcanvs create text 60  455 -text "$loc $val" -anchor w; }
		    "b2c2" { $pcanvs create text 60  465 -text "$loc $val" -anchor w; }
		    "b2c3" { $pcanvs create text 60  475 -text "$loc $val" -anchor w; }
		    "b3c1" { $pcanvs create text 110 455 -text "$loc $val" -anchor w; }
		    "b3c2" { $pcanvs create text 110 465 -text "$loc $val" -anchor w; }
		    "b3c3" { $pcanvs create text 110 475 -text "$loc $val" -anchor w; }
		    "b4c1" { $pcanvs create text 160 455 -text "$loc $val" -anchor w; }
		    "b4c2" { $pcanvs create text 160 465 -text "$loc $val" -anchor w; }
		    "b4c3" { $pcanvs create text 160 475 -text "$loc $val" -anchor w; }
		    "b5c1" { $pcanvs create text 210 455 -text "$loc $val" -anchor w; }
		    "b5c2" { $pcanvs create text 210 465 -text "$loc $val" -anchor w; }
		    "b5c3" { $pcanvs create text 210 475 -text "$loc $val" -anchor w; }
		    "b6c1" { $pcanvs create text 260 455 -text "$loc $val" -anchor w; }
		    "b6c2" { $pcanvs create text 260 465 -text "$loc $val" -anchor w; }
		    "b6c3" { $pcanvs create text 260 475 -text "$loc $val" -anchor w; }
		    "b7c1" { $pcanvs create text 310 455 -text "$loc $val" -anchor w; }
		    "b7c2" { $pcanvs create text 310 465 -text "$loc $val" -anchor w; }
		    "b7c3" { $pcanvs create text 310 475 -text "$loc $val" -anchor w; }
		    "b8c1" { $pcanvs create text 360 455 -text "$loc $val" -anchor w; }
		    "b8c2" { $pcanvs create text 360 465 -text "$loc $val" -anchor w; }
		    "b8c3" { $pcanvs create text 360 475 -text "$loc $val" -anchor w; }
		    "b9c1" { $pcanvs create text 410 455 -text "$loc $val" -anchor w; }
		    "b9c2" { $pcanvs create text 410 465 -text "$loc $val" -anchor w; }
		    "b9c3" { $pcanvs create text 410 475 -text "$loc $val" -anchor w; }
	    }
    }
    #$pcanvs create line 3 26 444 26 -width 46 -fill red 
    
    $pcanvs create line 3 3 3 447 -width 4
    $pcanvs create line 3 447 447 447 -width 4
    $pcanvs create line 3 3 447 3 -width 4
    $pcanvs create line 447 3 447 447 -width 4
    #$pcanvs create line 3 447 -width 4
    #$pcanvs create line 3 447 -width 4
    $pcanvs create line 50  3 50  447 -width 1
    $pcanvs create line 100 3 100 447 -width 1
    $pcanvs create line 150 3 150 447 -width 4
    $pcanvs create line 200 3 200 447 -width 1
    $pcanvs create line 250 3 250 447 -width 1
    $pcanvs create line 300 3 300 447 -width 4
    $pcanvs create line 350 3 350 447 -width 1
    $pcanvs create line 400 3 400 447 -width 1

    $pcanvs create line 3 50  447 50  -width 1
    $pcanvs create line 3 100 447 100 -width 1
    $pcanvs create line 3 150 447 150 -width 4
    $pcanvs create line 3 200 447 200 -width 1
    $pcanvs create line 3 250 447 250 -width 1
    $pcanvs create line 3 300 447 300 -width 4
    $pcanvs create line 3 350 447 350 -width 1
    $pcanvs create line 3 400 447 400 -width 1
    
  ##  $pcanvs create text 200 460 -font bline -text "Sudoku  by Sckoarn           sckoarn.com" \
         -anchor w
    set pbf [frame $pw.pbf1]
    set print_but [button $pbf.pb1 -text "Print to File" -command "print_screen"]
    ##set font_but [button $pbf.fb1 -text "Change Font" -command "font_change"]
    ##set printf_but [button $pbf.pb2 -text "Print to File" -command "print_tofile"]
    set ex_but [button $pbf.exb1 -text "Exit" -command dbg_kill]
    
    pack $pcanvs
    pack $print_but -padx 10 -side left 
    ##pack $font_but -padx 10 -side left
    pack $ex_but -side left -padx 10
    pack $pbf

    set lv [$glevel get]
    set game [$gnumb get]

    $pcanvs create text 10 490 -font bline -text "Game: $game  Lvl: $lv Blk: $blk_num  Try: $count" \
         -anchor w
         
    
    foreach {loc val} [array get blk_arr] {
	    
    }
    
    set c_r 25
    set c_c 25
    for {set i 1} {$i < 10} {incr i} {
        switch $i {
            "1" {set vrow $vrow_v1; set row $r1}
            "2" {set vrow $vrow_v2; set row $r2}
            "3" {set vrow $vrow_v3; set row $r3}
            "4" {set vrow $vrow_v4; set row $r4}
            "5" {set vrow $vrow_v5; set row $r5}
            "6" {set vrow $vrow_v6; set row $r6}
            "7" {set vrow $vrow_v7; set row $r7}
            "8" {set vrow $vrow_v8; set row $r8}
            "9" {set vrow $vrow_v9; set row $r9}
        }
        
        for {set j 0} {$j < 9} {incr j} {
	        set c [lindex $vrow $j]
            if {$c == 0} {
                set val [lindex $row $j]
                if {$val != 0} {
                    $pcanvs create text $c_r $c_c -text $val -font shwn -tag numb_set
                }
            }
            set c_r [expr {$c_r + 50}]
        }
        
        set c_c [expr {$c_c + 50}]
        set c_r 25

    }
	    
        
        
        dbg_msg "Pause"
        
        destroy .dbtmp
}

