##-------------------------------------------------------------------------------
##--                            Ken Campbell
##--                        No Rights Reserved
##-------------------------------------------------------------------------------
##-- $Author: ken $
##--
##-- $Date: 2005/12/09 15:14:08 $
##--
##-- $Name:  $
##--
##-- $Id: $
##--
##-- $Source: $
##--
##-- Description :
##--      
##------------------------------------------------------------------------------
##-- This software contains concepts 
##--  and is only made available within the terms of a written
##-- agreement.
##-------------------------------------------------------------------------------
## package requires
package require Iwidgets 4.0

###########################################################################
##  Message, continue
proc dbg_msg { msg } {
  set rtn [tk_messageBox -message $msg -type okcancel]
  switch $rtn {
	  "cancel" exit
  }
  
}

###########################################################################
##  Message, continue
proc about_msg { msg } {
  set rtn [tk_messageBox -message $msg -type ok]
  
}


#####################################################################
##  Procs
## Am stuck 2  Check to see if any number is avail for this slot
proc am_stuc2 {l1 l2 l3} {
    for {set i 0} {$i <= 9} {incr i} {
        set v [string first $i $l1]
        set v1 [string first $i $l2]
        set v2 [string first $i $l3]
        if {$v < 0 && $v1 < 0 && $v2 < 0} {
            #dbg_msg "$l1 \n $l2"
            return -1
        }
    }
    #dbg_msg "$l1 \n $l2"
    return 1
}

#####################
#  gen a value on to a list excluding those on row and col
#    db is debug messages on = 1
proc gen_val {str row col db} {
    # Check for all numbers used already
    set chck [am_stuc2 $str $row $col]
    if {$chck == 1} {
        return -1
    }
    # numbers free, so rand gen one till is valid
    set value [expr { int(rand() * 9) + 1}]
    set f [string first $value $str]
    set r [string first $value $row]
    set c [string first $value $col]
    #  while value is in one of the strings gen another
    while {$f >= 0 || $r >= 0 || $c >= 0} {
        if {$db == 1} {
            dbg_msg "$f $r $c   $value\n Row: $row  \n Col: $col \n $str"
        }
        set value [expr { int(rand() * 9) + 1}]
        set f [string first $value $str]
        set r [string first $value $row]
        set c [string first $value $col]
    }
    lappend str $value
    return $str
}

######################################
#  Generate block
#    Based on the block number 1-9 gen the box list
proc gen_block {blk} {
    global row_v1 row_v2 row_v3 row_v4 row_v5 row_v6 row_v7 row_v8 row_v9
    global col_v1 col_v2 col_v3 col_v4 col_v5 col_v6 col_v7 col_v8 col_v9
    global box1 box2 box3 box4 box5 box6 box7 box8 box9

    set str ""
    
    #puts "Generating Block $blk"
    
    switch $blk {
        #"1" {set r1 $row_v1; set r2 $row_v2; set r3 $row_v3; set c1 $col_v1; set c1 $col_v2; set c1 $col_v3}
        "2" {set r1 $row_v1; set r2 $row_v2; set r3 $row_v3; set c1 $col_v4; set c2 $col_v5; set c3 $col_v6}
        "3" {set r1 $row_v1; set r2 $row_v2; set r3 $row_v3; set c1 $col_v7; set c2 $col_v8; set c3 $col_v9}
        "4" {set r1 $row_v4; set r2 $row_v5; set r3 $row_v6; set c1 $col_v1; set c2 $col_v2; set c3 $col_v3}
        "5" {set r1 $row_v4; set r2 $row_v5; set r3 $row_v6; set c1 $col_v4; set c2 $col_v5; set c3 $col_v6}
        "6" {set r1 $row_v4; set r2 $row_v5; set r3 $row_v6; set c1 $col_v7; set c2 $col_v8; set c3 $col_v9}
        "7" {set r1 $row_v7; set r2 $row_v8; set r3 $row_v9; set c1 $col_v1; set c2 $col_v2; set c3 $col_v3}
        "8" {set r1 $row_v7; set r2 $row_v8; set r3 $row_v9; set c1 $col_v4; set c2 $col_v5; set c3 $col_v6}
        "9" {set r1 $row_v7; set r2 $row_v8; set r3 $row_v9; set c1 $col_v7; set c2 $col_v8; set c3 $col_v9}
        "default" {puts "Error: box def out of range!!";  return -1}
    }
    
    set str [gen_val $str $r1 $c1 0]
    ## if first did not fail gen next
    if {$str != -1} {
        set str [gen_val $str $r1 $c2 0]
    } else {
        return -1
    }
    ## if 2nd did not fail gen next
    if {$str != -1} {
        set str [gen_val $str $r1 $c3 0]
    } else {
        return -1
    }
    ## if 3rd did not fail gen next
    if {$str != -1} {
        set str [gen_val $str $r2 $c1 0]
    } else {
        return -1
    }
    ## if 4th did not fail gen next
    if {$str != -1} {
        set str [gen_val $str $r2 $c2 0]
    } else {
        return -1
    }
    ## if 5th did not fail gen next
    if {$str != -1} {
        set str [gen_val $str $r2 $c3 0]
    } else {
        return -1
    }
    ## if 6th did not fail gen next
    if {$str != -1} {
        set str [gen_val $str $r3 $c1 0]
    } else {
        return -1
    }
    ## if 7th did not fail gen next
    if {$str != -1} {
        set str [gen_val $str $r3 $c2 0]
    } else {
        return -1
    }
    ## if 8th did not fail gen next
    if {$str != -1} {
        set str [gen_val $str $r3 $c3 0]
    } else {
        return -1
    }
    
    return $str
}

#########################################################################
##  Row Colum update  Based on Block number
proc rc_update {blk dbg} {
    global row_v1 row_v2 row_v3 row_v4 row_v5 row_v6 row_v7 row_v8 row_v9
    global col_v1 col_v2 col_v3 col_v4 col_v5 col_v6 col_v7 col_v8 col_v9
    global box1 box2 box3 box4 box5 box6 box7 box8 box9

    
    switch $blk {
        "2" {
                set row_v1 [lreplace $row_v1 3 3 [lindex $box2 0]]
                set row_v1 [lreplace $row_v1 4 4 [lindex $box2 1]]
                set row_v1 [lreplace $row_v1 5 5 [lindex $box2 2]]
                set row_v2 [lreplace $row_v2 3 3 [lindex $box2 3]]
                set row_v2 [lreplace $row_v2 4 4 [lindex $box2 4]]
                set row_v2 [lreplace $row_v2 5 5 [lindex $box2 5]]
                set row_v3 [lreplace $row_v3 3 3 [lindex $box2 6]]
                set row_v3 [lreplace $row_v3 4 4 [lindex $box2 7]]
                set row_v3 [lreplace $row_v3 5 5 [lindex $box2 8]]
                ## set col info
                set col_v4 [lreplace $col_v4 0 0 [lindex $box2 0]]
                set col_v5 [lreplace $col_v5 0 0 [lindex $box2 1]]
                set col_v6 [lreplace $col_v6 0 0 [lindex $box2 2]]
                set col_v4 [lreplace $col_v4 1 1 [lindex $box2 3]]
                set col_v5 [lreplace $col_v5 1 1 [lindex $box2 4]]
                set col_v6 [lreplace $col_v6 1 1 [lindex $box2 5]]
                set col_v4 [lreplace $col_v4 2 2 [lindex $box2 6]]
                set col_v5 [lreplace $col_v5 2 2 [lindex $box2 7]]
                set col_v6 [lreplace $col_v6 2 2 [lindex $box2 8]]
            }
        "3" {
                set row_v1 [lreplace $row_v1 6 6 [lindex $box3 0]]
                set row_v1 [lreplace $row_v1 7 7 [lindex $box3 1]]
                set row_v1 [lreplace $row_v1 8 8 [lindex $box3 2]]
                set row_v2 [lreplace $row_v2 6 6 [lindex $box3 3]]
                set row_v2 [lreplace $row_v2 7 7 [lindex $box3 4]]
                set row_v2 [lreplace $row_v2 8 8 [lindex $box3 5]]
                set row_v3 [lreplace $row_v3 6 6 [lindex $box3 6]]
                set row_v3 [lreplace $row_v3 7 7 [lindex $box3 7]]
                set row_v3 [lreplace $row_v3 8 8 [lindex $box3 8]]
                ## set col info
                set col_v7 [lreplace $col_v7 0 0 [lindex $box3 0]]
                set col_v8 [lreplace $col_v8 0 0 [lindex $box3 1]]
                set col_v9 [lreplace $col_v9 0 0 [lindex $box3 2]]
                set col_v7 [lreplace $col_v7 1 1 [lindex $box3 3]]
                set col_v8 [lreplace $col_v8 1 1 [lindex $box3 4]]
                set col_v9 [lreplace $col_v9 1 1 [lindex $box3 5]]
                set col_v7 [lreplace $col_v7 2 2 [lindex $box3 6]]
                set col_v8 [lreplace $col_v8 2 2 [lindex $box3 7]]
                set col_v9 [lreplace $col_v9 2 2 [lindex $box3 8]]
        }
        "4" {
                set row_v4 [lreplace $row_v4 0 0 [lindex $box4 0]]
                set row_v4 [lreplace $row_v4 1 1 [lindex $box4 1]]
                set row_v4 [lreplace $row_v4 2 2 [lindex $box4 2]]
                set row_v5 [lreplace $row_v5 0 0 [lindex $box4 3]]
                set row_v5 [lreplace $row_v5 1 1 [lindex $box4 4]]
                set row_v5 [lreplace $row_v5 2 2 [lindex $box4 5]]
                set row_v6 [lreplace $row_v6 0 0 [lindex $box4 6]]
                set row_v6 [lreplace $row_v6 1 1 [lindex $box4 7]]
                set row_v6 [lreplace $row_v6 2 2 [lindex $box4 8]]
                ## set col info
                set col_v1 [lreplace $col_v1 3 3 [lindex $box4 0]]
                set col_v2 [lreplace $col_v2 3 3 [lindex $box4 1]]
                set col_v3 [lreplace $col_v3 3 3 [lindex $box4 2]]
                set col_v1 [lreplace $col_v1 4 4 [lindex $box4 3]]
                set col_v2 [lreplace $col_v2 4 4 [lindex $box4 4]]
                set col_v3 [lreplace $col_v3 4 4 [lindex $box4 5]]
                set col_v1 [lreplace $col_v1 5 5 [lindex $box4 6]]
                set col_v2 [lreplace $col_v2 5 5 [lindex $box4 7]]
                set col_v3 [lreplace $col_v3 5 5 [lindex $box4 8]]
        }
        "5" {
                set row_v4 [lreplace $row_v4 3 3 [lindex $box5 0]]
                set row_v4 [lreplace $row_v4 4 4 [lindex $box5 1]]
                set row_v4 [lreplace $row_v4 5 5 [lindex $box5 2]]
                set row_v5 [lreplace $row_v5 3 3 [lindex $box5 3]]
                set row_v5 [lreplace $row_v5 4 4 [lindex $box5 4]]
                set row_v5 [lreplace $row_v5 5 5 [lindex $box5 5]]
                set row_v6 [lreplace $row_v6 3 3 [lindex $box5 6]]
                set row_v6 [lreplace $row_v6 4 4 [lindex $box5 7]]
                set row_v6 [lreplace $row_v6 5 5 [lindex $box5 8]]
                ## set col info
                set col_v4 [lreplace $col_v4 3 3 [lindex $box5 0]]
                set col_v5 [lreplace $col_v5 3 3 [lindex $box5 1]]
                set col_v6 [lreplace $col_v6 3 3 [lindex $box5 2]]
                set col_v4 [lreplace $col_v4 4 4 [lindex $box5 3]]
                set col_v5 [lreplace $col_v5 4 4 [lindex $box5 4]]
                set col_v6 [lreplace $col_v6 4 4 [lindex $box5 5]]
                set col_v4 [lreplace $col_v4 5 5 [lindex $box5 6]]
                set col_v5 [lreplace $col_v5 5 5 [lindex $box5 7]]
                set col_v6 [lreplace $col_v6 5 5 [lindex $box5 8]]
        }
        "6" {
                set row_v4 [lreplace $row_v4 6 6 [lindex $box6 0]]
                set row_v4 [lreplace $row_v4 7 7 [lindex $box6 1]]
                set row_v4 [lreplace $row_v4 8 8 [lindex $box6 2]]
                set row_v5 [lreplace $row_v5 6 6 [lindex $box6 3]]
                set row_v5 [lreplace $row_v5 7 7 [lindex $box6 4]]
                set row_v5 [lreplace $row_v5 8 8 [lindex $box6 5]]
                set row_v6 [lreplace $row_v6 6 6 [lindex $box6 6]]
                set row_v6 [lreplace $row_v6 7 7 [lindex $box6 7]]
                set row_v6 [lreplace $row_v6 8 8 [lindex $box6 8]]
                ## set col info
                set col_v7 [lreplace $col_v7 3 3 [lindex $box6 0]]
                set col_v8 [lreplace $col_v8 3 3 [lindex $box6 1]]
                set col_v9 [lreplace $col_v9 3 3 [lindex $box6 2]]
                set col_v7 [lreplace $col_v7 4 4 [lindex $box6 3]]
                set col_v8 [lreplace $col_v8 4 4 [lindex $box6 4]]
                set col_v9 [lreplace $col_v9 4 4 [lindex $box6 5]]
                set col_v7 [lreplace $col_v7 5 5 [lindex $box6 6]]
                set col_v8 [lreplace $col_v8 5 5 [lindex $box6 7]]
                set col_v9 [lreplace $col_v9 5 5 [lindex $box6 8]]
        }
        "7" {
                set row_v7 [lreplace $row_v7 0 0 [lindex $box7 0]]
                set row_v7 [lreplace $row_v7 1 1 [lindex $box7 1]]
                set row_v7 [lreplace $row_v7 2 2 [lindex $box7 2]]
                set row_v8 [lreplace $row_v8 0 0 [lindex $box7 3]]
                set row_v8 [lreplace $row_v8 1 1 [lindex $box7 4]]
                set row_v8 [lreplace $row_v8 2 2 [lindex $box7 5]]
                set row_v9 [lreplace $row_v9 0 0 [lindex $box7 6]]
                set row_v9 [lreplace $row_v9 1 1 [lindex $box7 7]]
                set row_v9 [lreplace $row_v9 2 2 [lindex $box7 8]]
                ## set col info
                set col_v1 [lreplace $col_v1 6 6 [lindex $box7 0]]
                set col_v2 [lreplace $col_v2 6 6 [lindex $box7 1]]
                set col_v3 [lreplace $col_v3 6 6 [lindex $box7 2]]
                set col_v1 [lreplace $col_v1 7 7 [lindex $box7 3]]
                set col_v2 [lreplace $col_v2 7 7 [lindex $box7 4]]
                set col_v3 [lreplace $col_v3 7 7 [lindex $box7 5]]
                set col_v1 [lreplace $col_v1 8 8 [lindex $box7 6]]
                set col_v2 [lreplace $col_v2 8 8 [lindex $box7 7]]
                set col_v3 [lreplace $col_v3 8 8 [lindex $box7 8]]
        }
        "8" {
                set row_v7 [lreplace $row_v7 3 3 [lindex $box8 0]]
                set row_v7 [lreplace $row_v7 4 4 [lindex $box8 1]]
                set row_v7 [lreplace $row_v7 5 5 [lindex $box8 2]]
                set row_v8 [lreplace $row_v8 3 3 [lindex $box8 3]]
                set row_v8 [lreplace $row_v8 4 4 [lindex $box8 4]]
                set row_v8 [lreplace $row_v8 5 5 [lindex $box8 5]]
                set row_v9 [lreplace $row_v9 3 3 [lindex $box8 6]]
                set row_v9 [lreplace $row_v9 4 4 [lindex $box8 7]]
                set row_v9 [lreplace $row_v9 5 5 [lindex $box8 8]]
                ## set col info
                set col_v4 [lreplace $col_v4 6 6 [lindex $box8 0]]
                set col_v5 [lreplace $col_v5 6 6 [lindex $box8 1]]
                set col_v6 [lreplace $col_v6 6 6 [lindex $box8 2]]
                set col_v4 [lreplace $col_v4 7 7 [lindex $box8 3]]
                set col_v5 [lreplace $col_v5 7 7 [lindex $box8 4]]
                set col_v6 [lreplace $col_v6 7 7 [lindex $box8 5]]
                set col_v4 [lreplace $col_v4 8 8 [lindex $box8 6]]
                set col_v5 [lreplace $col_v5 8 8 [lindex $box8 7]]
                set col_v6 [lreplace $col_v6 8 8 [lindex $box8 8]]
        }
        "9" {
                set row_v7 [lreplace $row_v7 6 6 [lindex $box9 0]]
                set row_v7 [lreplace $row_v7 7 7 [lindex $box9 1]]
                set row_v7 [lreplace $row_v7 8 8 [lindex $box9 2]]
                set row_v8 [lreplace $row_v8 6 6 [lindex $box9 3]]
                set row_v8 [lreplace $row_v8 7 7 [lindex $box9 4]]
                set row_v8 [lreplace $row_v8 8 8 [lindex $box9 5]]
                set row_v9 [lreplace $row_v9 6 6 [lindex $box9 6]]
                set row_v9 [lreplace $row_v9 7 7 [lindex $box9 7]]
                set row_v9 [lreplace $row_v9 8 8 [lindex $box9 8]]
                ## set col info
                set col_v7 [lreplace $col_v7 6 6 [lindex $box9 0]]
                set col_v8 [lreplace $col_v8 6 6 [lindex $box9 1]]
                set col_v9 [lreplace $col_v9 6 6 [lindex $box9 2]]
                set col_v7 [lreplace $col_v7 7 7 [lindex $box9 3]]
                set col_v8 [lreplace $col_v8 7 7 [lindex $box9 4]]
                set col_v9 [lreplace $col_v9 7 7 [lindex $box9 5]]
                set col_v7 [lreplace $col_v7 8 8 [lindex $box9 6]]
                set col_v8 [lreplace $col_v8 8 8 [lindex $box9 7]]
                set col_v9 [lreplace $col_v9 8 8 [lindex $box9 8]]
        }
        default {puts "ERROR: out of range block in rc_update"; return -1}
    }   
    
    if {$dbg == 1} {
        puts "Row Colum update for block $blk produceds:"
        puts "row1:  $row_v1"
        puts "row2:  $row_v2"
        puts "row3:  $row_v3"
        puts "row4:  $row_v4"
        puts "row5:  $row_v5"
        puts "row6:  $row_v6"
        puts "row7:  $row_v7"
        puts "row8:  $row_v8"
        puts "row9:  $row_v9"
        puts "col1:  $col_v1"
        puts "col2:  $col_v2"
        puts "col3:  $col_v3"
        puts "col4:  $col_v4"
        puts "col5:  $col_v5"
        puts "col6:  $col_v6"
        puts "col7:  $col_v7"
        puts "col8:  $col_v8"
        puts "col9:  $col_v9"
    }
    
}


###########################################################################
###   Proc to generate the board
##   Generates the board based on the game number specified in gnumb
##     returns 1 if ok  -1 if not ok
##     Input:   debug messaging on 1  off other
proc generate {dbg} {
    global row_v1 row_v2 row_v3 row_v4 row_v5 row_v6 row_v7 row_v8 row_v9
    global col_v1 col_v2 col_v3 col_v4 col_v5 col_v6 col_v7 col_v8 col_v9
    global box1 box2 box3 box4 box5 box6 box7 box8 box9
    global try_cnt gnumb usr_txt mx_gamenum
    
    set gn [$gnumb get]
    ## deal with user input above max game limit.
    if {$gn > $mx_gamenum} {
	    set gn $mx_gamenum
	    $gnumb delete 0 end
	    $gnumb insert 0 $mx_gamenum
    }
    
    set dho [expr {srand ($gn)}]
    set usr_txt "Generating "
    update
    
    set row_v1 {0 0 0 0 0 0 0 0 0}
    set row_v2 {0 0 0 0 0 0 0 0 0}
    set row_v3 {0 0 0 0 0 0 0 0 0}
    set row_v4 {0 0 0 0 0 0 0 0 0}
    set row_v5 {0 0 0 0 0 0 0 0 0}
    set row_v6 {0 0 0 0 0 0 0 0 0}
    set row_v7 {0 0 0 0 0 0 0 0 0}
    set row_v8 {0 0 0 0 0 0 0 0 0}
    set row_v9 {0 0 0 0 0 0 0 0 0}
    
    set col_v1 {0 0 0 0 0 0 0 0 0}
    set col_v2 {0 0 0 0 0 0 0 0 0}
    set col_v3 {0 0 0 0 0 0 0 0 0}
    set col_v4 {0 0 0 0 0 0 0 0 0}
    set col_v5 {0 0 0 0 0 0 0 0 0}
    set col_v6 {0 0 0 0 0 0 0 0 0}
    set col_v7 {0 0 0 0 0 0 0 0 0}
    set col_v8 {0 0 0 0 0 0 0 0 0}
    set col_v9 {0 0 0 0 0 0 0 0 0}
    
    #
    #     box1  box2  box3
    #     box4  box5  box6
    #     box7  box8  box9
    #
    # box1 = row_v1(0-2)
    # box1 = row_v2(0-2)
    # box1 = row_v3(0-2)
    set box1 {0 0 0 0 0 0 0 0 0}
    set box2 {0 0 0 0 0 0 0 0 0}
    set box3 {0 0 0 0 0 0 0 0 0}
    set box4 {0 0 0 0 0 0 0 0 0}
    set box5 {0 0 0 0 0 0 0 0 0}
    set box6 {0 0 0 0 0 0 0 0 0}
    set box7 {0 0 0 0 0 0 0 0 0}
    set box8 {0 0 0 0 0 0 0 0 0}
    set box9 {0 0 0 0 0 0 0 0 0}

    # Generate box1, the start of the pattern gen
    #  Box1 gen is not dependent on other row col,
    #    as there are none.
    set str ""
    
    for {set i 0} {$i < 9} {incr i} {
        set value [expr { int(rand() * 9) + 1}]
        set f [string first $value $str]
        while {$f >= 0} {
            set value [expr { int(rand() * 9) + 1}]
            set f [string first $value $str]
        }
        lappend str $value
    }
    set usr_txt "Generating ."
    update
    #puts $str
    set box1 $str
    ##  set row info
    set row_v1 [lreplace $row_v1 0 0 [lindex $box1 0]]
    set row_v1 [lreplace $row_v1 1 1 [lindex $box1 1]]
    set row_v1 [lreplace $row_v1 2 2 [lindex $box1 2]]
    set row_v2 [lreplace $row_v2 0 0 [lindex $box1 3]]
    set row_v2 [lreplace $row_v2 1 1 [lindex $box1 4]]
    set row_v2 [lreplace $row_v2 2 2 [lindex $box1 5]]
    set row_v3 [lreplace $row_v3 0 0 [lindex $box1 6]]
    set row_v3 [lreplace $row_v3 1 1 [lindex $box1 7]]
    set row_v3 [lreplace $row_v3 2 2 [lindex $box1 8]]
    ## set col info
    set col_v1 [lreplace $col_v1 0 0 [lindex $box1 0]]
    set col_v2 [lreplace $col_v2 0 0 [lindex $box1 1]]
    set col_v3 [lreplace $col_v3 0 0 [lindex $box1 2]]
    set col_v1 [lreplace $col_v1 1 1 [lindex $box1 3]]
    set col_v2 [lreplace $col_v2 1 1 [lindex $box1 4]]
    set col_v3 [lreplace $col_v3 1 1 [lindex $box1 5]]
    set col_v1 [lreplace $col_v1 2 2 [lindex $box1 6]]
    set col_v2 [lreplace $col_v2 2 2 [lindex $box1 7]]
    set col_v3 [lreplace $col_v3 2 2 [lindex $box1 8]]

    
    set done -1
    set gen_attempt 0
    ##  the big while loop
    while {$done == -1} {
        ## if we done this too many times.
        if {$gen_attempt == 128} {
            return -1
        } else {
            incr gen_attempt
        }
        
        ## clear the box values
        set box2 {0 0 0 0 0 0 0 0 0}
        set box3 {0 0 0 0 0 0 0 0 0}
        set box4 {0 0 0 0 0 0 0 0 0}
        set box5 {0 0 0 0 0 0 0 0 0}
        set box6 {0 0 0 0 0 0 0 0 0}
        set box7 {0 0 0 0 0 0 0 0 0}
        set box8 {0 0 0 0 0 0 0 0 0}
        set box9 {0 0 0 0 0 0 0 0 0}
        ## update row and colum info
        for {set i 2} {$i < 10} {incr i} {
            rc_update $i 0
        }
        ###################################################################
        ##   Block 2
        set str -1
        set tries 0
            ## block 2 now
        while {$str == -1 && $tries <= $try_cnt} {
            set str [gen_block 2]
            if {$str != -1} {
                set box2 $str
            }
            incr tries
            #puts "gen_block 2 return: $str"
        ##  end while
        }
        if {$tries > $try_cnt} {
            continue
        }
        
        set usr_txt "Generating .."
        update
        #dbg_msg $str
        set rtn [rc_update 2 $dbg]
        ###################################################################
        ##   Block 3
        set str -1
        set tries 0
            ## block 3 now
        while {$str == -1 && $tries <= $try_cnt} {
            set str [gen_block 3]
            if {$str != -1} {
                set box3 $str
            }
            incr tries
            #puts "gen_block 3 return: $str"
        }
        if {$tries > $try_cnt} {
            continue
        }
        
        set usr_txt "Generating ..."
        update
        #dbg_msg $str
        set rtn [rc_update 3 $dbg]
        
    
        ################################################################
        ##  block 4
        set str -1
        set tries 0
            ## block 4 now
        while {$str == -1 && $tries <= $try_cnt} {
            set str [gen_block 4]
            if {$str != -1} {
                set box4 $str
            }
            incr tries
            #puts "gen_block 4 return: $str"
        }
        if {$tries > $try_cnt} {
            continue
        }
        
        set usr_txt "Generating ...."
        update
        #dbg_msg $str
        set rtn [rc_update 4 $dbg]
        
        
        ################################################################
        ##  block 5
        set str -1
        set tries 0
            ## block 5 now
        while {$str == -1 && $tries <= $try_cnt} {
            set str [gen_block 5]
            if {$str != -1} {
                set box5 $str
            }
            incr tries
            #puts "gen_block 5 return: $str"
        }
        if {$tries > $try_cnt} {
            continue
        }
        
        set usr_txt "Generating ....."
        update
        #dbg_msg $str
        set rtn [rc_update 5 $dbg]
        
    
        ################################################################
        ##  block 6
        set str -1
        set tries 0
            ## block 6 now
        while {$str == -1 && $tries <= $try_cnt} {
            set str [gen_block 6]
            if {$str != -1} {
                set box6 $str
            }
            incr tries
            #puts "gen_block 6 return: $str"
        }
        if {$tries > $try_cnt} {
            continue
        }
        
        set usr_txt "Generating ......"
        update
        #dbg_msg $str
        set rtn [rc_update 6 $dbg]
        
    
        ################################################################
        ##  block 7
        set str -1
        set tries 0
            ## block 7 now
        while {$str == -1 && $tries <= $try_cnt} {
            set str [gen_block 7]
            if {$str != -1} {
                set box7 $str
            }
            incr tries
            #puts "gen_block 7 return: $str"
        }
        if {$tries > $try_cnt} {
            continue
        }
        
        set usr_txt "Generating ......."
        update
        #dbg_msg $str
        set rtn [rc_update 7 $dbg]
        
        
        ################################################################
        ##  block 8
        set str -1
        set tries 0
            ## block 8 now
        while {$str == -1 && $tries <= $try_cnt} {
            set str [gen_block 8]
            if {$str != -1} {
                set box8 $str
            }
            incr tries
            #puts "gen_block 8 return: $str"
        }
        if {$tries > $try_cnt} {
            continue
        }
        
        set usr_txt "Generating ........"
        update
        #dbg_msg $str
        set rtn [rc_update 8 $dbg]
        
    
        ################################################################
        ##  block 9
        set str -1
        set tries 0
            ## block 9 now
        while {$str == -1 && $tries <= $try_cnt} {
            set str [gen_block 9]
            if {$str != -1} {
                set box9 $str
            }
            #puts "gen_block 9 return: $str  On try: $tries"
            incr tries
        }
        if {$tries > $try_cnt} {
            continue
        }
        
        set usr_txt "Generation Done !!"
        #dbg_msg $str
        set rtn [rc_update 9 $dbg]
        set done 1
    ## end while
    }
    return 1
  ##  End of generate proc
}

###########################################################
##   Proc to load the start board with numbers and disable entries
proc load_start_board {dbg} {
    global vrow_v1 vrow_v2 vrow_v3 vrow_v4 vrow_v5 vrow_v6 vrow_v7 vrow_v8 vrow_v9
    global row_v1 row_v2 row_v3 row_v4 row_v5 row_v6 row_v7 row_v8 row_v9
    
    board_init
    
    # go through all the locations
    for {set i 1} {$i < 10} {incr i} {
        switch $i {
            "1" {set vrow $vrow_v1; set row $row_v1}
            "2" {set vrow $vrow_v2; set row $row_v2}
            "3" {set vrow $vrow_v3; set row $row_v3}
            "4" {set vrow $vrow_v4; set row $row_v4}
            "5" {set vrow $vrow_v5; set row $row_v5}
            "6" {set vrow $vrow_v6; set row $row_v6}
            "7" {set vrow $vrow_v7; set row $row_v7}
            "8" {set vrow $vrow_v8; set row $row_v8}
            "9" {set vrow $vrow_v9; set row $row_v9}
        }
        
        for {set j 0} {$j < 9} {incr j} {
            set c [lindex $vrow $j]
            if {$c == 1} {
                set rc $i
                append rc [expr {$j + 1}]
                set ent [get_ptr $rc]
                set val [lindex $row $j]
                $ent delete 0 end
                $ent insert 0 $val
                $ent configure -state readonly
            }
        }
    }
}

#########################################
##  Proc to gen the visible numbers matrix
##
proc gen_shown {m dbg} {
    global vrow_v1 vrow_v2 vrow_v3 vrow_v4 vrow_v5 vrow_v6 vrow_v7 vrow_v8 vrow_v9
    global row_v1 row_v2 row_v3 row_v4 row_v5 row_v6 row_v7 row_v8 row_v9
    global col_v1 col_v2 col_v3 col_v4 col_v5 col_v6 col_v7 col_v8 col_v9
    global box1 tries
    global glevel usr_txt effort_level logfn
    ## initialize
    set vrow_v1 {0 0 0 0 0 0 0 0 0}
    set vrow_v2 {0 0 0 0 0 0 0 0 0}
    set vrow_v3 {0 0 0 0 0 0 0 0 0}
    set vrow_v4 {0 0 0 0 0 0 0 0 0}
    set vrow_v5 {0 0 0 0 0 0 0 0 0}
    set vrow_v6 {0 0 0 0 0 0 0 0 0}
    set vrow_v7 {0 0 0 0 0 0 0 0 0}
    set vrow_v8 {0 0 0 0 0 0 0 0 0}
    set vrow_v9 {0 0 0 0 0 0 0 0 0}
    
    # get random gen initialized
    set seed [lindex $box1 0]
    set lv [$glevel get]
    #set seed [expr {$lv + $seed}]
    set dho [expr {srand ($seed)}]

    switch $lv {
        "1" {set shown 33}
        "2" {set shown 32}
        "3" {set shown 31}
        "4" {set shown 30}
        "5" {set shown 29}
        "6" {set shown 28}
        "7" {set shown 27}
        "8" {set shown 26}
    }
    
    
    if {$m == 3} {
	    ##dbg_msg  "we here"
        ###########################################################
        ## Forth attempt at generation
        set rtn 1
        set tries 1
        while {$rtn > 0 & $tries < $effort_level} {
            
            set slist {}
            set side_list {}
            
            set r [expr { int(rand() * 9) + 1}]
            set c [expr { int(rand() * 9) + 1}]
            set loc $r
            append loc $c
            lappend slist $loc
            set side_list [get_adj $loc $side_list 0 $lv]
            #puts "show list is: $slist\nadjacent: $side_list"
            for {set i 1} {$i < $shown} {incr i} {
                set ok 1
                set bok 1
                # generate the shown numbers matrix
                #    ensure duplicate locations are not picked
                while {$ok >= 0 | $bok >= 0} {
                    set r [expr { int(rand() * 9) + 1}]
                    set c [expr { int(rand() * 9) + 1}]
                    set loc $r
                    append loc $c
                    set ok [lsearch $slist $loc]
                    set bok [lsearch $side_list $loc]
                    #dbg_msg "$slist $loc $ok"
                }
                lappend slist $loc
                set side_list [get_adj $loc $side_list $i $lv]
                ##puts $slist
            }
            ## check if solvable
            ##if {$lv < 8} {
                set rtn [pre_check_gen $slist 0]
            ##} else {
            ##    set rtn [pre_check_gen_a $slist 0]
            ##}
            ## indication to the user
            set usr_txt "Generating Show $tries"
            update
            incr tries
        }
        
        ## if it was solved
        if {$rtn == 0} {
	        
##            set logfn [open "test_log.txt" a]
            #puts $logfn "Generation tries: $tries for level: $lv"
##	        close $logfn
	        
            ## set up the show list
            foreach l $slist {
                
                set loc [split $l ""]
                set r [lindex $loc 0]
                set c [lindex $loc 1]
                set c [expr $c - 1]
                ##dbg_msg "$r $c $loc $l"
                
                switch $r {
                    "1" {set vrow_v1 [lreplace $vrow_v1 $c $c 1]}
                    "2" {set vrow_v2 [lreplace $vrow_v2 $c $c 1]}
                    "3" {set vrow_v3 [lreplace $vrow_v3 $c $c 1]}
                    "4" {set vrow_v4 [lreplace $vrow_v4 $c $c 1]}
                    "5" {set vrow_v5 [lreplace $vrow_v5 $c $c 1]}
                    "6" {set vrow_v6 [lreplace $vrow_v6 $c $c 1]}
                    "7" {set vrow_v7 [lreplace $vrow_v7 $c $c 1]}
                    "8" {set vrow_v8 [lreplace $vrow_v8 $c $c 1]}
                    "9" {set vrow_v9 [lreplace $vrow_v9 $c $c 1]}
                }
            }
        } else {
    	    return 1
        }
	    
	    
	    
    } else {
        ###########################################################
        ##  Third attempt at generation
        set rtn 1
        set tries 1
        while {$rtn > 0 & $tries < $effort_level} {
            
            set slist {}
            
            set r [expr { int(rand() * 9) + 1}]
            set c [expr { int(rand() * 9) + 1}]
            set loc $r
            append loc $c
            lappend slist $loc
            for {set i 1} {$i < $shown} {incr i} {
                set ok 1
                # generate the shown numbers matrix
                #    ensure duplicate locations are not picked
                while {$ok >= 0} {
                    set r [expr { int(rand() * 9) + 1}]
                    set c [expr { int(rand() * 9) + 1}]
                    set loc $r
                    append loc $c
                    set ok [lsearch $slist $loc]
                    #dbg_msg "$slist $loc $ok"
                }
                lappend slist $loc
                ##puts $slist
            }
            ## check if solvable
            set rtn [pre_check_gen $slist 0]
            ## indication to the user
            set usr_txt "Generating Show $tries"
            update
            incr tries
        }
        
        ## if it was solved
        if {$rtn == 0} {
            ## set up the show list
            foreach l $slist {
                
                set loc [split $l ""]
                set r [lindex $loc 0]
                set c [lindex $loc 1]
                set c [expr $c - 1]
                ##dbg_msg "$r $c $loc $l"
                
                switch $r {
                    "1" {set vrow_v1 [lreplace $vrow_v1 $c $c 1]}
                    "2" {set vrow_v2 [lreplace $vrow_v2 $c $c 1]}
                    "3" {set vrow_v3 [lreplace $vrow_v3 $c $c 1]}
                    "4" {set vrow_v4 [lreplace $vrow_v4 $c $c 1]}
                    "5" {set vrow_v5 [lreplace $vrow_v5 $c $c 1]}
                    "6" {set vrow_v6 [lreplace $vrow_v6 $c $c 1]}
                    "7" {set vrow_v7 [lreplace $vrow_v7 $c $c 1]}
                    "8" {set vrow_v8 [lreplace $vrow_v8 $c $c 1]}
                    "9" {set vrow_v9 [lreplace $vrow_v9 $c $c 1]}
                }
            }
        } else {
    	    return 1
        }
    }
    # some debug assistance
    if {$dbg == 2} {
        set vrow_v1 {1 1 1 1 1 1 1 1 1}
        set vrow_v2 {1 0 1 1 1 1 1 1 1}
        set vrow_v3 {1 1 1 1 1 1 1 1 1}
        set vrow_v4 {1 1 1 1 1 1 1 1 1}
        set vrow_v5 {1 1 1 1 1 1 1 1 1}
        set vrow_v6 {1 1 1 1 1 1 1 1 1}
        set vrow_v7 {1 0 1 1 1 1 1 1 1}
        set vrow_v8 {1 1 1 1 1 1 1 1 1}
        set vrow_v9 {1 1 1 1 1 1 1 1 1}
    }
    
    if {$dbg >= 1} {
        puts "Row1 Enables: $vrow_v1"
        puts "Row2 Enables: $vrow_v2"
        puts "Row3 Enables: $vrow_v3"
        puts "Row4 Enables: $vrow_v4"
        puts "Row5 Enables: $vrow_v5"
        puts "Row6 Enables: $vrow_v6"
        puts "Row7 Enables: $vrow_v7"
        puts "Row8 Enables: $vrow_v8"
        puts "Row9 Enables: $vrow_v9"
    }
    return 0
}

#########################
##  get the adjasent locs not diagnal
proc get_adj { loc lst cnt level } {
	
	
	if {$level < 5 } {
	    if {$cnt > 14} {
	        return $lst
	    }
	} else {
	    if {$cnt > 15} {
	        return $lst
	    }
	}
	
	
	set sloc [split $loc ""]
	set r [lindex $sloc 0]
	set c [lindex $sloc 1]
	set rlst $lst
	
	if {$r > 1} {
		set l ""
		append l [expr {$r - 1}]
		append l $c
		lappend rlst $l
	}
	
	if {$r < 9} {
		set l ""
		append l [expr {$r + 1}]
		append l $c
		lappend rlst $l
	}
	if {$c > 1} {
		set l ""
		append l $r
		append l [expr {$c - 1}]
		lappend rlst $l
	}
	if {$c < 9} {
		set l ""
		append l $r
		append l [expr {$c + 1}]
		lappend rlst $l
	}
	#dbg_msg "loc: $loc  side: $rlst"
	return $rlst
}

#############################################################
## stop game proc
proc stop_game {dbg} {
    global tm_on start_time usr_txt
    
    ## use timer on to tell if game running
    if {$tm_on == 0} {
	    return 1
    }
    
    
    set usr_txt "Game Finished .. Checking"
    # call check routen
    set rtn [check_gen $dbg]
    if {$rtn == 1} {
        set usr_txt "Check Passed!!"
        dbg_msg "Congratulations!!!!\n You did it!!"
        update_stats
        # stop the timer
        set tm_on 0
    } else {
        dbg_msg "Sorry but it did not match the\n genrated results!! \n Will now test for aternate solution."
        set chk [check_brd 1]
        puts "check was $chk"
        if {$chk < 0} {
            dbg_msg "Sorry your entry is not correct.\n See message text for clue."    
            set usr_txt "Game Running .. Keep Trying!!"    
        } else {
            dbg_msg "Alternate Solution Found !!!!\n Congatulations!!"    
            set usr_txt "Ready to start another!!"
            set tm_on 0
            update_stats
        }
    }
}

#############################################################
##  Check board for generated layout.
##    Run if stop game and board compare not as generated.
proc check_brd {dbg} {
    global usr_txt
    
    ## get the rows
    set br1 [fetch_row 1]
    set br2 [fetch_row 2]
    set br3 [fetch_row 3]
    set br4 [fetch_row 4]
    set br5 [fetch_row 5]
    set br6 [fetch_row 6]
    set br7 [fetch_row 7]
    set br8 [fetch_row 8]
    set br9 [fetch_row 9]
    
    set brs {}
    
    lappend brs $br1 $br2 $br3 $br4 $br5 $br6 $br7 $br8 $br9
    
    set rn  1
    foreach l $brs {
        set usr_txt "Checking Row $rn"
        update
        for {set i 0} {$i < 9} {incr i} {
            set v [expr {$i + 1}]
            set f [string first $v $l]
            #dbg_msg "$f  $v  : $l"
            if {$f < 0} {
                return -1
            }
        }
        incr rn
    }
    ## get the colums
    set bc1 [fetch_col 1]
    set bc2 [fetch_col 2]
    set bc3 [fetch_col 3]
    set bc4 [fetch_col 4]
    set bc5 [fetch_col 5]
    set bc6 [fetch_col 6]
    set bc7 [fetch_col 7]
    set bc8 [fetch_col 8]
    set bc9 [fetch_col 9]
    
    set bcs {}
    
    lappend bcs $bc1 $bc2 $bc3 $bc4 $bc5 $bc6 $bc7 $bc8 $bc9
    
    set cn 1
    foreach l $bcs {
        set usr_txt "Checking Colum $cn"
        update
        for {set i 0} {$i < 9} {incr i} {
            set v [expr {$i + 1}]
            set f [string first $v $l]
            #dbg_msg "$f  $v  : $l"
            if {$f < 0} {
                return -1
            }
        }
        incr cn
    }

    # get the boxs
    set bb1 [fetch_box 1]
    set bb2 [fetch_box 2]
    set bb3 [fetch_box 3]
    set bb4 [fetch_box 4]
    set bb5 [fetch_box 5]
    set bb6 [fetch_box 6]
    set bb7 [fetch_box 7]
    set bb8 [fetch_box 8]
    set bb9 [fetch_box 9]
    
    set bbs {}
    
    lappend bbs $bb1 $bb2 $bb3 $bb4 $bb5 $bb6 $bb7 $bb8 $bb9
    
    set bn 1
    foreach l $bbs {
        set usr_txt "Checking Box $bn"
        update
        for {set i 0} {$i < 9} {incr i} {
            set v [expr {$i + 1}]
            set f [string first $v $l]
            #dbg_msg "$f  $v  : $l"
            if {$f < 0} {
                return -1
            }
        }
        incr bn
    }
    ##  if we here all ok
    return 1
}

###########################################################
##  Fetch box from display
proc fetch_box {b} {
    ## based on box number set start of row and col
    switch $b {
        "1" {set r 1; set c 1}
        "2" {set r 1; set c 4}
        "3" {set r 1; set c 7}
        "4" {set r 4; set c 1}
        "5" {set r 4; set c 4}
        "6" {set r 4; set c 7}
        "7" {set r 7; set c 1}
        "8" {set r 7; set c 4}
        "9" {set r 7; set c 7}
    }
    
    set val {}
    for {set i $r} {$i < [expr {$r + 3}]} {incr i} {
        for {set j $c} {$j < [expr {$c + 3}]} {incr j} {
            set rc $i
            append rc $j
            set ent [get_ptr $rc]
            lappend val [$ent get]                  
        }
    }
    return $val
}

###########################################################
##  Fetch colum from display
proc fetch_col {c} {
    set val {}
    for {set i 1} {$i < 10} {incr i} {
        set rc $i
        append rc $c
        set ent [get_ptr $rc]
        lappend val [$ent get]      
    }
    return $val
}


###########################################################
##  Fetch row from display
proc fetch_row {r} {
    
    set val {}
    
    for {set i 1} {$i < 10} {incr i} {
        set rc $r
        append rc $i
        #dbg_msg $rc
        set ent [get_ptr $rc]
        lappend val [$ent get]
    }
    return $val
}


#############################################################
##  check against generated the current
proc check_gen {dbg} {
    global row_v1 row_v2 row_v3 row_v4 row_v5 row_v6 row_v7 row_v8 row_v9
    
    ##  row 1
    set curr [fetch_row 1]
    if {$curr != $row_v1} {
        return -1
    }
    ##  row 2
    set curr [fetch_row 2]
    if {$curr != $row_v2} {
        return -1
    }
    ##  row 3
    set curr [fetch_row 3]
    if {$curr != $row_v3} {
        return -1
    }
    ##  row 4
    set curr [fetch_row 4]
    if {$curr != $row_v4} {
        return -1
    }
    ##  row 5
    set curr [fetch_row 5]
    if {$curr != $row_v5} {
        return -1
    }
    ##  row 6
    set curr [fetch_row 6]
    if {$curr != $row_v6} {
        return -1
    }
    ##  row 7
    set curr [fetch_row 7]
    if {$curr != $row_v7} {
        return -1
    }
    ##  row 8
    set curr [fetch_row 8]
    if {$curr != $row_v8} {
        return -1
    }
    ##  row 9
    set curr [fetch_row 9]
    if {$curr != $row_v9} {
        return -1
    }
    
    return 1
}

##########################################################
##  check to see if it is solvable
proc pre_check_gen {lst dbg} {
    global row_v1 row_v2 row_v3 row_v4 row_v5 row_v6 row_v7 row_v8 row_v9
    global col_v1 col_v2 col_v3 col_v4 col_v5 col_v6 col_v7 col_v8 col_v9
    global box1 box2 box3 box4 box5 box6 box7 box8 box9

    ##    Set up internal variables  ####
    ##  Row values
    set r1 {0 0 0 0 0 0 0 0 0}
    set r2 {0 0 0 0 0 0 0 0 0}
    set r3 {0 0 0 0 0 0 0 0 0}
    set r4 {0 0 0 0 0 0 0 0 0}
    set r5 {0 0 0 0 0 0 0 0 0}
    set r6 {0 0 0 0 0 0 0 0 0}
    set r7 {0 0 0 0 0 0 0 0 0}
    set r8 {0 0 0 0 0 0 0 0 0}
    set r9 {0 0 0 0 0 0 0 0 0}
    ##  colum values
    set c1 {0 0 0 0 0 0 0 0 0}
    set c2 {0 0 0 0 0 0 0 0 0}
    set c3 {0 0 0 0 0 0 0 0 0}
    set c4 {0 0 0 0 0 0 0 0 0}
    set c5 {0 0 0 0 0 0 0 0 0}
    set c6 {0 0 0 0 0 0 0 0 0}
    set c7 {0 0 0 0 0 0 0 0 0}
    set c8 {0 0 0 0 0 0 0 0 0}
    set c9 {0 0 0 0 0 0 0 0 0}
    #  Box vaues
    #
    #     box1  box2  box3
    #     box4  box5  box6
    #     box7  box8  box9
    #
    # box1 = r1(0-2)
    # box1 = r2(0-2)
    # box1 = r3(0-2)
    set b1 {0 0 0 0 0 0 0 0 0}
    set b2 {0 0 0 0 0 0 0 0 0}
    set b3 {0 0 0 0 0 0 0 0 0}
    set b4 {0 0 0 0 0 0 0 0 0}
    set b5 {0 0 0 0 0 0 0 0 0}
    set b6 {0 0 0 0 0 0 0 0 0}
    set b7 {0 0 0 0 0 0 0 0 0}
    set b8 {0 0 0 0 0 0 0 0 0}
    set b9 {0 0 0 0 0 0 0 0 0}
    # the valid lists
    set v1 {}
    set v2 {}
    set v3 {}
    set v4 {}
    set v5 {}
    set v6 {}
    set v7 {}
    set v8 {}
    set v9 {}
    # create a sorted list
    set sort_lst [lsort -integer -increasing $lst]
    if {$dbg > 0} {
        puts "Here in pre_check_gen with:  $sort_lst"
    }
        
    foreach l $sort_lst {
        # get the row and col and creat indexs
        set s_l [split $l ""]
        set r [lindex $s_l 0]
        set r_i [expr {$r - 1}]
        set c [lindex $s_l 1]
        set c_i [expr {$c - 1}]
        ## get the row values
        switch $r {
            "1" {set rvals $row_v1}
            "2" {set rvals $row_v2}
            "3" {set rvals $row_v3}
            "4" {set rvals $row_v4}
            "5" {set rvals $row_v5}
            "6" {set rvals $row_v6}
            "7" {set rvals $row_v7}
            "8" {set rvals $row_v8}
            "9" {set rvals $row_v9}
        }
        ## get the value
        set val [lindex $rvals $c_i]
        # set local row
        switch $r {
            "1" {set r1 [lreplace $r1 $c_i $c_i $val]}
            "2" {set r2 [lreplace $r2 $c_i $c_i $val]}
            "3" {set r3 [lreplace $r3 $c_i $c_i $val]}
            "4" {set r4 [lreplace $r4 $c_i $c_i $val]}
            "5" {set r5 [lreplace $r5 $c_i $c_i $val]}
            "6" {set r6 [lreplace $r6 $c_i $c_i $val]}
            "7" {set r7 [lreplace $r7 $c_i $c_i $val]}
            "8" {set r8 [lreplace $r8 $c_i $c_i $val]}
            "9" {set r9 [lreplace $r9 $c_i $c_i $val]}
        }
        # set loacl col
        switch $c {
            "1" {set c1 [lreplace $c1 $r_i $r_i $val]}
            "2" {set c2 [lreplace $c2 $r_i $r_i $val]}
            "3" {set c3 [lreplace $c3 $r_i $r_i $val]}
            "4" {set c4 [lreplace $c4 $r_i $r_i $val]}
            "5" {set c5 [lreplace $c5 $r_i $r_i $val]}
            "6" {set c6 [lreplace $c6 $r_i $r_i $val]}
            "7" {set c7 [lreplace $c7 $r_i $r_i $val]}
            "8" {set c8 [lreplace $c8 $r_i $r_i $val]}
            "9" {set c9 [lreplace $c9 $r_i $r_i $val]}
        }
        # set box
        switch $r {
            "1" {switch $c {
                    "1" {set b1 [lreplace $b1 0 0 $val]}
                    "2" {set b1 [lreplace $b1 1 1 $val]}
                    "3" {set b1 [lreplace $b1 2 2 $val]}
                    "4" {set b2 [lreplace $b2 0 0 $val]}
                    "5" {set b2 [lreplace $b2 1 1 $val]}
                    "6" {set b2 [lreplace $b2 2 2 $val]}
                    "7" {set b3 [lreplace $b3 0 0 $val]}
                    "8" {set b3 [lreplace $b3 1 1 $val]}
                    "9" {set b3 [lreplace $b3 2 2 $val]}
                    }
               }
            "2" {switch $c {
                    "1" {set b1 [lreplace $b1 3 3 $val]}
                    "2" {set b1 [lreplace $b1 4 4 $val]}
                    "3" {set b1 [lreplace $b1 5 5 $val]}
                    "4" {set b2 [lreplace $b2 3 3 $val]}
                    "5" {set b2 [lreplace $b2 4 4 $val]}
                    "6" {set b2 [lreplace $b2 5 5 $val]}
                    "7" {set b3 [lreplace $b3 3 3 $val]}
                    "8" {set b3 [lreplace $b3 4 4 $val]}
                    "9" {set b3 [lreplace $b3 5 5 $val]}
                    }
               }
            "3" {switch $c {
                    "1" {set b1 [lreplace $b1 6 6 $val]}
                    "2" {set b1 [lreplace $b1 7 7 $val]}
                    "3" {set b1 [lreplace $b1 8 8 $val]}
                    "4" {set b2 [lreplace $b2 6 6 $val]}
                    "5" {set b2 [lreplace $b2 7 7 $val]}
                    "6" {set b2 [lreplace $b2 8 8 $val]}
                    "7" {set b3 [lreplace $b3 6 6 $val]}
                    "8" {set b3 [lreplace $b3 7 7 $val]}
                    "9" {set b3 [lreplace $b3 8 8 $val]}
                    }
               }
            "4" {switch $c {
                    "1" {set b4 [lreplace $b4 0 0 $val]}
                    "2" {set b4 [lreplace $b4 1 1 $val]}
                    "3" {set b4 [lreplace $b4 2 2 $val]}
                    "4" {set b5 [lreplace $b5 0 0 $val]}
                    "5" {set b5 [lreplace $b5 1 1 $val]}
                    "6" {set b5 [lreplace $b5 2 2 $val]}
                    "7" {set b6 [lreplace $b6 0 0 $val]}
                    "8" {set b6 [lreplace $b6 1 1 $val]}
                    "9" {set b6 [lreplace $b6 2 2 $val]}
                    }
               }
            "5" {switch $c {
                    "1" {set b4 [lreplace $b4 3 3 $val]}
                    "2" {set b4 [lreplace $b4 4 4 $val]}
                    "3" {set b4 [lreplace $b4 5 5 $val]}
                    "4" {set b5 [lreplace $b5 3 3 $val]}
                    "5" {set b5 [lreplace $b5 4 4 $val]}
                    "6" {set b5 [lreplace $b5 5 5 $val]}
                    "7" {set b6 [lreplace $b6 3 3 $val]}
                    "8" {set b6 [lreplace $b6 4 4 $val]}
                    "9" {set b6 [lreplace $b6 5 5 $val]}
                    }
               }
            "6" {switch $c {
                    "1" {set b4 [lreplace $b4 6 6 $val]}
                    "2" {set b4 [lreplace $b4 7 7 $val]}
                    "3" {set b4 [lreplace $b4 8 8 $val]}
                    "4" {set b5 [lreplace $b5 6 6 $val]}
                    "5" {set b5 [lreplace $b5 7 7 $val]}
                    "6" {set b5 [lreplace $b5 8 8 $val]}
                    "7" {set b6 [lreplace $b6 6 6 $val]}
                    "8" {set b6 [lreplace $b6 7 7 $val]}
                    "9" {set b6 [lreplace $b6 8 8 $val]}
                    }
               }
            "7" {switch $c {
                    "1" {set b7 [lreplace $b7 0 0 $val]}
                    "2" {set b7 [lreplace $b7 1 1 $val]}
                    "3" {set b7 [lreplace $b7 2 2 $val]}
                    "4" {set b8 [lreplace $b8 0 0 $val]}
                    "5" {set b8 [lreplace $b8 1 1 $val]}
                    "6" {set b8 [lreplace $b8 2 2 $val]}
                    "7" {set b9 [lreplace $b9 0 0 $val]}
                    "8" {set b9 [lreplace $b9 1 1 $val]}
                    "9" {set b9 [lreplace $b9 2 2 $val]}
                    }
               }
            "8" {switch $c {
                    "1" {set b7 [lreplace $b7 3 3 $val]}
                    "2" {set b7 [lreplace $b7 4 4 $val]}
                    "3" {set b7 [lreplace $b7 5 5 $val]}
                    "4" {set b8 [lreplace $b8 3 3 $val]}
                    "5" {set b8 [lreplace $b8 4 4 $val]}
                    "6" {set b8 [lreplace $b8 5 5 $val]}
                    "7" {set b9 [lreplace $b9 3 3 $val]}
                    "8" {set b9 [lreplace $b9 4 4 $val]}
                    "9" {set b9 [lreplace $b9 5 5 $val]}
                    }
               }
            "9" {switch $c {
                    "1" {set b7 [lreplace $b7 6 6 $val]}
                    "2" {set b7 [lreplace $b7 7 7 $val]}
                    "3" {set b7 [lreplace $b7 8 8 $val]}
                    "4" {set b8 [lreplace $b8 6 6 $val]}
                    "5" {set b8 [lreplace $b8 7 7 $val]}
                    "6" {set b8 [lreplace $b8 8 8 $val]}
                    "7" {set b9 [lreplace $b9 6 6 $val]}
                    "8" {set b9 [lreplace $b9 7 7 $val]}
                    "9" {set b9 [lreplace $b9 8 8 $val]}
                    }
               }
        }
        #puts "$b1\n$b2\n$b3\n$b4\n$b5\n$b6\n$b7\n$b8\n$b9\n"
        
    }
    ##  for debug  out put the sort.
    if {$dbg > 0} {
        puts "$r1\n$r2\n$r3\n$r4\n$r5\n$r6\n$r7\n$r8\n$r9\n"
        puts "$c1\n$c2\n$c3\n$c4\n$c5\n$c6\n$c7\n$c8\n$c9\n"
        puts "$b1\n$b2\n$b3\n$b4\n$b5\n$b6\n$b7\n$b8\n$b9\n"
    }
    
    set fail 0
    set count 0
    #############################################################
    ##  go though untill no solution

    while {$count < 3} {
    
        set fail 1
    
    #########################################################################
    ##   for each box  go through and caculate missing and update internal
    ##      lists 
    for {set b 1} {$b < 10} {incr b} {
        # reset vars
        set v1 {}
        set v2 {}
        set v3 {}
        set v4 {}
        set v5 {}
        set v6 {}
        set v7 {}
        set v8 {}
        set v9 {}
        ##  gather info box at a time
        switch $b {
            "1" {set box $b1; set tr1 $r1; set tr2 $r2; set tr3 $r3;
                 set tc1 $c1; set tc2 $c2; set tc3 $c3;
            }
            "2" {set box $b2; set tr1 $r1; set tr2 $r2; set tr3 $r3;
                 set tc1 $c4; set tc2 $c5; set tc3 $c6;
            }
            "3" {set box $b3; set tr1 $r1; set tr2 $r2; set tr3 $r3;
                 set tc1 $c7; set tc2 $c8; set tc3 $c9;
            }
            "4" {set box $b4; set tr1 $r4; set tr2 $r5; set tr3 $r6;
                 set tc1 $c1; set tc2 $c2; set tc3 $c3;
            }
            "5" {set box $b5; set tr1 $r4; set tr2 $r5; set tr3 $r6;
                 set tc1 $c4; set tc2 $c5; set tc3 $c6;
            }
            "6" {set box $b6; set tr1 $r4; set tr2 $r5; set tr3 $r6;
                 set tc1 $c7; set tc2 $c8; set tc3 $c9;
            }
            "7" {set box $b7; set tr1 $r7; set tr2 $r8; set tr3 $r9;
                 set tc1 $c1; set tc2 $c2; set tc3 $c3;
            }
            "8" {set box $b8; set tr1 $r7; set tr2 $r8; set tr3 $r9;
                 set tc1 $c4; set tc2 $c5; set tc3 $c6;
            }
            "9" {set box $b9; set tr1 $r7; set tr2 $r8; set tr3 $r9;
                 set tc1 $c7; set tc2 $c8; set tc3 $c9;
            }
        }
        
        #puts "$tr1\n$tr2\n$tr3\n$tc1\n$tc2\n$tc3\n$box"
        # now info on a location by location
        for {set i 0} {$i < 9} {incr i} {
            set missing {}
            switch $i {
                "0" {set row $tr1; set col $tc1}
                "1" {set row $tr1; set col $tc2}
                "2" {set row $tr1; set col $tc3}
                "3" {set row $tr2; set col $tc1}
                "4" {set row $tr2; set col $tc2}
                "5" {set row $tr2; set col $tc3}
                "6" {set row $tr3; set col $tc1}
                "7" {set row $tr3; set col $tc2}
                "8" {set row $tr3; set col $tc3}
            }
            ## if this location is one of the given
            set rtn [lindex $box $i]
            #dbg_msg  $rtn
            if {$rtn > 0} {
                #puts "Found $i in $box"
                continue
            }
            # for each number search the lists
            for {set n 1} {$n < 10} {incr n} {
                set br [lsearch $row $n]
                set bc [lsearch $col $n]
                set bb [string first $n $box]
                #dbg_msg "row: $br  col: $bc  box $bb"
                if {$br < 0 & $bc < 0 & $bb < 0} {
                    #dbg_msg "row: $br  col: $bc  box $bb  Val: $n"
                    lappend missing $n
                }
            }
            
            switch $i {
                "0" {set v1 $missing}
                "1" {set v2 $missing}
                "2" {set v3 $missing}
                "3" {set v4 $missing}
                "4" {set v5 $missing}
                "5" {set v6 $missing}
                "6" {set v7 $missing}
                "7" {set v8 $missing}
                "8" {set v9 $missing}
            }
        }
        
        set vs {}
        lappend vs $v1 $v2 $v3 $v4 $v5 $v6 $v7 $v8 $v9
        
        for {set i 1} {$i < 10} {incr i} {
            set cnt 0
            set found 0
            set sz 0
            ## if a list size is equ 1
            for {set j 1} {$j < 10} {incr j} {
                switch $j {
                    "1" {set lst $v1}
                    "2" {set lst $v2}
                    "3" {set lst $v3}
                    "4" {set lst $v4}
                    "5" {set lst $v5}
                    "6" {set lst $v6}
                    "7" {set lst $v7}
                    "8" {set lst $v8}
                    "9" {set lst $v9}
                }
                set sz [llength $lst]
                set rtn [lsearch $lst $i]
                if {$sz == 1} {
                    if {$rtn >= 0} {
                        set found $j
                        set cnt 1
                    }
                }
            }
            ## else if not one, then search for number in only one list
            if {$found == 0} {
                for {set j 1} {$j < 10} {incr j} {
                    switch $j {
                        "1" {set lst $v1}
                        "2" {set lst $v2}
                        "3" {set lst $v3}
                        "4" {set lst $v4}
                        "5" {set lst $v5}
                        "6" {set lst $v6}
                        "7" {set lst $v7}
                        "8" {set lst $v8}
                        "9" {set lst $v9}
                    }
                    set rtn [lsearch $lst $i]
                    if {$rtn >= 0} {
                        set found $j
                        incr cnt
                    }
                }
            }
            ## if a value was only found in one list, Loc is considered
            ##    solved.
            if {$cnt == 1} {
                set fail 0
                ##
                ##  OMG  have fun
                ##  found is the possition   b is the block
                switch $found {
                    "1" {switch $b {
                            "1" {set b1 [lreplace $b1 0 0 $i]
                                 set r1 [lreplace $r1 0 0 $i]
                                 set c1 [lreplace $c1 0 0 $i]
                            }
                            "2" {set b2 [lreplace $b2 0 0 $i]
                                 set r1 [lreplace $r1 3 3 $i]
                                 set c4 [lreplace $c4 0 0 $i]
                            }
                            "3" {set b3 [lreplace $b3 0 0 $i]
                                 set r1 [lreplace $r1 6 6 $i]
                                 set c7 [lreplace $c7 0 0 $i]
                            }
                            "4" {set b4 [lreplace $b4 0 0 $i]
                                 set r4 [lreplace $r4 0 0 $i]
                                 set c1 [lreplace $c1 3 3 $i]
                            }
                            "5" {set b5 [lreplace $b5 0 0 $i]
                                 set r4 [lreplace $r4 3 3 $i]
                                 set c4 [lreplace $c4 3 3 $i]
                            }
                            "6" {set b6 [lreplace $b6 0 0 $i]
                                 set r4 [lreplace $r4 6 6 $i]
                                 set c7 [lreplace $c7 3 3 $i]
                            }
                            "7" {set b7 [lreplace $b7 0 0 $i]
                                 set r7 [lreplace $r7 0 0 $i]
                                 set c1 [lreplace $c1 6 6 $i]
                            }
                            "8" {set b8 [lreplace $b8 0 0 $i]
                                 set r7 [lreplace $r7 3 3 $i]
                                 set c4 [lreplace $c4 6 6 $i]
                            }
                            "9" {set b9 [lreplace $b9 0 0 $i]
                                 set r7 [lreplace $r7 6 6 $i]
                                 set c7 [lreplace $c7 6 6 $i]
                            }
                        }
                    }
                    "2" {switch $b {
                            "1" {set b1 [lreplace $b1 1 1 $i]
                                 set r1 [lreplace $r1 1 1 $i]
                                 set c2 [lreplace $c2 0 0 $i]
                            }
                            "2" {set b2 [lreplace $b2 1 1 $i]
                                 set r1 [lreplace $r1 4 4 $i]
                                 set c5 [lreplace $c5 0 0 $i]
                            }
                            "3" {set b3 [lreplace $b3 1 1 $i]
                                 set r1 [lreplace $r1 7 7 $i]
                                 set c8 [lreplace $c8 0 0 $i]
                            }
                            "4" {set b4 [lreplace $b4 1 1 $i]
                                 set r4 [lreplace $r4 1 1 $i]
                                 set c2 [lreplace $c2 3 3 $i]
                            }
                            "5" {set b5 [lreplace $b5 1 1 $i]
                                 set r4 [lreplace $r4 4 4 $i]
                                 set c5 [lreplace $c5 3 3 $i]
                            }
                            "6" {set b6 [lreplace $b6 1 1 $i]
                                 set r4 [lreplace $r4 7 7 $i]
                                 set c8 [lreplace $c8 3 3 $i]
                            }
                            "7" {set b7 [lreplace $b7 1 1 $i]
                                 set r7 [lreplace $r7 1 1 $i]
                                 set c2 [lreplace $c2 6 6 $i]
                            }
                            "8" {set b8 [lreplace $b8 1 1 $i]
                                 set r7 [lreplace $r7 4 4 $i]
                                 set c5 [lreplace $c5 6 6 $i]
                            }
                            "9" {set b9 [lreplace $b9 1 1 $i]
                                 set r7 [lreplace $r7 7 7 $i]
                                 set c8 [lreplace $c8 6 6 $i]
                            }
                        }
                    }
                    "3" {switch $b {
                            "1" {set b1 [lreplace $b1 2 2 $i]
                                 set r1 [lreplace $r1 2 2 $i]
                                 set c3 [lreplace $c3 0 0 $i]
                            }
                            "2" {set b2 [lreplace $b2 2 2 $i]
                                 set r1 [lreplace $r1 5 5 $i]
                                 set c6 [lreplace $c6 0 0 $i]
                            }
                            "3" {set b3 [lreplace $b3 2 2 $i]
                                 set r1 [lreplace $r1 8 8 $i]
                                 set c9 [lreplace $c9 0 0 $i]
                            }
                            "4" {set b4 [lreplace $b4 2 2 $i]
                                 set r4 [lreplace $r4 2 2 $i]
                                 set c3 [lreplace $c3 3 3 $i]
                            }
                            "5" {set b5 [lreplace $b5 2 2 $i]
                                 set r4 [lreplace $r4 5 5 $i]
                                 set c6 [lreplace $c6 3 3 $i]
                            }
                            "6" {set b6 [lreplace $b6 2 2 $i]
                                 set r4 [lreplace $r4 8 8 $i]
                                 set c9 [lreplace $c9 3 3 $i]
                            }
                            "7" {set b7 [lreplace $b7 2 2 $i]
                                 set r7 [lreplace $r7 2 2 $i]
                                 set c3 [lreplace $c3 6 6 $i]
                            }
                            "8" {set b8 [lreplace $b8 2 2 $i]
                                 set r7 [lreplace $r7 5 5 $i]
                                 set c6 [lreplace $c6 6 6 $i]
                            }
                            "9" {set b9 [lreplace $b9 2 2 $i]
                                 set r7 [lreplace $r7 8 8 $i]
                                 set c9 [lreplace $c9 6 6 $i]
                            }
                        }
                    }
                    "4" {switch $b {
                            "1" {set b1 [lreplace $b1 3 3 $i]
                                 set r2 [lreplace $r2 0 0 $i]
                                 set c1 [lreplace $c1 1 1 $i]
                            }
                            "2" {set b2 [lreplace $b2 3 3 $i]
                                 set r2 [lreplace $r2 3 3 $i]
                                 set c4 [lreplace $c4 1 1 $i]
                            }
                            "3" {set b3 [lreplace $b3 3 3 $i]
                                 set r2 [lreplace $r2 6 6 $i]
                                 set c7 [lreplace $c7 1 1 $i]
                            }
                            "4" {set b4 [lreplace $b4 3 3 $i]
                                 set r5 [lreplace $r5 0 0 $i]
                                 set c1 [lreplace $c1 4 4 $i]
                            }
                            "5" {set b5 [lreplace $b5 3 3 $i]
                                 set r5 [lreplace $r5 3 3 $i]
                                 set c4 [lreplace $c4 4 4 $i]
                            }
                            "6" {set b6 [lreplace $b6 3 3 $i]
                                 set r5 [lreplace $r5 6 6 $i]
                                 set c7 [lreplace $c7 4 4 $i]
                            }
                            "7" {set b7 [lreplace $b7 3 3 $i]
                                 set r8 [lreplace $r8 0 0 $i]
                                 set c1 [lreplace $c1 7 7 $i]
                            }
                            "8" {set b8 [lreplace $b8 3 3 $i]
                                 set r8 [lreplace $r8 3 3 $i]
                                 set c4 [lreplace $c4 7 7 $i]
                            }
                            "9" {set b9 [lreplace $b9 3 3 $i]
                                 set r8 [lreplace $r8 6 6 $i]
                                 set c7 [lreplace $c7 7 7 $i]
                            }
                        }
                    }
                    "5" {switch $b {
                            "1" {set b1 [lreplace $b1 4 4 $i]
                                 set r2 [lreplace $r2 1 1 $i]
                                 set c2 [lreplace $c2 1 1 $i]
                            }
                            "2" {set b2 [lreplace $b2 4 4 $i]
                                 set r2 [lreplace $r2 4 4 $i]
                                 set c5 [lreplace $c5 1 1 $i]
                            }
                            "3" {set b3 [lreplace $b3 4 4 $i]
                                 set r2 [lreplace $r2 7 7 $i]
                                 set c8 [lreplace $c8 1 1 $i]
                            }
                            "4" {set b4 [lreplace $b4 4 4 $i]
                                 set r5 [lreplace $r5 1 1 $i]
                                 set c2 [lreplace $c2 4 4 $i]
                            }
                            "5" {set b5 [lreplace $b5 4 4 $i]
                                 set r5 [lreplace $r5 4 4 $i]
                                 set c5 [lreplace $c5 4 4 $i]
                            }
                            "6" {set b6 [lreplace $b6 4 4 $i]
                                 set r5 [lreplace $r5 7 7 $i]
                                 set c8 [lreplace $c8 4 4 $i]
                            }
                            "7" {set b7 [lreplace $b7 4 4 $i]
                                 set r8 [lreplace $r8 1 1 $i]
                                 set c2 [lreplace $c2 7 7 $i]
                            }
                            "8" {set b8 [lreplace $b8 4 4 $i]
                                 set r8 [lreplace $r8 4 4 $i]
                                 set c5 [lreplace $c5 7 7 $i]
                            }
                            "9" {set b9 [lreplace $b9 4 4 $i]
                                 set r8 [lreplace $r8 7 7 $i]
                                 set c8 [lreplace $c8 7 7 $i]
                            }
                        }
                    }
                    "6" {switch $b {
                            "1" {set b1 [lreplace $b1 5 5 $i]
                                 set r2 [lreplace $r2 2 2 $i]
                                 set c3 [lreplace $c3 1 1 $i]
                            }
                            "2" {set b2 [lreplace $b2 5 5 $i]
                                 set r2 [lreplace $r2 5 5 $i]
                                 set c6 [lreplace $c6 1 1 $i]
                            }
                            "3" {set b3 [lreplace $b3 5 5 $i]
                                 set r2 [lreplace $r2 8 8 $i]
                                 set c9 [lreplace $c9 1 1 $i]
                            }
                            "4" {set b4 [lreplace $b4 5 5 $i]
                                 set r5 [lreplace $r5 2 2 $i]
                                 set c3 [lreplace $c3 4 4 $i]
                            }
                            "5" {set b5 [lreplace $b5 5 5 $i]
                                 set r5 [lreplace $r5 5 5 $i]
                                 set c6 [lreplace $c6 4 4 $i]
                            }
                            "6" {set b6 [lreplace $b6 5 5 $i]
                                 set r5 [lreplace $r5 8 8 $i]
                                 set c9 [lreplace $c9 4 4 $i]
                            }
                            "7" {set b7 [lreplace $b7 5 5 $i]
                                 set r8 [lreplace $r8 2 2 $i]
                                 set c3 [lreplace $c3 7 7 $i]
                            }
                            "8" {set b8 [lreplace $b8 5 5 $i]
                                 set r8 [lreplace $r8 5 5 $i]
                                 set c6 [lreplace $c6 7 7 $i]
                            }
                            "9" {set b9 [lreplace $b9 5 5 $i]
                                 set r8 [lreplace $r8 8 8 $i]
                                 set c9 [lreplace $c9 7 7 $i]
                            }
                        }
                    }
                    "7" {switch $b {
                            "1" {set b1 [lreplace $b1 6 6 $i]
                                 set r3 [lreplace $r3 0 0 $i]
                                 set c1 [lreplace $c1 2 2 $i]
                            }
                            "2" {set b2 [lreplace $b2 6 6 $i]
                                 set r3 [lreplace $r3 3 3 $i]
                                 set c4 [lreplace $c4 2 2 $i]
                            }
                            "3" {set b3 [lreplace $b3 6 6 $i]
                                 set r3 [lreplace $r3 6 6 $i]
                                 set c7 [lreplace $c7 2 2 $i]
                            }
                            "4" {set b4 [lreplace $b4 6 6 $i]
                                 set r6 [lreplace $r6 0 0 $i]
                                 set c1 [lreplace $c1 5 5 $i]
                            }
                            "5" {set b5 [lreplace $b5 6 6 $i]
                                 set r6 [lreplace $r6 3 3 $i]
                                 set c4 [lreplace $c4 5 5 $i]
                            }
                            "6" {set b6 [lreplace $b6 6 6 $i]
                                 set r6 [lreplace $r6 6 6 $i]
                                 set c7 [lreplace $c7 5 5 $i]
                            }
                            "7" {set b7 [lreplace $b7 6 6 $i]
                                 set r9 [lreplace $r9 0 0 $i]
                                 set c1 [lreplace $c1 8 8 $i]
                            }
                            "8" {set b8 [lreplace $b8 6 6 $i]
                                 set r9 [lreplace $r9 3 3 $i]
                                 set c4 [lreplace $c4 8 8 $i]
                            }
                            "9" {set b9 [lreplace $b9 6 6 $i]
                                 set r9 [lreplace $r9 6 6 $i]
                                 set c7 [lreplace $c7 8 8 $i]
                            }
                        }
                    }
                    "8" {switch $b {
                            "1" {set b1 [lreplace $b1 7 7 $i]
                                 set r3 [lreplace $r3 1 1 $i]
                                 set c2 [lreplace $c2 2 2 $i]
                            }
                            "2" {set b2 [lreplace $b2 7 7 $i]
                                 set r3 [lreplace $r3 4 4 $i]
                                 set c5 [lreplace $c5 2 2 $i]
                            }
                            "3" {set b3 [lreplace $b3 7 7 $i]
                                 set r3 [lreplace $r3 7 7 $i]
                                 set c8 [lreplace $c8 2 2 $i]
                            }
                            "4" {set b4 [lreplace $b4 7 7 $i]
                                 set r6 [lreplace $r6 1 1 $i]
                                 set c2 [lreplace $c2 5 5 $i]
                            }
                            "5" {set b5 [lreplace $b5 7 7 $i]
                                 set r6 [lreplace $r6 4 4 $i]
                                 set c5 [lreplace $c5 5 5 $i]
                            }
                            "6" {set b6 [lreplace $b6 7 7 $i]
                                 set r6 [lreplace $r6 7 7 $i]
                                 set c8 [lreplace $c8 5 5 $i]
                            }
                            "7" {set b7 [lreplace $b7 7 7 $i]
                                 set r9 [lreplace $r9 1 1 $i]
                                 set c2 [lreplace $c2 8 8 $i]
                            }
                            "8" {set b8 [lreplace $b8 7 7 $i]
                                 set r9 [lreplace $r9 4 4 $i]
                                 set c5 [lreplace $c5 8 8 $i]
                            }
                            "9" {set b9 [lreplace $b9 7 7 $i]
                                 set r9 [lreplace $r9 7 7 $i]
                                 set c8 [lreplace $c8 8 8 $i]
                            }
                        }
                    }
                    "9" {switch $b {
                            "1" {set b1 [lreplace $b1 8 8 $i]
                                 set r3 [lreplace $r3 2 2 $i]
                                 set c3 [lreplace $c3 2 2 $i]
                            }
                            "2" {set b2 [lreplace $b2 8 8 $i]
                                 set r3 [lreplace $r3 5 5 $i]
                                 set c6 [lreplace $c6 2 2 $i]
                            }
                            "3" {set b3 [lreplace $b3 8 8 $i]
                                 set r3 [lreplace $r3 8 8 $i]
                                 set c9 [lreplace $c9 2 2 $i]
                            }
                            "4" {set b4 [lreplace $b4 8 8 $i]
                                 set r6 [lreplace $r6 2 2 $i]
                                 set c3 [lreplace $c3 5 5 $i]
                            }
                            "5" {set b5 [lreplace $b5 8 8 $i]
                                 set r6 [lreplace $r6 5 5 $i]
                                 set c6 [lreplace $c6 5 5 $i]
                            }
                            "6" {set b6 [lreplace $b6 8 8 $i]
                                 set r6 [lreplace $r6 8 8 $i]
                                 set c9 [lreplace $c9 5 5 $i]
                            }
                            "7" {set b7 [lreplace $b7 8 8 $i]
                                 set r9 [lreplace $r9 2 2 $i]
                                 set c3 [lreplace $c3 8 8 $i]
                            }
                            "8" {set b8 [lreplace $b8 8 8 $i]
                                 set r9 [lreplace $r9 5 5 $i]
                                 set c6 [lreplace $c6 8 8 $i]
                            }
                            "9" {set b9 [lreplace $b9 8 8 $i]
                                 set r9 [lreplace $r9 8 8 $i]
                                 set c9 [lreplace $c9 8 8 $i]
                            }
                        }
                    }
                }
            ##  end up update vars
            }
        ## end of looking for values to update
        }
    ## end of check each box
    }
    if {$fail == 1} {
        incr count
    }
    ##  end while
    }
    ##  Check to see if any missed, or not solved
    for {set i 1} {$i < 10} {incr i} {
        switch $i {
            "1" {set rtn [lsearch $r1 "0"]}
            "2" {set rtn [lsearch $r2 "0"]}
            "3" {set rtn [lsearch $r3 "0"]}
            "4" {set rtn [lsearch $r4 "0"]}
            "5" {set rtn [lsearch $r5 "0"]}
            "6" {set rtn [lsearch $r6 "0"]}
            "7" {set rtn [lsearch $r7 "0"]}
            "8" {set rtn [lsearch $r8 "0"]}
            "9" {set rtn [lsearch $r9 "0"]}
        }
        ## if still some 0's in array retrun fail
        if {$rtn >= 0} {
            return 1
        }
    }
    ##  else  return pass
    return 0
}

## User name dialog
iwidgets::promptdialog .pd -modality application -title Password -labeltext "User Name"
.pd hide Apply
     
#################################
##  Update the stats file
proc update_stats {} {
	global glevel gnumb timer_txt
	
	set l [$glevel get]
	set n [$gnumb get]
	set t [$timer_txt cget -text]
	
	set uname ""

    if {[.pd activate]} {
       set uname [.pd get]
       set sfn [open "stats.html" a]
       puts $sfn "<p STYLE=\"margin-bottom: 0in\">Player: $uname Finished game: $n at level: $l in: $t</p>"
       close $sfn
    } 
}

##############################################
##   Start game proc
proc start_game {dbg} {
    global tm_on start_time usr_txt
    
    ##  If there is a game running ask user if they want to restart
    if {$tm_on == 1} {
        if {[.md activate]} {
            puts "selected: Yes"
        } else {
            return
        }       
    }
    
    set tm_on 0
    # generate the game numbers matrix
    set rtn [generate 0]
    # generate the show table
    set grtn [gen_shown 3 0]
    # update the board with numbers
    set rtn [load_start_board $dbg]
    
    if {$grtn == 1} {
	    about_msg "I could not generate this puzzle\nat this level of effort or difficulty.\n\
	             Please set the effort higher or the\ndifficulty down, or pick a new game number. "
	    return 1
    }
    ## start the timer
    set tm_on 1
    ## get the starting time
    set start_time [clock scan now]
    set usr_txt "Game Running ..... Enjoy!!"
    
}
