##-------------------------------------------------------------------------------
##--                            Ken Campbell
##--                        No Rights Reserved
##-------------------------------------------------------------------------------
##-- $Author: ken $
##--
##-- $Date: 2005/12/09 15:14:08 $
##--
##-- $Name:  $
##--
##-- $Id: $
##--
##-- $Source: $
##--
##-- Description :
##--      
##------------------------------------------------------------------------------
##-- This software contains concepts 
##--  
##-- 
##-------------------------------------------------------------------------------

#############################################################################
# every --
#   Cheap rescheduler.  (c) Jeffrey Hobbs
#   
# every::schedule <time> cmd;	# cmd is a one arg (cmd as list)
#	schedules $cmd to be run every <time> 1000ths of a sec
#	IOW, [::every::schedule 1000 "puts hello"] prints hello every sec
# every::cancel pattern
#	cancels cmd matching the glob pattern
# every::info ?pattern?
#	returns info about commands in pairs of "time cmd time cmd ..."
#
namespace eval ::every {}
proc ::every::schedule {time cmd} {
    if {![string is integer -strict $time]} {
	return -code error "usage: [lindex [::info level 0] 0] time command"
    }
    # A time was given, so schedule a command to run every $time msecs
    variable ID
    if {[string compare {} $cmd]} {
	set ID($cmd) [list $time [after $time [list ::every::_do $cmd]]]
    }
}

proc ::every::_do {cmd} {
    variable ID
    if {[::info exists ID($cmd)]} {
	uplevel \#0 $cmd
	set time [lindex $ID($cmd) 0]
	set ID($cmd) [list $time [after $time [list ::every::_do $cmd]]]
    }
}

proc ::every::cancel {pattern} {
    variable ID
    foreach i [array names ID $pattern] {
	after cancel [lindex $ID($i) 1]
	unset ID($i)
    }
}

proc ::every::info {{pattern *}} {
    variable ID
    set result {}
    foreach i [array names ID $pattern] {
	lappend result [lindex $ID($i) 0] [lindex $ID($i) 1]
    }
    return $result
}

######################################################################
##  proc to update timers
proc time_update {} {
    global lb1_text tm_txt tm_on start_time e_time
    set raw_date [clock scan now]
    #puts $raw_date
##  set lb1_text [clock format $raw_date -format "%d %b %Y %T"]
    set lb1_text [clock format $raw_date -format "%T"]
    if {$tm_on == 1} {
	    set tm_txt [clock format $e_time -format "%T"]
        set e_time [expr {$raw_date - $start_time + 18000}]
    } else {
	    set tm_txt [clock format $e_time -format "%T"]
    }
}


###################################
##  Bindings  standard  stuff

bind . <Key> {
    
    namespace import e::*
    
    #puts "Pressed %K"
    set k %K
    #set win [focus]
    #puts $win
    
    if {$k == "Right"} {
        incr e::col
        #puts $e::col
        if {$e::col > 9} {
            set e::col 1
        }
        make_active
        
    } elseif {$k == "Left"} {
        set e::col [expr {$e::col - 1}]
        #puts $e::col
        if {$e::col <= 0} {
            set e::col 9
        }
        make_active
    } elseif {$k == "Up"} {
        set e::row [expr {$e::row - 1}]
        #puts "$e::row"
        if {$e::row <= 0} {
            set e::row 9
        }
        make_active
    } elseif {$k == "Down"} {
        incr e::row
        #puts "$e::row"
        if {$e::row > 9} {
            set e::row 1
        }
        make_active
    }
    #puts "Row is: $e::row  Col is: $e::col"
        
    
}

bind . <F12> {catch {console show}}

