#! /usr/bin/env wish
############################################################################
##
## Copyright 2014  Ken Campbell
##
##   Licensed under the Apache License, Version 2.0 (the "License");
##   you may not use this file except in compliance with the License.
##   You may obtain a copy of the License at
##
##     http://www.apache.org/licenses/LICENSE-2.0
##
##   Unless required by applicable law or agreed to in writing, software
##   distributed under the License is distributed on an "AS IS" BASIS,
##   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
##   See the License for the specific language governing permissions and
##   limitations under the License.
##
#####################################
## Description :
##      A collection of non-gui procs as part of the reg_workbench file set.
##
##############################################

###  NON-GUI procs
#####################################################################
##  Gen C  Include file
proc  gen_cinclude {fn} {
    global FullLst RegAddrEn RegAddrAbs RegMaskEn RegFMaskEn
    global RegAddrPre RegAddrSuf RegMaskPre RegMaskSuf RegFMaskPre RegFMaskSuf
    global MmapLst

    set dt "#define "
    set mmap 0
    set fh [open $fn w]

    set bwidth 32
    set resolution "Word"
    set reso 1

    if {$RegAddrEn == 1} {
        foreach r $FullLst {
            set sr [split $r ","]
            set type [lindex $sr 0]
            switch $type {
                "1" {
                    if {$mmap == 0} {
                        ## the memory map define
                        set tmp $dt
                        #puts $sr
                        append tmp "[lindex $sr 1]_BASE 0x[lindex $sr 2]"
                        puts $fh $tmp
                        set mmap 1
                    } else {
                        break;
                    }
                }
                "2" {
                    set bwidth [lindex $sr 1]
                    set resolution [lindex $sr 3]
                    if {$resolution == "Byte"} {
                        set reso [expr {$bwidth / 8}]
                    } else {
                        set reso 1
                    }
                }
                "3" {
                    ## block base define
                    set tmp $dt
                    append tmp "[lindex $sr 1]_BASE 0x[lindex $sr 2]"
                    puts $fh $tmp
                }
                "6" {
                    set tmp $dt
                    if {$RegAddrAbs == 1} {
                        set stat [scan [lindex $sr 2] %lx didx]
                        set daddr [expr {$didx * $reso}]
                        set addr "0x[format  "%lx" $daddr]"
                        #puts "[lindex $sr 1] $addr"
                    ##  absolute
                    } else {
                        foreach a $MmapLst {
                            set type [lindex $a 0]
                            if {$type == "mem"} {
                                set found [string first [lindex $sr 1] [lindex $a 1]]
                                if {$found >= 0} {
                                    set addr "0x[format  "%lx" [lindex $a 2]]"
                                    break
                                    #puts "[lindex $sr 1] $addr"
                                }
                            }
                        }
                    }
                    append tmp "[lindex $sr 1]_MEM_BASE $addr"
                    puts $fh $tmp
                }
                "10" {
                    set tmp $dt
                    ## if reative
                    if {$RegAddrAbs == 1} {
                        set stat [scan [lindex $sr 2] %lx didx]
                        set daddr [expr {$didx * $reso}]
                        set addr "0x[format  "%lx" $daddr]"
                        #puts "[lindex $sr 1] $addr"
                    ##  absolute
                    } else {
                        foreach a $MmapLst {
                            set type [lindex $a 0]
                            if {$type == "reg"} {
                                set found [string first [lindex $sr 1] [lindex $a 1]]
                                if {$found >= 0} {
                                    set addr "0x[format  "%lx" [lindex $a 2]]"
                                    break
                                    #puts "[lindex $sr 1] $addr"
                                }
                            }
                        }
                    }
                    append tmp $RegAddrPre "[lindex $sr 1]" $RegAddrSuf " $addr"
                    puts $fh $tmp
                }
            }
        }
    }

    set zero_str "00000000000000000000000000000000"
    set tmp ""
    ## register masks
    if {$RegMaskEn == 1} {
        foreach r $FullLst {
            set sr [split $r ","]
            set type [lindex $sr 0]
            switch $type {
                 "10" {
                    if {$tmp != ""} {
                        set cnt 31
                        set bstr ""
                        while {$cnt >= 0} {
                            append bstr [lindex $mstr $cnt]
                            set cnt [expr {$cnt - 1}]
                        }
                        append tmp " 0x[bin2hex $bstr]"
                        puts $fh $tmp
                    }
                    set tmp $dt
                    append tmp $RegMaskPre "[lindex $sr 1]" $RegMaskSuf
                    set mstr [split $zero_str ""]
                    #puts $fh $tmp
                }
                "11" {
                    set sidx [lindex $sr 2]
                    set fsz [lindex $sr 3]
                    set eidx [expr {$sidx + $fsz}]
                    for {set i $sidx} {$i < $eidx} {incr i} {
                        set mstr [lreplace $mstr $i $i 1]
                        #puts "[lindex $sr 1]  $mstr"
                    }
                }
            }
        }
        if {$tmp != ""} {
            set cnt 31
            set bstr ""
            while {$cnt >= 0} {
                append bstr [lindex $mstr $cnt]
                set cnt [expr {$cnt - 1}]
            }
            append tmp " 0x[bin2hex $bstr]"
            puts $fh $tmp
        }
    }
    ##  Register field masks
    if {$RegFMaskEn == 1} {
        foreach r $FullLst {
            set sr [split $r ","]
            set type [lindex $sr 0]
            switch $type {
                "11" {
                    set mstr [split $zero_str ""]
                    set sidx [lindex $sr 2]
                    set fsz [lindex $sr 3]
                    set eidx [expr {$sidx + $fsz}]
                    for {set i $sidx} {$i < $eidx} {incr i} {
                        set mstr [lreplace $mstr $i $i 1]
                        #puts "[lindex $sr 1]  $mstr"
                    }
                    set cnt 31
                    set bstr ""
                    while {$cnt >= 0} {
                        append bstr [lindex $mstr $cnt]
                        set cnt [expr {$cnt - 1}]
                    }
                    set tmp $dt
                    append tmp $RegFMaskPre "[lindex $sr 1]" $RegFMaskSuf
                    append tmp " 0x[bin2hex $bstr]"
                    puts $fh $tmp
                }
            }
        }
    }
    close $fh
}

#####################################################################
##  gen_html
##    generate the HTML output for the currently loaded data base.
##  Input:   dn   directory name
proc gen_html {dn} {
    global FullLst

    #puts $fn
    file delete -force $dn
    file mkdir $dn

    set in_des 0
    set in_comm 0
    set itm_typ 0
    set in_enu 0
    set in_reg 0
    set in_fld 0
    ## create HTML doc
    set fh [open "$dn/doc.html" w]
    foreach r $FullLst {
        set sr [split $r ","]
        set type [lindex $sr 0]
        switch $type {
            "3" {
                if {$in_reg == 1} {
                    puts $fh "</table>"
                    set in_reg 0
                }
                set bname [lindex $sr 1]
                set tmp_txt "<h1 align=\"left\">Block $bname</h1>"
                puts $fh $tmp_txt
                set in_fld 0
            }
            "10" {
                if {$in_reg == 1} {
                    puts $fh "</td></tr>"
                    puts $fh "</table>"
                    set in_reg 0
                }
                set rname [lindex $sr 1]
                set ridx [lindex $sr 2]
                set racc [lindex $sr 3]
                puts $fh "<h2 align=\"left\">Register $rname</h2>"
                puts $fh "<p>Index:  $ridx   Access:  $racc</p>"
                set in_fld 0
            }
            "11" {
                if {$in_reg == 0} {
                    puts $fh "<table border =\"1\">"
                    puts $fh "<tr><td>Field Name</td><td>Start</td><td>Size</td>"
                    puts $fh "<td>Access</td><td>Default</td><td>Type</td><td>Description</td></tr>"
                    set in_reg 1
                }
                if {$in_fld == 1} {
                    puts $fh "</tr>"
                }
                set in_fld 1
                puts $fh "<tr>"
                puts $fh "<td>[lindex $sr 1]</td>"
                puts $fh "<td>[lindex $sr 2]</td>"
                puts $fh "<td>[lindex $sr 3]</td>"
                puts $fh "<td>[lindex $sr 4]</td>"
                puts $fh "<td>[lindex $sr 5]</td>"
                puts $fh "<td>[lindex $sr 6]</td>"
                set itm_typ 11
                set in_comm 0
                set in_enu 0
            }
            "12" {
                puts $fh "<td>Legal Value Range<br />From: [lindex $sr 1]<br />To: [lindex $sr 2]</td>"
                set itm_typ 12
                set in_comm 0
            }
            "13" {
                if {$in_comm == 0} {
                    puts $fh "<td>Enmuerated Values:<br />[string range $r 3 end]<br />"
                    set in_comm 1
                } else {
                    puts $fh "[string range $r 3 end]<br />"
                }
            }
            "14" {
                if {$itm_typ == 10 || $itm_typ == 11} {
                    if {$in_comm == 0} {
                        puts $fh "<td>[string range $r 3 end]"
                        set in_comm 1
                    } else {
                        puts $fh "<br />[string range $r 3 end]"
                    }
                }
            }
        }
    }
    close $fh

    ##  create browser doc
    set fh [open "$dn/index.html" w]
    puts $fh "<frameset cols=\"20%,*\">"
    puts $fh "    <frame name=\"menu\" src=\"menu.html\">"
    puts $fh "    <frame name=\"body\" src=\"intro.html\">"
    puts $fh "</frameset>"
    close $fh

    set fh [open "$dn/intro.html" w]
    puts $fh "<h1>Introduction Text ...</h1>"
    close $fh


    set fh [open "$dn/menu.html" w]
    puts $fh "<h1>Register Select</h1>"
    foreach r $FullLst {
        set sr [split $r ","]
        set type [lindex $sr 0]
        switch $type {
            "10" {
                set name [lindex $sr 1]
                puts $fh "<a href=\"$name.html\" target=\"body\">$name<br />"
            }
        }
    }
    close $fh
    set fh -1

    set in_des 0
    set in_comm 0
    set itm_typ 0
    set in_enu 0
    foreach r $FullLst {
        set sr [split $r ","]
        set type [lindex $sr 0]
        switch $type {
            "10" {
                if {$fh >= 0} {
                  puts $fh "</table>"
                  puts $fh "</body>"
                  puts $fh "</html>"
                  close $fh
                }
                set fn "$dn/"
                append fn "[lindex $sr 1].html"
                set fh [open $fn w]
                puts $fh "<!DOCTYPE html>"
                puts $fh "<html>"
                puts $fh "<header>"
                puts $fh "<title>Register [lindex $sr 1] Information</title>"
                puts $fh "</header>"
                puts $fh "<body>"
                puts $fh "<table border =\"1\">"
                set in_des 0
                set in_comm 0
                set itm_typ 0
                set in_enu 0

                puts $fh "</td></tr>"
                puts $fh "<tr><td>[lindex $sr 1]</td>"
                puts $fh "<td>Address: [lindex $sr 2]<br />"
                puts $fh "Access: [lindex $sr 3]</td>"
                set itm_typ 10
                set in_comm 0
                set in_enu 0
            }
            "11" {
                puts $fh "</td></tr><tr><td></td>"
                puts $fh "<td>Field Name: [lindex $sr 1]<br />"
                puts $fh "Start Bit: [lindex $sr 2]<br />"
                puts $fh "Size: [lindex $sr 3]<br />"
                puts $fh "Access: [lindex $sr 4]<br />"
                puts $fh "Default: [lindex $sr 5]<br />"
                puts $fh "Field Type: [lindex $sr 6]</td>"
                set itm_typ 11
                set in_comm 0
                set in_enu 0
            }
            "12" {
                puts $fh "<td>Legal Value Range<br />From: [lindex $sr 1]<br />To: [lindex $sr 2]</td>"
                set itm_typ 12
                set in_comm 0
            }
            "13" {
                if {$in_enu == 0} {
                    puts $fh "<td>Enmuerated Values:<br />[string range $r 3 end]<br />"
                    set in_enu 1
                } else {
                    puts $fh "[string range $r 3 end]<br />"
                }
            }
            "14" {
                if {$itm_typ == 10 || $itm_typ == 11} {
                    if {$in_comm == 0} {
                        puts $fh "<td>[string range $r 3 end]"
                        set in_comm 1
                    } else {
                        puts $fh "<br />[string range $r 3 end]"
                    }
                }
            }
        }
    }
    puts $fh "</table>"
    puts $fh "</body>"
    puts $fh "</html>"
    close $fh
}

######################################################
##  create memory map  list
##  {{type address}}
##    mmap  map_name  base_address (base_address + size)
##    blk   blk_name  (base_address + start_addr) (base_address + start_addr + size)
##    mem   mem_name  (block_address + start_addr) (block_address + end_addr)
##    reg   reg_name  addr {assigned bits list}
proc create_mem_map {} {
    global FullLst MmapLst msizes

    set MmapLst {}
    set base_addr 0
    set base_name ""
    set blk_addr 0
    set blk_name ""
    set cur_reg ""
    set reg_offset 0
    foreach r $FullLst {
        set sr [split $r ","]
        #puts $r
        switch [lindex $sr 0] {
            "1" {
                if {$cur_reg != ""} {
                    lappend tmplst $fld_lst
                    lappend MmapLst $tmplst
                    set cur_reg ""
                }
                #puts $r
                set tmplst "mmap"
                set base_name "."
                append base_name [lindex $sr 1]
                lappend tmplst $base_name
                set stat [scan [lindex $sr 2] "%lx" addr]
                set base_addr $addr
                lappend tmplst $addr
                set stat [scan [lindex $sr 3] "%lx" depth]
                set end_addr [expr {$base_addr + $depth}]
                lappend tmplst $end_addr
                lappend MmapLst $tmplst
            }
            "2" {
                set width [lindex $sr 1]
                set reso_en [lindex $sr 3]
                #puts $reso
                if {$reso_en == "Byte"} {
                    set reso [expr {$width / 8}]
                    set reg_offset [expr {$width / 8}]
                } else {
                    set reso 1
                    set reg_offset 1
                }
            }
            "3" {
                if {$cur_reg != ""} {
                    lappend tmplst $fld_lst
                    lappend MmapLst $tmplst
                    set cur_reg ""
                }
                set tmplst "blk"
                #lappend tmplst [lindex $sr 1]
                set blk_name $base_name
                append blk_name "." [lindex $sr 1]
                lappend tmplst $blk_name
                set stat [scan [lindex $sr 2] "%lx" blk_addr]
                #puts $blk_addr
                set addr [expr {$blk_addr + $base_addr}]
                #puts $addr
                set stat [scan [lindex $sr 3] "%lx" depth]
                set end_addr [expr {$depth + $blk_addr - $reso}]
                #if {$reso_en == "Byte"} {
                #    set end_addr [expr {$depth + $blk_addr - ($width / 8)}]
                #} else {
                #    set end_addr [expr {$depth + $blk_addr - 1}]
                #}
                lappend tmplst $blk_addr $end_addr
                lappend MmapLst $tmplst
            }
            "6" {
                if {$cur_reg != ""} {
                    lappend tmplst $fld_lst
                    lappend MmapLst $tmplst
                    set cur_reg ""
                }
                set tmplst "mem"
                set mem_name $blk_name
                append mem_name "." [lindex $sr 1]
                lappend tmplst $mem_name
                set stat [scan [lindex $sr 2] "%lx" addr]
                set addr [expr {($reso * $addr) + $blk_addr}]
                set stat [scan [lindex $sr 4] "%lx" depth]
                set end_addr [expr {($reso * $depth) + $addr - $reso}]

                #puts "Mem Start: $addr    Mem End: $end_addr"
                #if {$reso == "Byte"} {
#               #     set end_addr [expr {($depth * ($width / 8)) + $addr - ($width / 8)}]
                #    set end_addr [expr {$depth + $addr - ($width / 8)}]
                #} else {
                #    set end_addr [expr {$depth + $addr - 1}]
                #}
                lappend tmplst $addr
                lappend tmplst $end_addr
                lappend MmapLst $tmplst
            }
            "10" {
                #puts $r
                if {$cur_reg != ""} {
                    lappend tmplst $fld_lst
                    lappend MmapLst $tmplst
                }
                set cur_reg $blk_name
                append cur_reg "." [lindex $sr 1]
                set tmplst "reg"
                lappend tmplst $cur_reg
                set addr [scan [lindex $sr 2] "%x"]
                set addr [expr {$addr * $reg_offset}]
                set reg_addr [expr {$blk_addr + $addr}]
                lappend tmplst $reg_addr
                set fld_lst {}
            }
            "11" {
                set faddr [lindex $sr 2]
                set fsize [lindex $sr 3]
                for {set i $faddr} {$i <= [expr {($fsize - 1) + $faddr}]} {incr i} {
                    lappend fld_lst $i
                }
            }
        }
    }

    if {$cur_reg != ""} {
        lappend tmplst $fld_lst
        lappend MmapLst $tmplst
    }

    ## sort the list by start address
    #set MmapLst [lsort -index 2 $MmapLst]

    #foreach m $MmapLst {
    #    puts $m
    #}
}
##  end create_mem_map
###########################################################
##  create_register_map
proc create_register_map {rid} {
    global FullLst RegMap
    set RegMap {}
    set id [lindex $rid 1]

    set rtn [find_index $id]
    set start [lindex $rtn 1]
    set end [find_index_end $start]
    set reg_desc [lrange $FullLst $start [lindex $rtn 2]]
    foreach r $reg_desc {
        set sr [split $r ","]
        if {[lindex $sr 0] == 11} {
            set frec [lindex $sr 1]
            set bits [lindex $sr 2]
            set low $bits
            set depth [lindex $sr 3]
            while {$depth > 1} {
                incr low
                lappend bits $low
                set depth [expr {$depth - 1}]
            }
            lappend frec $bits
            lappend RegMap $frec
        }
    }
}
###################################################
##  get_map_addr
proc get_map_addr {mmap} {
    global MmapLst
    set rtn {}
    foreach m $MmapLst {
        if {[lindex $m 0] == "mmap" && [lindex $m 1] == $mmap} {
            return [scan [lindex $m 2] "%x"]
        }
    }
}
##################################################
##  get_block_addr
proc get_block_addr {block} {
    global MmapLst
    set rtn {}
    #puts $block
    foreach m $MmapLst {
        #puts $m
        if {[lindex $m 0] == "blk" && [lindex $m 1] == $block} {
            set rtn [lindex $m 2]
            lappend rtn [lindex $m 3]
            return $rtn
        }
    }
}
##################################################
##   mdepth_to_size
##    dep   the text that is found in the range drop down widget
proc mdepth_to_size {dep} {
    global msizes
    set rtn ""
    set sidx [lsearch $msizes $dep]
    if {$sidx >= 0} {
        ##  msizes starts at 16
        set sidx [expr {$sidx + 4}]
        set rtn [format  "%lx" [expr {wide(pow(2, $sidx))}]]
    } else {
        puts "ERROR:  Depth input could not be found in msizs list.  proc mdepth_to_size"
    }
    return $rtn
}
####################################################
##  size_to_mdepth
proc size_to_mdepth {sz} {
    global msizes
    set rtn ""
    set stat [scan $sz %lx dval]
    #puts "dval :  $dval"
    set idx 0
    set rm $dval
    while {$rm > 0} {
        set rm [expr {$rm/2}]
        incr idx
    }

    if {$idx < 4} {
        puts "ERROR:  size_to_mdepth sent value that was too low."
    }

    set idx [expr {$idx - 5}]
    set rtn [lindex $msizes $idx]
    return $rtn
}
#######################################################
##  add item to error list
proc add_error_lst {itm etype} {
    global EntErrorLst

    set found 0
    set tmp_el {}
    if {$EntErrorLst != {}} {
        foreach ee $EntErrorLst {
            if {[lindex $ee 0] == $itm} {
                set found 1
                set tmp_el $ee
                break
            }
        }
        if {$found == 1} {
            set tmpt [lindex $tmp_el 1]
            foreach et $tmpt {
                if {$et == $etype} {
                    return
                }
            }
        } else {
            set tmp $itm
            lappend tmp $etype
            lappend EntErrorLst $tmp
        }
    } else {
        set tmp $itm
        lappend tmp $etype
        lappend EntErrorLst $tmp
    }
}
######################################################
##  remove item from error list
proc remove_error_lst {itm etype} {
    global EntErrorLst

    if {$EntErrorLst != {}} {
        set idx 0
        foreach ee $EntErrorLst {
            if {[lindex $ee 0] == $itm} {
                set EntErrorLst [lreplace $EntErrorLst $idx $idx]
            }
            incr idx
        }
    }
}
######################################################
##  check memory map item
##   item passed is exactly like a memory map record
##     created by create_mem_map.
proc check_address {item} {
    global MmapLst RegMap

    #puts $item

    set rtn 0
    set ilen [llength $item]
    set type [lindex $item 0]
    set id [lindex $item 1]
    set sid [split [lindex $item 1] "."]
    switch $type {
        "mmap" {
            set start [lindex $item 2]
            set end [lindex $item 3]
        }
        "blk" {
            set start [lindex $item 2]
            set end [lindex $item 3]
            set mm [lindex $sid 1]
        }
        "mem" {
            set start [lindex $item 2]
            set end [lindex $item 3]
            set mm [lindex $sid 1]
            append mm "." [lindex $sid 2]
        }
        "reg" {
            set raddr [lindex $item 2]
            set fname [lindex $item 3]
            set flst [lindex $item 4]
            set mm [lindex $sid 1]
            append mm "." [lindex $sid 2]
        }
        default {puts "ERROR:  check_address given unknown type."; set rtn 1;}
    }
    set mblk [lindex $sid 2]

    foreach mr $MmapLst {
        if {$type == "mmap"} {

        } elseif {$type == "blk"} {
            set is [string first $mm [lindex $mr 1]]
            if {$is < 0 || $id == [lindex $mr 1]} {
                continue
            }
            switch [lindex $mr 0] {
                "mmap" {
                    set saddr [lindex $mr 2]
                    set eaddr [lindex $mr 3]
                    if {$start < $saddr} {
                        puts "ERROR:  Block start address is less than the memory map start address."
                        set rtn 1
                    }
                    if {$eaddr < $end} {
                        puts "ERROR:  Block end address is greater than the memory map end address."
                        set rtn 1
                    }
                }
                "blk" {
                    set saddr [lindex $mr 2]
                    set eaddr [lindex $mr 3]
                    if {$start >= $saddr && $start <= $eaddr} {
                        puts "ERROR:  Block start address falls within the space defined by [lindex $mr 1]."
                        set rtn 1
                    }
                    if {$end >= $saddr && $end <= $eaddr} {
                        puts "END: $end  bstart: $saddr  bend: $eaddr"
                        puts "ERROR:  Block end address falls within the space defined by [lindex $mr 1]."
                        set rtn 1
                    }
                    if {$start <= $saddr && $end >= $eaddr} {
                        puts "ERROR:  Block address space overlaps the space defined by [lindex $mr 1]."
                        set rtn 1
                    }
                }
                "mem" {}
                "reg" {}
            }
        } elseif {$type == "mem"} {
            set is [string first $mm [lindex $mr 1]]
            if {$is < 0 || $id == [lindex $mr 1]} {
                continue
            }
            switch [lindex $mr 0] {
                "mmap" {}
                "blk" {
                    set saddr [lindex $mr 2]
                    set eaddr [lindex $mr 3]
                    if {$start < $saddr} {
                        puts "ERROR:  Memory start address is less than the Block start address  $mm."
                        add_error_lst $id addr
                        set rtn 1
                    }
                    if {$eaddr < $end} {
                        puts "ERROR:  Memory end address is greater than the Block end address  $mm."
                        add_error_lst $id addr
                        set rtn 1
                    }
                }
                "mem" {
                    set saddr [lindex $mr 2]
                    set eaddr [lindex $mr 3]
                    if {$start >= $saddr && $start <= $eaddr} {
                        puts "ERROR:  Memory start address falls within the space defined by [lindex $mr 1]."
                        add_error_lst $id addr
                        set rtn 1
                    }
                    if {$end >= $saddr && $end <= $eaddr} {
                        puts "ERROR:  Memory end address falls within the space defined by [lindex $mr 1]."
                        add_error_lst $id addr
                        set rtn 1
                    }
                    if {$start <= $saddr && $end >= $eaddr} {
                        puts "ERROR:  Memory address space overlaps the space defined by [lindex $mr 1]."
                        add_error_lst $id addr
                        set rtn 1
                    }

                }
                "reg" {
#                        puts "mem start: $saddr   mem end:  $eaddr  Register:  $raddr"
                        puts "mem start: $saddr   mem end:  $eaddr"
                }
            }
        } elseif {$type == "reg"} {
            set is [string first $mm [lindex $mr 1]]
            if {($is < 0 || $id == [lindex $mr 1]) && $ilen == 3} {
                continue
            }
            if {$ilen == 3} {
                switch [lindex $mr 0] {
                    "mmap" {}
                    "blk" {
                        set eaddr [lindex $mr 3]
                        if {$raddr > $eaddr} {
                            puts "ERROR: Register address is past the end of block address defined by [lindex $mr 1]."
                            set rtn 1
                        }
                    }
                    "mem" {
                        set saddr [lindex $mr 2]
                        set eaddr [lindex $mr 3]
                        puts "mem start: $saddr   mem end:  $eaddr  Register:  $raddr"
                        if {$raddr >= $saddr && $raddr <= $eaddr} {
                            puts "ERROR: Register address falls within the address range of memory [lindex $mr 1]"
                            set rtn 1
                        }
                    }
                    "reg" {
                        set addr [lindex $mr 2]
                        if {$raddr == $addr} {
                            puts "ERROR: Register address is already assigned to [lindex $mr 1]"
                            set rtn 1
                        }
                    }
                }
            } else {
                if {$id != [lindex $mr 1]} {
                    continue
                }
                ## create full name of field
                append id "." $fname
                foreach f $RegMap {
                    set is [lsearch $f $fname]
                    if {$is != 0} {
                        foreach i $flst {
                            foreach j [lindex $f 1] {
                                if {$i == $j} {
                                    puts "ERROR: $fname bit $i  overlaps existing bits in the Register field [lindex $f 0]"
                                    set rtn 1
                                }
                            }
                        }
                    }
                }
            }
        }
    }
    ##  deal with errors, add or remove from errors list
    if {$rtn == 0} {
        remove_error_lst $id addr
    } else {
        add_error_lst $id addr
    }
    return $rtn
##  end check_address
}

######################################################
##  insert_records list at index  (as per tcl lists)
proc insert_records {rlst idx} {
    global FullLst
    #puts $idx
    set len [llength $FullLst]
    #puts $len
    if {$len != 0} {
        set i $idx
        foreach r $rlst {
            set FullLst [linsert $FullLst $i $r]
            if {$i != "end"} {
                incr i
            }
        }
    } else {
        set FullLst $rlst
    }
    #puts $rlst
}
######################################################
## Delete records proc
proc delete_records {start end} {
    global FullLst

}
######################################################
##  Replace records proc
##  inputs:  start    start index
##           end      end index
##           rlst     list of replacement records
proc replace_records {start end rlst} {
    global FullLst
    ##puts "$start $end"
    #puts "Inserting records:  $rlst"
    set FullLst [lreplace $FullLst $start $end]
    ##puts_FullLst
    set i $start
    foreach r $rlst {
        set FullLst [linsert $FullLst $i $r]
        incr i
    }
}
#######################################################
##  pad string to size
##    return padded string
proc pad_str {str sz} {
    set rtn $str
    set len [string length $str]
    while {$len < $sz} {
        set rtn "$rtn "
        set len [string length $rtn]
    }
    return $rtn
}
#######################################################
##  size of number to bits to select it
##    return the number of bits
proc size2bit_width {int} {
    set tmp $int
    set bcnt 0
    while {$tmp > 1} {
        set tmp [expr {$tmp / 2}]
        incr bcnt
    }
    incr bcnt
    return $bcnt
}
#######################################################
#  convert  dec  to bin with width limit
#    return bin number
proc int2bin {val {width 32}} {
    set cnt $width
    set hex_val [format "%llx" $val]
    set len [string length $hex_val]
    set rtn ""
    for {set i 0} {$i < $len} {incr i} {
        append bval [hd2bin [string range $hex_val $i $i]]
    }
    #puts $hex_val
    #puts $bval
    set tw $width
    set len [string length $bval]
    if {$len > $width} {
        set sidx [expr {$len - $width}]
        set rtn [string range $bval $sidx $len-1]
    } else {
        set diff [expr {$width - $len}]
        while {$diff != 0} {
            append rtn "0"
            set diff [expr {$diff - 1}]
        }
        append rtn $bval
    }
    return $rtn
}
#######################################################
##  convert  Hex digit to Binary
##    return  binary value
proc hd2bin {val} {
    set tval [string tolower $val]
    switch $tval {
        "0" {set rtn "0000"}
        "1" {set rtn "0001"}
        "2" {set rtn "0010"}
        "3" {set rtn "0011"}
        "4" {set rtn "0100"}
        "5" {set rtn "0101"}
        "6" {set rtn "0110"}
        "7" {set rtn "0111"}
        "8" {set rtn "1000"}
        "9" {set rtn "1001"}
        "a" {set rtn "1010"}
        "b" {set rtn "1011"}
        "c" {set rtn "1100"}
        "d" {set rtn "1101"}
        "e" {set rtn "1110"}
        "f" {set rtn "1111"}
    }
    return $rtn
}
######################################################
##  convert hex value to  binary  with bit width
##    return  binary value of width
proc hex2bin {val sz} {
    set sval [split $val ""]
    set bval ""
    foreach v $sval {
        append bval [hd2bin $v]
    }
    set len [string length $bval]
    if {$len <= $sz} {
        while {$len < $sz} {
            set t "0"
            append t $bval
            set bval $t
            set len [string length $bval]
        }
    } else {
        set diff [expr {$len - $sz}]
        set bval [string range $bval $diff end]
    }

    return $bval
}
######################################################
##  convert  bin value to hex
##    Return  hex value
proc bin2hex {val {width 8}} {
    set in_width [string length $val]
    set need_width [expr $width * 4]
    set tmp_val  $val
    ##  zero fill left if needed
    if {$need_width > $in_width} {
        set diff [expr $need_width - $in_width]
        while {$diff != 0} {
            append pre_pend 0
            set diff [expr $diff - 1]
        }
    }
    ## append any zero fill
    append pre_pend $tmp_val
    set rtn_val ""
    set c_dex 0
    for {set i 1} {$i <= $width} {incr i} {
        set bin_char ""
        ##  Collect up 4 bits
        for {set j 0} {$j <= 3} {incr j} {
        append bin_char [string index $pre_pend $c_dex]
            incr c_dex
        }
        ## switch on the collected bits
        switch $bin_char {
            "0000"  {append rtn_val 0}
            "0001"  {append rtn_val 1}
            "0010"  {append rtn_val 2}
            "0011"  {append rtn_val 3}
            "0100"  {append rtn_val 4}
            "0101"  {append rtn_val 5}
            "0110"  {append rtn_val 6}
            "0111"  {append rtn_val 7}
            "1000"  {append rtn_val 8}
            "1001"  {append rtn_val 9}
            "1010"  {append rtn_val A}
            "1011"  {append rtn_val B}
            "1100"  {append rtn_val C}
            "1101"  {append rtn_val D}
            "1110"  {append rtn_val E}
            "1111"  {append rtn_val F}
            default {dbg_msg "Error: Undefined value in to_hex \n
                                   $bin_char"}
        }
    }
    return $rtn_val
}
#######################################################
##  load file proc
##  loads a file into the FullLst  list
proc load_file {fn} {
    global FullLst

    set crcv 0
    set fh [open $fn r]
    set cs [crc::Crc32Init]
    ##  load the file
    while {![eof $fh]} {
        set line [gets $fh]
        if {$line != ""} {
            set sline [split $line ","]
            set typ [lindex $sline 0]
            ### skip  version record
            if {$typ == "100"} {
                crc::Crc32Update $cs $line
                continue
            }
            ##  get the crc from the crc record
            if {$typ == "101"} {
                set crcv [lindex $sline 1]
                continue
            }
            lappend FullLst $line
        }
    }
    close $fh
    ## get the crc of the loaded regx
    foreach r $FullLst {
        crc::Crc32Update $cs $r
    }
    set csr [crc::Crc32Final $cs]
    # check if crc are the same.
    if {$csr != $crcv && $crcv != 0} {
        puts "There has been a CRC error.  CRC does not match!!!"
        puts "File crc: $crcv  Calculated crc: $csr"
    }
}
#########################################################3
##  save file  proc
proc save_file {fn} {
    global FullLst version

    ## calculate the CRC
    set cs [crc::Crc32Init]
    ## open file for write
    set fh [open $fn w]
    ## prepend the tool version (top of file)
    set frec [lindex $FullLst 0]
    set found [string first "100," $frec]
    if {$found < 0} {
        set ver "100,"
        append ver $version
        crc::Crc32Update $cs $ver
        puts $fh $ver
    }

    foreach r $FullLst {
        puts $fh $r
    }
    foreach r $FullLst {
        crc::Crc32Update $cs $r
    }
    set csr "101,"
    append csr [crc::Crc32Final $cs]
    ##  append crc at the end of the file.
    puts $fh $csr

    close $fh
}

######################################################
##  DEBUG procs
##  puts the full list
proc puts_FullLst {} {
    global FullLst
    set idx 0
    foreach r $FullLst {
        puts "$idx:$r"
        incr idx
    }
}
##  output the memory map list.
proc puts_memmap {} {
    global MmapLst
    foreach m $MmapLst {
        puts $m
    }
}