############################################################################
##
## Copyright 2014  Ken Campbell
##
##   Licensed under the Apache License, Version 2.0 (the "License");
##   you may not use this file except in compliance with the License.
##   You may obtain a copy of the License at
##
##     http://www.apache.org/licenses/LICENSE-2.0
##
##   Unless required by applicable law or agreed to in writing, software
##   distributed under the License is distributed on an "AS IS" BASIS,
##   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
##   See the License for the specific language governing permissions and
##   limitations under the License.
##
#####################################
##-- Description :
##--      This file contains user input validation code.
##--      
##------------------------------------------------------------------------------

##  for hex fields only hex digits are valid
proc val_hex {wid wouldbe} {
    return [string is xdigit $wouldbe]
}
##  for decimal fields only decimal digits are valid
proc val_dec {wid wouldbe} {
    return [string is digit $wouldbe]
}
##  for name fields  no space, coma, period 
proc val_name {wid wouldbe} {
    #puts $wouldbe
    set rtn 1
    set no_sp [string first " " $wouldbe]
    set no_co [string first "," $wouldbe]
    set no_pe [string first "." $wouldbe]
    set no_se [string first "\;" $wouldbe]
    if {$no_sp >= 0 || $no_co >= 0 || $no_pe >= 0 || $no_se >= 0} {
        set rtn 0
    }
    return $rtn
}