############################################################################
##
## Copyright 2014  Ken Campbell
##
##   Licensed under the Apache License, Version 2.0 (the "License");
##   you may not use this file except in compliance with the License.
##   You may obtain a copy of the License at
##
##     http://www.apache.org/licenses/LICENSE-2.0
##
##   Unless required by applicable law or agreed to in writing, software
##   distributed under the License is distributed on an "AS IS" BASIS,
##   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
##   See the License for the specific language governing permissions and
##   limitations under the License.
##
#####################################
##-- Description :
##--      Graphics procs for the register work bench  canvas's
##--
##------------------------------------------------------------------------------
##########################################################
set bgcol "white"
set fgcol "black"
set ercol "green"

set collst {LightSkyBlue1 LightSalmon1 MediumPurple1 LightSlateGray green white black}
##########################################################
##  Register Canvas update
##    rid  return value of get_index_detail
##      if rid is "."  just clear canv
proc update_reg_canv {rid} {
    global FullLst reg_cav mmap_widt_en
    global bgcol fgcol collst

    set ercol [lindex $collst 4]
    set dwidth [$mmap_widt_en get]

    for {set i 0} {$i < $dwidth} {incr i} {
        $reg_cav itemconfigure bt$i -text ""
        $reg_cav itemconfigure bl$i -fill $bgcol
        $reg_cav itemconfigure bn$i -fill $fgcol
        $reg_cav itemconfigure er$i -fill $ercol
        $reg_cav itemconfigure er$i -outline $fgcol
    }

    for {set i $dwidth} {$i < 32} {incr i} {
        $reg_cav itemconfigure bt$i -text ""
        $reg_cav itemconfigure bl$i -fill $bgcol
        $reg_cav itemconfigure bn$i -fill $bgcol
        $reg_cav itemconfigure er$i -fill $bgcol
        $reg_cav itemconfigure er$i -outline $bgcol
    }

    if {$rid == "."} {
        return
    }

    ## get the full description of register.
    set reg_desc [lrange $FullLst [lindex $rid 1] [lindex $rid 2]]

    set cidx 0
    set reg_lst {}
    ## collect only the field definition records
    foreach l $reg_desc {
        set sl [split $l ","]
        if {[lindex $sl 0] != 11} {
            continue
        }
        lappend reg_lst $sl
    }
    ## sort them by  start bit index
    set reg_lst [lsort -index 2 -integer $reg_lst]
    ## draw in details.
    foreach l $reg_lst {
        #puts $l
        set bfcol [lindex $collst $cidx]
        set fname [lindex $l 1]
        set fstbit [lindex $l 2]
        set fsize [lindex $l 3]
        $reg_cav itemconfigure bt$fstbit -text $fname
        $reg_cav itemconfigure bl$fstbit -fill $fgcol
        $reg_cav itemconfigure bn$fstbit -fill $fgcol
        $reg_cav itemconfigure er$fstbit -fill $bfcol
        if {$fsize > 1} {
            set lastbit [expr {$fstbit + $fsize -1}]
            set nextbit [expr {$fstbit + 1}]
            for {set i $nextbit} {$i <= $lastbit} {incr i} {
                $reg_cav itemconfigure bn$i -fill $bgcol
                $reg_cav itemconfigure er$i -fill $bfcol
            }
        }
        incr cidx
        if {$cidx >= 4} {
            set cidx 0
        }
    }

}
###########################################################################
##  update  memory map cavas
proc update_mmap_canv {} {
    global mmap_cav FullLst MmapLst mmap_tree_tr

    set del "del"

    $mmap_cav addtag del all
    $mmap_cav delete $del
    if {[llength $FullLst] == 0} {
        return
    }

    set reso [get_reso]
    ##  get the selected item, (memory map)
    set sid [$mmap_tree_tr selection]
    #puts $sid
    set mname [lindex [split $sid "."] 1]

    $mmap_cav create text 10 10 -anchor nw  -text "$mname"
    ## get the list of blocks from memory map
    set ilst {}
    foreach m $MmapLst {
        set typ [lindex $m 0]
        if {$typ == "mmap" && [lindex $m 1] == $sid} {
            set mstart [lindex $m 2]
            set mend [lindex $m 3]
        } elseif {$typ == "blk"} {
            set part [string first $sid [lindex $m 1]]
            if {$part == 0} {
                lappend ilst $m
            }
        }
    }
    ## sort the list by start address
    set ilst [lsort -index 2 -integer $ilst]
    #foreach i $ilst {
    #    puts $i
    #}
    ## output memory map boundries
    set mendh [format "0x%llX" $mend]
    set mstarth [format "0x%llX" $mstart]
    $mmap_cav create text 120 10 -anchor nw  -text "Start: $mstarth    End: $mendh"
    $mmap_cav create line 15 25 15 43
    $mmap_cav create line 15 43 75 43

    set lx 43
    set lys 50
    set lye 75
    set ly  57

    set ilen [llength $ilst]
    set lstart 0
    set lend 999999999
    set xl 1
    set xy 0

    set bend ""

    foreach i $ilst {
        set bname [lindex [split [lindex $i 1] "."] end]
        set bstart [lindex $i 2]
        set bstarth [format "0x%llX" $bstart]
        set bend [lindex $i 3]
        set bendh [format "0x%llX" $bend]
        set diff [expr {$bstart - $lend}]
        if {$diff > 16} {
            set lendh [format "0x%llX" $lend]
            set bstarth [format "0x%llX" $bstart]
            $mmap_cav create rectangle 75 [expr {($xl * 15) + 21}] 400 [expr {($xl * 15) + 33}] -outline white -fill lightgreen
            $mmap_cav create text 80 [expr {($xl * 15) + 20}] -anchor nw  -text "Unused:"
            set ustarth [format "0x%llX" [expr {$lend + $reso}]]
            $mmap_cav create text 180 [expr {($xl * 15) + 20}] -anchor nw  -text "$ustarth"
            set uendh [format "0x%llX" [expr {$bstart - $reso}]]
            $mmap_cav create text 280 [expr {($xl * 15) + 20}] -anchor nw  -text "$uendh"

            ##  pointer lines to next item  ???  useful?
            $mmap_cav create line $lys $lx $lys [expr {$lx + 15}]
            $mmap_cav create line $lys $ly $lye $ly
            set lx [expr {$lx + 15}]
            set ly [expr {$ly + 15}]
            incr xl
        }
        $mmap_cav create text 80 [expr {($xl * 15) + 20}] -anchor nw  -text "$bname"
        $mmap_cav create text 180 [expr {($xl * 15) + 20}] -anchor nw  -text "$bstarth"
        $mmap_cav create text 280 [expr {($xl * 15) + 20}] -anchor nw  -text "$bendh"
        set lend $bend
        #set lstart $bstart

        ##  pointer lines to next item  ???  useful?
        $mmap_cav create line $lys $lx $lys [expr {$lx + 15}]
        $mmap_cav create line $lys $ly $lye $ly
        set lx [expr {$lx + 15}]
        set ly [expr {$ly + 15}]
        incr xl
        #puts $i
    }

    if {$bend != ""} {
        set diff [expr {$mend - $bend}]
        if {$diff > 16} {
            $mmap_cav create rectangle 75 [expr {($xl * 15) + 21}] 400 [expr {($xl * 15) + 33}] -outline white -fill lightgreen
            $mmap_cav create text 80 [expr {($xl * 15) + 20}] -anchor nw  -text "Unused:"
            set ustarth [format "0x%llX" [expr {$bend + $reso}]]
            $mmap_cav create text 180 [expr {($xl * 15) + 20}] -anchor nw  -text "$ustarth"
            set uendh [format "0x%llX" [expr {$bstart - $reso}]]
            $mmap_cav create text 280 [expr {($xl * 15) + 20}] -anchor nw  -text "$mendh"
        }
    } else {
        $mmap_cav create rectangle 75 [expr {($xl * 15) + 21}] 400 [expr {($xl * 15) + 33}] -outline white -fill lightgreen
        $mmap_cav create text 80 [expr {($xl * 15) + 20}] -anchor nw  -text "Unused:"
        $mmap_cav create text 180 [expr {($xl * 15) + 20}] -anchor nw  -text "$mstarth"
        $mmap_cav create text 280 [expr {($xl * 15) + 20}] -anchor nw  -text "$mendh"
    }
}

#########################################################
##  update the Block canvase
proc update_blk_canv {} {
    global blk_cav FullLst MmapLst mmap_tree_tr

    set reso [get_reso]

    # clear contents of canvas
    set del "del"
    $blk_cav addtag del all
    $blk_cav delete $del

    ##  get the selected item, (memory map)
    set sid [$mmap_tree_tr selection]
    #puts $sid
    set bname [lindex [split $sid "."] 2]

    $blk_cav create text 10 10 -anchor nw  -text "$bname"

    set ilst {}
    foreach m $MmapLst {
        set isn [lindex [split [lindex $m 1] "."] 2]
        set is [string first $sid [lindex $m 1]]
        if {$isn != $bname} {
            continue
        }
        set typ [lindex $m 0]
        if {$typ == "blk" && [lindex $m 1] == $sid} {
            set bstart [lindex $m 2]
            set bend [lindex $m 3]
        } elseif {$typ == "reg"} {
            set part [string first $sid [lindex $m 1]]
            if {$part == 0} {
                lappend ilst $m
            }
        } elseif {$typ == "mem"} {
            set part [string first $sid [lindex $m 1]]
            if {$part == 0} {
                lappend ilst $m
            }
        }
    }
    set ilst [lsort -index 2 -integer $ilst]
    #foreach i $ilst {
    #    puts $i
    #}

    ## place block details
    set bendh [format "0x%llX" $bend]
    set bstarth [format "0x%llX" $bstart]
    $blk_cav create text 120 10 -anchor nw  -text "Start: $bstarth    End: $bendh"
    $blk_cav create line 15 25 15 43
    $blk_cav create line 15 43 75 43

    set lx 43
    set lys 50
    set lye 75
    set ly  57
    set xl 1
    set laddr $bstart

    foreach i $ilst {
        set ityp [lindex $i 0]
        set iname [lindex [split [lindex $i 1] "."] end]
        set istart [lindex $i 2]
        set istarth [format "0x%llX" $istart]

        if {$ityp == "reg"} {
            set diff [expr {$istart - $laddr}]
            #puts $diff
            if {$diff > $reso} {
                $blk_cav create rectangle 75 [expr {($xl * 15) + 21}] 400 [expr {($xl * 15) + 33}] -outline white -fill lightgreen
                $blk_cav create text 80 [expr {($xl * 15) + 20}] -anchor nw  -text "Unused:"
                set laddrh [format "0x%llX" [expr {$laddr + $reso}]]
                $blk_cav create text 180 [expr {($xl * 15) + 20}] -anchor nw  -text "$laddrh"
                set lendrh [format "0x%llX" [expr {$istart - $reso}]]
                $blk_cav create text 280 [expr {($xl * 15) + 20}] -anchor nw  -text "$lendrh"
            ##  pointer lines to next item  ???  useful?
            $blk_cav create line $lys $lx $lys [expr {$lx + 15}]
            $blk_cav create line $lys $ly $lye $ly
            set lx [expr {$lx + 15}]
            set ly [expr {$ly + 15}]
                incr xl
            }
            $blk_cav create text 80 [expr {($xl * 15) + 20}] -anchor nw  -text "$iname"
            $blk_cav create text 180 [expr {($xl * 15) + 20}] -anchor nw  -text "$istarth"
            set laddr $istart
            ##  pointer lines to next item  ???  useful?
            $blk_cav create line $lys $lx $lys [expr {$lx + 15}]
            $blk_cav create line $lys $ly $lye $ly
            set lx [expr {$lx + 15}]
            set ly [expr {$ly + 15}]
            incr xl
        } else {
            set diff [expr {$istart - $laddr}]
            if {$diff > $reso} {
                $blk_cav create rectangle 75 [expr {($xl * 15) + 21}] 400 [expr {($xl * 15) + 33}] -outline white -fill lightgreen
                $blk_cav create text 80 [expr {($xl * 15) + 20}] -anchor nw  -text "Unused:"
                set laddrh [format "0x%llX" [expr {$laddr + $reso}]]
                $blk_cav create text 180 [expr {($xl * 15) + 20}] -anchor nw  -text "$laddrh"
                set lendrh [format "0x%llX" [expr {$istart - $reso}]]
                $blk_cav create text 280 [expr {($xl * 15) + 20}] -anchor nw  -text "$lendrh"
            ##  pointer lines to next item  ???  useful?
            $blk_cav create line $lys $lx $lys [expr {$lx + 15}]
            $blk_cav create line $lys $ly $lye $ly
            set lx [expr {$lx + 15}]
            set ly [expr {$ly + 15}]
                incr xl
            }
            set iend [lindex $i 3]
            set iendh [format "0x%llX" $iend]
            $blk_cav create text 80 [expr {($xl * 15) + 20}] -anchor nw  -text "$iname"
            $blk_cav create text 180 [expr {($xl * 15) + 20}] -anchor nw  -text "$istarth"
            $blk_cav create text 280 [expr {($xl * 15) + 20}] -anchor nw  -text "$iendh"
            ##  pointer lines to next item  ???  useful?
            $blk_cav create line $lys $lx $lys [expr {$lx + 15}]
            $blk_cav create line $lys $ly $lye $ly
            set lx [expr {$lx + 15}]
            set ly [expr {$ly + 15}]
            incr xl
            set laddr $iend
        }
        #puts "$ityp $iname $istarth"
    }

    set diff [expr {$bend - $laddr}]
    #puts $diff
    if {$diff > $reso} {
        $blk_cav create rectangle 75 [expr {($xl * 15) + 21}] 400 [expr {($xl * 15) + 33}] -outline white -fill lightgreen
        $blk_cav create text 80 [expr {($xl * 15) + 20}] -anchor nw  -text "Unused:"
        set laddrh [format "0x%llX" [expr {$laddr + $reso}]]
        $blk_cav create text 180 [expr {($xl * 15) + 20}] -anchor nw  -text "$laddrh"
        set bendrh [format "0x%llX" $bend]
        $blk_cav create text 280 [expr {($xl * 15) + 20}] -anchor nw  -text "$bendrh"
    }

}

###########################################################
##  procs to enable user to change the default colors.
set lbc0 ""
set lbc1 ""
set lbc2 ""
set lbc3 ""
set lbc4 ""
set lbc5 ""

proc gui_set_colors {} {
    global collst lblst
    global lbc0 lbc1 lbc2 lbc3 lbc4 lbc5

    set ct [toplevel .user_colors]

    set lb1 [label $ct.lb1 -text "Color Chooser"]
    pack $lb1 -anchor w

    set f1 [frame $ct.fr1 -borderwidth 4 -relief sunken]
    set lb1 [label $f1.lb1 -text "Register Bit Field #1"]
    set lbc0 [label $f1.c1 -width 15 -bg [lindex $collst 0]]
    set fb1 [button $f1.fb1 -text "Pick" -command {pick_color 0}]
    pack $lb1 $lbc0 -side left
    pack $fb1 -side right
    pack $f1 -anchor w -fill x

    set f2 [frame $ct.fr2 -borderwidth 4 -relief sunken]
    set lb2 [label $f2.lb1 -text "Register Bit Field #2"]
    set lbc1 [label $f2.c1 -width 15 -bg [lindex $collst 1]]
    set fb2 [button $f2.fb1 -text "Pick" -command {pick_color 1}]
    pack $lb2 $lbc1 -side left
    pack $fb2 -side right
    pack $f2 -anchor w -fill x

    set f3 [frame $ct.fr3 -borderwidth 4 -relief sunken]
    set lb3 [label $f3.lb1 -text "Register Bit Field #3"]
    set lbc2 [label $f3.c1 -width 15 -bg [lindex $collst 2]]
    set fb3 [button $f3.fb1 -text "Pick" -command {pick_color 2}]
    pack $lb3 $lbc2 -side left
    pack $fb3 -side right
    pack $f3 -anchor w -fill x

    set f4 [frame $ct.fr4 -borderwidth 4 -relief sunken]
    set lb4 [label $f4.lb4 -text "Register Bit Field #4"]
    set lbc3 [label $f4.c4 -width 15 -bg [lindex $collst 3]]
    set fb4 [button $f4.fb4 -text "Pick" -command {pick_color 3}]
    pack $lb4 $lbc3 -side left
    pack $fb4 -side right
    pack $f4 -anchor w -fill x

    set f5 [frame $ct.fr5 -borderwidth 4 -relief sunken]
    set lb5 [label $f5.lb1 -text "Unused space Color"]
    set lbc4 [label $f5.c1 -width 15 -bg [lindex $collst 4]]
    set fb5 [button $f5.fb1 -text "Pick" -command {pick_color 4}]
    pack $lb5 $lbc4 -side left
    pack $fb5 -side right
    pack $f5 -anchor w -fill x

    #set f6 [frame $ct.fr6 -borderwidth 4 -relief sunken]
    #set lb6 [label $f6.lb1 -text "Background Color"]
    #set lbc5 [label $f6.c1 -width 15 -bg [lindex $collst 5]]
    #set fb6 [button $f6.fb1 -text "Pick" -command {pick_color 5}]
    #pack $lb6 $lbc5 -side left
    #pack $fb6 -side right
    #pack $f6 -anchor w -fill x

}

proc pick_color {idx} {
    global collst lblst
    global lbc0 lbc1 lbc2 lbc3 lbc4 lbc5

    switch $idx {
        "0" {set lb $lbc0}
        "1" {set lb $lbc1}
        "2" {set lb $lbc2}
        "3" {set lb $lbc3}
        "4" {set lb $lbc4}
        "5" {set lb $lbc5}
        default {return}
    }
    set ccol [$lb cget -background]
    #set lbc [lindex $lblst $idx]
    set ncol [tk_chooseColor -initialcolor $ccol]
    if {$ncol != ""} {
        puts "Index:  $idx Color is: $ncol"
        $lb configure -bg $ncol
        set collst [lreplace $collst $idx $idx $ncol]
        gui_ini_update "collst" $collst
    }
}
