#! /usr/bin/env wish
############################################################################
##
## Copyright 2014  Ken Campbell
##
##   Licensed under the Apache License, Version 2.0 (the "License");
##   you may not use this file except in compliance with the License.
##   You may obtain a copy of the License at
##
##     http://www.apache.org/licenses/LICENSE-2.0
##
##   Unless required by applicable law or agreed to in writing, software
##   distributed under the License is distributed on an "AS IS" BASIS,
##   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
##   See the License for the specific language governing permissions and
##   limitations under the License.
##
#####################################
## Description :
##      This application will generate a random register/memory map for
##        testing.  It is not fully correct in it's generation ... yet.
##########################################################
#  Packages
package require Ttk
package require Tk


set version "v0.01"
wm title . "Register Gen $version"

set fld_fr [frame .fldfr]
set mmap_fr [frame $fld_fr.mmfr -borderwidth 4 -relief raised]
set mmap_en [entry $mmap_fr.mmen -width 3]
set mmap_lb [label $mmap_fr.lb1 -text "Memory Maps: "]
pack $mmap_lb $mmap_en -side left
pack $mmap_fr -anchor w


set blk_fr [frame $fld_fr.blkfr -borderwidth 4 -relief raised]
set blk_en [entry $blk_fr.blken -width 3]
set blk_lb [label $blk_fr.lb1 -text "Blocks: "]
pack $blk_lb $blk_en -side left
pack $blk_fr -anchor w

set mem_fr [frame $fld_fr.memfr -borderwidth 4 -relief raised]
set mem_en [entry $mem_fr.memen -width 3]
set mem_lb [label $mem_fr.lb1 -text "Memory: "]
pack $mem_lb $mem_en -side left
pack $mem_fr -anchor w

set reg_fr [frame $fld_fr.regfr -borderwidth 4 -relief raised]
set reg_en [entry $reg_fr.regen -width 4]
set reg_lb [label $reg_fr.lb1 -text "Registers: "]
pack $reg_lb $reg_en -side left
pack $reg_fr -anchor w

set flds_fr [frame $fld_fr.fldsfr -borderwidth 4 -relief raised]
set flds_en [entry $flds_fr.en -width 4]
set flds_lb [label $flds_fr.lb1 -text "Fields:  "]
pack $flds_lb $flds_en -side left
pack $flds_fr -anchor w

pack $fld_fr -fill both -expand 1


set bt_fr [frame .bts -borderwidth 4 -relief raised]
set gen_but [button $bt_fr.genbt -text "Generate" -command gen_regs]
set seed_en [entry $bt_fr.sd_en -width 3]
pack $gen_but -side left
pack $seed_en -side right
pack $bt_fr -fill x -expand 1


proc gen_regs {} {
    global mmap_en blk_en mem_en flds_en reg_en seed_en
    
    # get random gen initialized
    set seed [$seed_en get]
    #set seed [expr {$lv + $seed}]
    set dho [expr {srand ($seed)}]
    
    set fh [open "gen_reg.regx" w]
    
    set nmap [$mmap_en get]
    set nblk [$blk_en get]
    set nmem [$mem_en get]
    set nreg [$reg_en get]
    set nfld [$flds_en get]
    
    
    for {set mm 0} {$mm < $nmap} {incr mm} {
        puts $fh "1,Map$mm,0,80000000"
        puts $fh "2,32,32,Byte"
        gen_comment $fh "Map$mm"
        set map_name "."
        append map_name "Map$mm"
        set num_blk [expr { int(rand() * $nblk) + 2}]
        set bstart 0
        for {set nb 0} {$nb < $num_blk} {incr nb} {
            set bt_n [expr { int(rand() * 4) + 1}]
            puts $bt_n
            switch $bt_n {
                "1" {set btype "RAM"; set bacc "RW"}
                "2" {set btype "ROM"; set bacc "RO"}
                "3" {set btype "REG"; set bacc "RW"}
                "4" {set btype "MIX"; set bacc "RW"}
            }
            puts $fh "3,Block_$nb,$bstart,200000,$bacc,$btype,$map_name"
            gen_comment $fh "Block_$nb"
            set bstart [expr {$bstart + 1000000}]
            switch $bt_n {
                "1" {gen_ram $fh $nmem}
                "2" {gen_rom $fh $nmem}
                "3" {gen_reg $fh $nreg $nfld "Block_$nb"}
            }
        }
    }
    close $fh
}

proc gen_fields {fh max facc} {
    set r [expr { int(rand() * $max) + 1}]
    set fld_width 32
    set idx 0
    for {set i 0} {$i < $r} {incr i} {
        set sz [expr { int(rand() * 8) + 1}]
        set uidx [expr {$idx + $sz - 1}]
        set ftyp [expr { int(rand() * 4) + 1}]
        set rnum [expr { int(rand() * 10000) + 1}]
        set racc [expr {int(rand() * 2)}]
        if {$racc < 1 && $facc != "RO"} {
            set tacc "RW"
        } else {
            set tacc "RO"
        }
        set ftypt ""
        #puts $ftyp
        switch $ftyp {
            "1" {set ftypt "boo"}
            "2" {set ftypt "ran"}
            "3" {set ftypt "enu"}
            "4" {set ftypt "res"}
        }
        if {$ftypt == "res"} {
            set name "RESERVED_$idx"
            append name "_$uidx"
            puts $fh "11,$name,$idx,$sz,RO,0,$ftypt"
        } else {
            set name "FLD_"
            append name $rnum "_" $i
            puts $fh "11,$name,$idx,$sz,$tacc,0,$ftypt"
        }
        
        if {$ftypt == "ran"} {
            set max [expr {2**$sz}]
            puts $fh "12,0,$max"
        }
        if {$ftypt == "enu"} {
            set max [expr {2**$sz}]
            set num [expr { int(rand() * $max) + 1}]
            
            for {set j 0} {$j < $num} {incr j} {
                puts $fh "13,ENUM_$j,$j"
            }
        }
        
        gen_comment $fh "FLD_$i"
        ##gen_fields $fh $max
        set idx [expr {$idx + $sz}]
        if {$idx >= 32} {
            break
        }
    }
    
}



proc gen_reg {fh max maxfld par} {
    set r [expr { int(rand() * $max) + 1}]
    for {set i 0} {$i < $r} {incr i} {
        set racc [expr {int(rand() * 10)}]
        puts $racc
        if {$racc > 8} {
            set racct "RO"
        } else {
            set racct "RW"
        }
        set h [format "%x" $i]
        puts $fh "10,REG_$i,$h,$racct"
        set head $par
        append head "_REG_$i"
        gen_comment $fh $head
        gen_fields $fh $maxfld $racct
    }
}



proc gen_ram {fh max} {
    set r [expr { int(rand() * $max) + 1}]
    for {set i 0} {$i < $r} {incr i} {
        puts $fh "6,RAM_$i,0,32,2M,RW,x"
        gen_comment $fh "RAM_$i"
    }
}
proc gen_rom {fh max} {
    set r [expr { int(rand() * $max) + 1}]
    for {set i 0} {$i < $r} {incr i} {
        puts $fh "6,ROM_$i,0,32,2M,R0,0"
        gen_comment $fh "ROM_$i"
    }
}

proc gen_comment {fh name} {
    ## for some number r
    set r [expr { int(rand() * 9) + 1}]
    for {set i 0} {$i < $r} {incr i} {
        puts $fh "14,$name Description text $i"
    }
}


##############################
bind . <F12> {catch {console show}}
