############################################################################
##
## Copyright 2014  Ken Campbell
##
##   Licensed under the Apache License, Version 2.0 (the "License");
##   you may not use this file except in compliance with the License.
##   You may obtain a copy of the License at
##
##     http://www.apache.org/licenses/LICENSE-2.0
##
##   Unless required by applicable law or agreed to in writing, software
##   distributed under the License is distributed on an "AS IS" BASIS,
##   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
##   See the License for the specific language governing permissions and
##   limitations under the License.
##
#####################################
##
## Description :
##      This file contains the event related code for the Register Workbench
##      GUI.
##      -  Right click on a field pops up a dialog with help info.
##
##------------------------------------------------------------------------------

##############################
bind . <F12> {catch {console show}}

#############
##
bind . <Motion> "+mouse_move %W %x %y"
############
##  the zone and action for mouse movement
proc mouse_move {wid x y} {
    global helpVar pwm curr_wid

    #set pzero [$pwmm sash coord 0]
    set curr_wid $wid

    #set helpVar "x: $x y: $y Win: $wid"
    #set c_wid $wid

    #if {[string first $tm_cav $wid] == 0} {
    #}
}
####################################
##   mouse wheel
bind . <MouseWheel> "+ mouse_wheel %W %D %x %y"

proc mouse_wheel {wid dir x y} {
    global mmap_cav blk_cav mmap_tree_tr curr_wid
    ## curr_wid comes from mouse_move
    set blk [string first $blk_cav $curr_wid]
    set map [string first $mmap_cav $curr_wid]
    ## if mouse is over canvas  scroll
    if {$map >= 0} {
        $mmap_cav yview scroll [expr {$dir / -10}] units
    } elseif {$blk >= 0} {
        $blk_cav yview scroll [expr {$dir / -10}] units
    }
}

##################################################################
## treeview event handlers
##  call update details frame and maintain item open list
##  mouse click in memory map tree
bind $mmap_tree_tr <<TreeviewSelect>> {
    gui_pack_detail_fr
}
##  click open tree item
bind $mmap_tree_tr <<TreeviewOpen>> {
    set item [%W selection]
    #puts "about to open $item"
    set is [lsearch -exact $ItemOpenLst $item]
    if {$is < 0} {
        lappend ItemOpenLst $item
    }
    #puts $ItemOpenLst
}
## click close tree item
bind $mmap_tree_tr <<TreeviewClose>> {
    set item [%W selection]
    set is [lsearch -exact $ItemOpenLst $item]
    #puts "Deleting item ..."
    #puts $is
    #puts $ItemOpenLst
    if {$is >= 0} {
        set ItemOpenLst [lreplace $ItemOpenLst $is $is]
    }
    #puts $ItemOpenLst
}
##  Key presses in the Register name entry box
#bind $reg_name_en <KeyRelease> {
#   puts "Pressed %K @ %W"
#   set sel [%W get]
#   set idx [lsearch $RegLst $current_reg]
#   set RegLst [lreplace $RegLst $idx $idx $sel]
#   if {$sel != ""} {
#       set current_reg $sel
#    }
#   puts " $sel $current_reg"
#   #update_fld_detail $sel
#}

bind $reg_idx_cb1 <<ComboboxSelected>> {

    set sel [%W get]
    #puts "Selected Register: $sel"

    set idx [lsearch $RegLst $sel]
    set ::IndexFldLst [lindex $FldLst $idx]
    $reg_idx_cb2 configure -values $IndexFldLst
    $reg_idx_cb2 current 0
    #puts $IndexFldLst
}

#bind . <FocusOut> "+validate_ent %W"

#########################################################
##  right click menu pop up control
bind . <ButtonRelease-3> "+select_2 %W %X %Y"

proc select_2 {wid x y} {
    global m mmap_tree_tr mem_map_frame botframe
    global mem_fr regd fldd mem_block_fr
    global mblk_desc_fr mem_desc_fr reg_desc_fr
    global fldd_type_fr fldd_desc_fr fldd_range_fr fldd_enum_fr fldd_sidx_fr fldd_but_fr
    global current_reg
    global mmap_reso_fr mmap_name_fr mmap_base_fr mmap_size_fr mmap_widt_fr mmap_mwid_fr mmap_desc_fr
    global blk_fld_lst mem_fld_lst reg_fld_lst fld_fld_lst

    #puts $wid

    # only effective when a register has been selected.
    #if {$current_reg != ""} {
        #$m delete 0 end
        #puts "$wid\n [$reglstb curselection]"
        #set rname [$reglstb get [$reglstb curselection]]
        #if {[string first $mmap_tree_tr $wid] == 0} {
        #    $m add command -label "Add, Insert, Edit or Delete" -command {}
        #    # add a new Register to the Registers List
        #    $m add command -label "Add Register" -command {puts "Adding Register"}
        #    # Edit the name if the selected register
        #    $m add command -label "Edit Register Name" -command {puts "Editing Name of $current_reg"}
        #    # add command to delete this item
        #    $m add command -label "Delete Register $current_reg" -command [puts "Deleting Register $current_reg"]
        #    # pop up the menu
        #    tk_popup $m $x $y
        #}
    #}
    #set in_frame [string first $mmap_reso_fr $wid]
    if {[string first $mem_map_frame $wid] >= 0} {
        if {[string first $mmap_reso_fr $wid] >= 0} {
            puts "Right click in $mmap_reso_fr"
            set reply [tk_dialog .dia "Resolution Field Help" \
            "This is the Resolution of the accesses.\n \
            Word being the bit width.  A 32 bit width system\n \
            with \"Word\" access will have the addresses\n \
            incremented by one.  A 32 bit width system with \n \
            \"Byte\" resolution will have its addresses\n incremented by four." "" 0 Ok]
        } elseif {[string first $mmap_name_fr $wid] >= 0} {
            set reply [tk_dialog .dia "Name Field Help & Buttons"\
            "This is the entry for Memory Map Name.\n" "" 0 Ok]
        } elseif {[string first $mmap_base_fr $wid] >= 0} {
            set reply [tk_dialog .dia "Base Address Field Help"\
            "This is the entry for Memory Map Base Address.\n\
            This is a hexadecimal field.\n\
            All addresses under this memory map use this as the\n\
            starting point for all addresses below.\n"\
            "" 0 Ok]
        } elseif {[string first $mmap_size_fr $wid] >= 0} {
            set reply [tk_dialog .dia "Memory Map Size Field Help"\
            "This is the entry for Memory Map Size.\n\
            This is a selectable.\n\
            Sizes can be selected based on powers of 2.\n\
            This number represents the number of addressable locations.\n"\
            "" 0 Ok]
        } elseif {[string first $mmap_widt_fr $wid] >= 0} {
            set reply [tk_dialog .dia "Data Width Field Help"\
            "This is the entry for Memory Map Data Width.\n\
            This is a decimal field.\n\
            All accesses to this memory map use this as the basic\n\
            access data width.\n"\
            "" 0 Ok]
        } elseif {[string first $mmap_mwid_fr $wid] >= 0} {
            set reply [tk_dialog .dia "Minimum Access Width Field Help"\
            "This is the entry for Memory Map Data Minimum Access Width.\n\
            This is a decimal field.\n\
            All addresses under this memory map have the ability to\n\
            access data to this minium width.\n"\
            "" 0 Ok]
        } elseif {[string first $mmap_desc_fr $wid] >= 0} {
            set reply [tk_dialog .dia "Memory Map Description Field Help"\
            "This is the entry for Memory Map Description.\n\
            This is a text field.\n\
            This field contains any description of the Memory\n\
            Map.  This content will be used in generated\n\
            documentation.  View and or enable the display of\n\
            the text window, check the Description checkbox."\
            "" 0 Ok]
        }
    }
    ##  Block frame
    if {[string first $mem_block_fr $wid] >= 0} {
        if {[string first [lindex $blk_fld_lst 0] $wid] >= 0} {
            set reply [tk_dialog .dia "Block Name Field Help"\
            "This is the Block Name entry field.\n\
            It follows Naming field conventions."\
            "" 0 Ok]
        } elseif {[string first [lindex $blk_fld_lst 1] $wid] >= 0} {
            set reply [tk_dialog .dia "Block Start Address Help"\
            "This is the Block Start Address entry field.\n\
            This is a hexadecimal field.  This start address is\n\
            used as the base address for items within this block."\
            "" 0 Ok]
        } elseif {[string first [lindex $blk_fld_lst 2] $wid] >= 0} {
            set reply [tk_dialog .dia "Block Address Depth Help"\
            "This is the Block Address Depth combo box.\n\
            This is a drop down selection of x to the power of 2."\
            "" 0 Ok]
        } elseif {[string first [lindex $blk_fld_lst 5] $wid] >= 0} {
            set reply [tk_dialog .dia "Block Access type Help"\
            "This is the Block Access type combo box.\n\
            Select the access type from drop down menue."\
            "" 0 Ok]
        } elseif {[string first $mblk_desc_fr $wid] >= 0} {
            set reply [tk_dialog .dia "Block Description Help"\
            "This is the Block Description field.\n\
            This is any textual description of the Block."\
            "" 0 Ok]
        } elseif {[string first [lindex $blk_fld_lst 3] $wid] >= 0} {
            set reply [tk_dialog .dia "Block Type Help"\
            "This is the Block Type field.\n\
            The types are:  RAM, ROM, REG or MIX.\n\
            The MIX type enables any mix of registers, RAM and ROM."\
            "" 0 Ok]
        }
    }
    ##  memory frame
    if {[string first $mem_fr $wid] >= 0} {
        if {[string first [lindex $mem_fld_lst 0] $wid] >= 0} {
            set reply [tk_dialog .dia "Memory Name Field Help"\
            "This is the Memory Name entry field.\n\
            It follows Naming field conventions."\
            "" 0 Ok]
        } elseif {[string first [lindex $mem_fld_lst 1] $wid] >= 0} {
            set reply [tk_dialog .dia "Memory Start Address Field Help"\
            "This is the Memory Start Address entry field.\n\
            It expects a hexadecimal number."\
            "" 0 Ok]
        } elseif {[string first [lindex $mem_fld_lst 3] $wid] >= 0} {
            set reply [tk_dialog .dia "Memory Depth Field Help"\
            "This is the Memory Depth combo box.\n\
            This is a drop down selection of x to the power of 2."\
            "" 0 Ok]
        } elseif {[string first [lindex $mem_fld_lst 2] $wid] >= 0} {
            set reply [tk_dialog .dia "Memory Width Field Help"\
            "This is the Memory Width field.\n\
            The width is stated in bits.  This is a decimal field."\
            "" 0 Ok]
        } elseif {[string first [lindex $mem_fld_lst 4] $wid] >= 0} {
            set reply [tk_dialog .dia "Memory Access Type Help"\
            "This is the Memory Access combo box.\n\
            Select RW for read write access and RO for read only."\
            "" 0 Ok]
        } elseif {[string first [lindex $mem_fld_lst 5] $wid] >= 0} {
            set reply [tk_dialog .dia "Memory Default Value Help"\
            "This is the Memory Default Value field.\n\
            State the default value, if unknow insert x or X.\
            This is an uncontrolled value field."\
            "" 0 Ok]
        } elseif {[string first $mem_desc_fr $wid] >= 0} {
            set reply [tk_dialog .dia "Memory Description Field Help"\
            "This is the Memory Description field.\n\
            This is any textual description of the Memory."\
            "" 0 Ok]
        }
    }
    ##  register frame
    if {[string first $regd $wid] >= 0} {
        if {[string first [lindex $reg_fld_lst 0] $wid] >= 0} {
            set reply [tk_dialog .dia "Register Name Field Help"\
            "This is the Register Name entry field.\n\
            It follows Naming field conventions."\
            "" 0 Ok]
        } elseif {[string first [lindex $reg_fld_lst 1] $wid] >= 0} {
            set reply [tk_dialog .dia "Register Address Field Help"\
            "This is the Register Address entry field.\n\
            It expects a hexadecimal number.  This number is the\
            the location offset from the start of the block.\
            Each register address should increment by one."\
            "" 0 Ok]
        } elseif {[string first [lindex $reg_fld_lst 2] $wid] >= 0} {
            set reply [tk_dialog .dia "Register Access Field Help"\
            "This is the Register Access combo box.\n\
            Select the access type as required."\
            "" 0 Ok]
        } elseif {[string first $reg_desc_fr $wid] >= 0} {
            set reply [tk_dialog .dia "Register Description Field Help"\
            "This is the Register Description field.\n\
            This is any textual description of the Register."\
            "" 0 Ok]
        } else {
            set reply [tk_dialog .dia "Not Implemented Help"\
            "This Field has not been implemented in the tool yet."\
            "" 0 Ok]
        }
    }
    ##  fields frame
    if {[string first $fldd $wid] >= 0} {
        if {[string first [lindex $fld_fld_lst 0] $wid] >= 0} {
            set reply [tk_dialog .dia "Field Name Help"\
            "This is the Register Field Name entry field.\n\
            It follows Naming field conventions."\
            "" 0 Ok]
        } elseif {[string first [lindex $fld_fld_lst 1] $wid] >= 0} {
            set reply [tk_dialog .dia "Field Start Bit Help"\
            "This is the Field Start bit entry field.\n\
            This is a decimal number of the start location of\
            the bit field."\
            "" 0 Ok]
        } elseif {[string first [lindex $fld_fld_lst 2] $wid] >= 0} {
            set reply [tk_dialog .dia "Field Size Help"\
            "This is the Field Size entry field.\n\
            This is a decimal number stating the field width\
            in bits."\
            "" 0 Ok]
        } elseif {[string first [lindex $fld_fld_lst 3] $wid] >= 0} {
            set reply [tk_dialog .dia "Field Access Help"\
            "This is the Field Access Type combo box.\n\
            Select the type based on its access.\n\
            RW  Read Write access.\n\
            RO  Read Only access.\n\
            WO  Write Only access.\n\
            RW1 Read and Write Once access.\n\
            W1  Write Once Only access."\
            "" 0 Ok]
        } elseif {[string first [lindex $fld_fld_lst 4] $wid] >= 0} {
            set reply [tk_dialog .dia "Field Reset Value Help"\
            "This is the Field Reset Value entry field.\n\
            This is a hexadecimal number stating the value after\n\
            reset."\
            "" 0 Ok]
        } elseif {[string first $fldd_type_fr $wid] >= 0} {
            set reply [tk_dialog .dia "Field Type Select Help"\
            "This is the Field Type selection frame.\n\
            Boolean: This is a bit wise or single bit field.\n\
            Ranged:  This is a ranged field, fill range specs.\n\
            Enumerated: An enumerated field, fill Enum specs.\n\
            Reserved:  A reserved field, no write access, Reads 0."\
            "" 0 Ok]
        } elseif {[string first $fldd_desc_fr $wid] >= 0} {
            set reply [tk_dialog .dia "Field Description Field Help"\
            "This is the Field Description field.\n\
            This is any textual description of the Field."\
            "" 0 Ok]
        } elseif {[string first $fldd_range_fr $wid] >= 0} {
            set reply [tk_dialog .dia "Field Range Help"\
            "This is the Field Range frame.\n\
            The two entry fields expect hexadecimal numbers.\n\
            Enter the minum of the range value in the min field\n\
            and the maximum of the range is the max field."\
            "" 0 Ok]
        } elseif {[string first $fldd_enum_fr $wid] >= 0} {
            set reply [tk_dialog .dia "Field Enumerated Help"\
            "This is the Field Enuerated Values field.\n\
            This field expects a Name and a vaule pair for\n\
            each enumerated value.  The syntax is as follows:\n\
            <name text>,<decimal value>\n\
            One line for each value."\
            "" 0 Ok]
        } elseif {[string first $fldd_sidx_fr $wid] >= 0} {
            return
        } elseif {[string first $fldd_but_fr $wid] >= 0} {
            return
        } else {
            set reply [tk_dialog .dia "Not Implemented Help"\
            "This Field has not been implemented in the tool yet."\
            "" 0 Ok]
        }
    }
}
#########################################################
##  control-key  bindings

##  control l   Load file
bind . <Control-KeyPress-l> "+my_load %K"
proc my_load {key} {
    gui_load_file
}
##  Control-a  Add an item
bind . <Control-KeyPress-a> "my_add %K"
proc my_add {key} {
    global ButtonMode
    switch $ButtonMode {
        "mmap" {gui_add_block}
        "reg" {gui_add_field "Ad"}
        "fld" {gui_add_field "Ad"}
        "blk" {gui_add_memory}
        "blk_reg" {gui_add_register}
        default {}
    }
}

##  Control-e  Edit an item
bind . <Control-KeyPress-e> "my_edit %K"
proc my_edit {key} {
    global ButtonMode
    switch $ButtonMode {
        "mmap" {gui_edit_memory_map}
        "mem" {gui_edit_memory}
        "reg" {gui_edit_register}
        "fld" {gui_add_field "Ed"}
        "blk" {gui_edit_block}
        "blk_reg" {gui_edit_block}
        "blk_mix" {gui_edit_block}
        default {}
    }
}

##  Control-r   Add register to mixed block
bind . <Control-KeyPress-r> "my_addmix_reg %K"
proc my_addmix_reg {key} {
    global ButtonMode
    switch $ButtonMode {
        "blk_mix" {gui_add_register}
        default {}
    }
}

##  Control-m   Add memory to mixed block
bind . <Control-KeyPress-m> "my_addmix_mem %K"
proc my_addmix_mem {key} {
    global ButtonMode
    switch $ButtonMode {
        "blk_mix" {gui_add_memory}
        default {}
    }
}

##  Control-s   Save  edits
bind . <Control-KeyPress-s> "my_save_item %K"
proc my_save_item {key} {
    global ButtonMode
    switch $ButtonMode {
        "save" {gui_save}
        default {}
    }
}

##  Control-c   Cancel  edits
bind . <Control-KeyPress-c> "my_cancel_edits %K"
proc my_cancel_edits {key} {
    global ButtonMode
    switch $ButtonMode {
        "save" {gui_cancel}
        default {}
    }
}

##  Control-d   Delete Item
bind . <Control-KeyPress-d> "my_delete_item %K"
proc my_delete_item {key} {
    gui_delete
}
