############################################################################
##
## Copyright 2014  Ken Campbell
##
##   Licensed under the Apache License, Version 2.0 (the "License");
##   you may not use this file except in compliance with the License.
##   You may obtain a copy of the License at
##
##     http://www.apache.org/licenses/LICENSE-2.0
##
##   Unless required by applicable law or agreed to in writing, software
##   distributed under the License is distributed on an "AS IS" BASIS,
##   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
##   See the License for the specific language governing permissions and
##   limitations under the License.
##
#####################################
##   Description:
##  Procs that are intended for the GUI.
#################################################################


set normback "grey82"

#######################################################
## find and return the item from the IndexItemLst.
##
##    Returns  the list item from the IndexItemLst
##
proc find_index { id } {
    global IndexItemLst

    set rtn {}
    set idx 0
    #set len [llength $FullLst]

    foreach i $IndexItemLst {
        set found [lsearch $i $id]
        if {$found >= 0} {
            set rtn $i
            break
        }
        incr idx
    }
    return $rtn
}
proc find_index_end { idx } {
    global FullLst

    #puts $idx
    if {$idx == ""} {
        return
    }

    set start [expr {$idx + 1}]
    set len [llength $FullLst]
    set rtn 0
    set tlst {}
    lappend tlst 1 3 6 10 11
    set found 0
    #puts $tlst

    for {set i $start} {$i < $len} {incr i} {
        set ftyp [lindex $FullLst $i]
        set sftyp [split $ftyp ","]
        set typ [lindex $sftyp 0]
        #puts $typ
        foreach t $tlst {
            if {$typ == $t} {
                set found 1
                break
            }
        }
        if {$found == 1} {
            break
        }
        set rtn $i
    }
    if {$i == $start} {
##        set rtn $start
        set rtn $idx
    }
    return $rtn
}

proc get_index_detail {} {
    global mmap_tree_tr

    set id [$mmap_tree_tr selection]
    if {$id == ""} {
        set is [$mmap_tree_tr identify row 25 30]
        #puts $is
        $mmap_tree_tr selection set $is
        $mmap_tree_tr focus $is
        focus $mmap_tree_tr
    }

    set rtn [find_index $id]
    set start [lindex $rtn 1]
    lappend rtn [find_index_end $start]
    return $rtn
}
#####################################################
##  get the resoultion of accesses
##   return number (address multiplyer)
proc get_reso {} {
    global mmap_tree_tr FullLst

    ## get the map id
    set id [$mmap_tree_tr selection]
    set mapid .
    append mapid [lindex [split $id "."] 1]
    set mdesc [find_index $mapid]
    ## get the start idx of the memory map
    set idx [lindex $mdesc 1]
    ## point to the next record
    incr idx
    set map_reso [split [lindex $FullLst $idx] ","]
    set resol [lindex $map_reso 3]
    set width [lindex $map_reso 1]

    if {$resol == "Byte"} {
        set rtn [expr {$width / 8}]
    } else {
        set rtn 1
    }
    #puts $rtn
    return $rtn
}
## get the register / memory width for selected.
proc get_width {} {
    global mmap_tree_tr FullLst

    ## get the map id
    set id [$mmap_tree_tr selection]
    set mapid .
    append mapid [lindex [split $id "."] 1]
    set mdesc [find_index $mapid]
    ## get the start idx of the memory map
    set idx [lindex $mdesc 1]
    ## point to the next record
    incr idx
    set map_reso [split [lindex $FullLst $idx] ","]
    #set resol [lindex $map_reso 3]
    set width [lindex $map_reso 1]

    return $width
}


######################################################
##  append to list the description field records
proc append_desc_recs {lst desc} {
    set rtn $lst
    set txt [$desc get 0.0 end]
    set dlen [$desc count -lines 0.0 end]
    set sdesc [split $txt "\n"]
    for {set i 0} {$i < $dlen} {incr i} {
        if {[lindex $sdesc $i] == "" && $i == [expr {$dlen - 1}]} {
            break
        }
        lappend rtn "14,[lindex $sdesc $i]"
    }
    return $rtn
}
#########################################################################################
##  procs for enabling, disabling and clearin entry fields
##   input :  fields to enable/disable  {mmap blk mem reg fld}
proc gui_enable_fields {flds} {
    global mmap_fld_lst blk_fld_lst mem_fld_lst reg_fld_lst fld_fld_lst
    if {$flds == "mmap"} {
        set fld_lst $mmap_fld_lst
    } elseif {$flds == "blk"} {
        set fld_lst $blk_fld_lst
    } elseif {$flds == "mem"} {
        set fld_lst $mem_fld_lst
    } elseif {$flds == "reg"} {
        set fld_lst $reg_fld_lst
    } elseif {$flds == "fld"} {
        set fld_lst $fld_fld_lst
    } else {
        puts "ERROR:  unknow input to gui_enable_fields  $flds"
        return
    }
    foreach f $fld_lst {
        $f configure -state normal
    }
}
##  disable fields
proc gui_disable_fields {flds} {
    global mmap_fld_lst blk_fld_lst mem_fld_lst reg_fld_lst fld_fld_lst

    if {$flds == "mmap"} {
        set fld_lst $mmap_fld_lst
    } elseif {$flds == "blk"} {
        set fld_lst $blk_fld_lst
    } elseif {$flds == "mem"} {
        set fld_lst $mem_fld_lst
    } elseif {$flds == "reg"} {
        set fld_lst $reg_fld_lst
    } elseif {$flds == "fld"} {
        set fld_lst $fld_fld_lst
    } else {
        puts "ERROR:  unknow input to gui_disable_fields  $flds"
        return
    }
    foreach f $fld_lst {
        $f configure -state disable
    }
}
## clear fields
proc gui_clear_fields {flds} {
    global mmap_fld_lst blk_fld_lst mem_fld_lst reg_fld_lst fld_fld_lst

    if {$flds == "mmap"} {
        set fld_lst $mmap_fld_lst
    } elseif {$flds == "blk"} {
        set fld_lst $blk_fld_lst
    } elseif {$flds == "mem"} {
        set fld_lst $mem_fld_lst
    } elseif {$flds == "reg"} {
        set fld_lst $reg_fld_lst
    } elseif {$flds == "fld"} {
        set fld_lst $fld_fld_lst
    } else {
        puts "ERROR:  unknow input to gui_clear_fields  $flds"
        return
    }
    ## for now only clear  entry and text fields
    foreach f $fld_lst {
        set typ [winfo class $f]
        if {$typ == "Entry"} {
            $f delete 0 end
        } elseif {$typ == "Text"} {
            $f delete 0.0 end
        }
    }
}
##########################################################################################
##  procs for updating the GUI fields
proc update_block_fields {} {
    global mmap_tree_tr mblock_label mblk_name_en mblk_start_en
    global mblk_depth_cb mblk_acc_cb mblk_desc_txt mblk_but_lb mblk_typ_cb
    global blk_fld_lst FullLst EntErrorLst  normback
    ## enable changes
    gui_enable_fields blk
    gui_clear_fields blk
    ## get the block details
    set tmp [get_index_detail]
    set sel [split [lindex $tmp 0] "."]
    ##  update label.
    $mblk_but_lb configure -text "Block: [lindex $sel end]        Memory Map: [lindex $sel end-1]"
    #puts $tmp
    set block_desc [lrange $FullLst [lindex $tmp 1] [lindex $tmp 3]]
    foreach l $block_desc {
        set sl [split $l ","]
        if {[lindex $sl 0] == 3} {
            $mblk_name_en insert end [lindex $sl 1]
            $mblk_start_en insert end [lindex $sl 2]
            set depth [size_to_mdepth [lindex $sl 3]]
            $mblk_depth_cb set $depth
            $mblk_acc_cb set [lindex $sl 4]
            $mblk_typ_cb set [lindex $sl 5]
        } elseif {[lindex $sl 0] == 14} {
            set txt [string range $l 3 end ]
            $mblk_desc_txt insert end "$txt\n"
        }
    }
    ##  check for and highlite errors
    if {$EntErrorLst != {}} {
        foreach ee $EntErrorLst {
            if {[lindex $ee 0] == [lindex $tmp 0]} {
                set elst [lindex $ee 1]
                set addr_err [lsearch $elst "addr"]
                if {$addr_err >= 0} {
                    $mblk_but_lb configure -bg pink
                    $mblk_start_en configure -bg pink
                    $mblk_start_en configure -disabledbackground pink
                    $mblk_start_en configure -highlightbackground pink
                    $mblk_depth_cb configure -foreground red4
                    break
                }
            } else {
                $mblk_but_lb configure -bg grey82
                $mblk_start_en configure -bg white
                $mblk_name_en configure -bg white
                $mblk_start_en configure -disabledbackground grey82
                $mblk_start_en configure -highlightbackground grey82
                $mblk_depth_cb configure -foreground black
            }
        }
    } else {
        $mblk_but_lb configure -bg grey82
        $mblk_start_en configure -bg white
        $mblk_name_en configure -bg white
        $mblk_start_en configure -disabledbackground grey82
        $mblk_start_en configure -highlightbackground grey82
        $mblk_depth_cb configure -foreground black
    }
    gui_disable_fields blk
    update_blk_canv
}

proc update_map_fields {} {
    global mmap_name_lb mmap_name_en mmap_base_en mmap_size_cb
    global mmap_mwid_en mmap_reso_cb mmap_desc_txt mmap_widt_en
    global FullLst msizes

    gui_enable_fields mmap
    gui_clear_fields mmap
    ## needed for when adding the very first memory map.
    set tmp [get_index_detail]
    if {$tmp == "{}"} {
        return
    }
    #puts_FullLst
    #puts "update_map_fields $tmp"
    #set sel [split [lindex $tmp 0] "."]
    set mmap_desc [lrange $FullLst [lindex $tmp 1] [lindex $tmp 3]]
    foreach r $mmap_desc {
        set sr [split $r ","]
        switch [lindex $sr 0] {
            1 {
                $mmap_name_en insert 0 [lindex $sr 1]
                $mmap_base_en insert 0 [lindex $sr 2]
                set depth [size_to_mdepth [lindex $sr 3]]
                $mmap_size_cb set $depth
            }
            2 {
                $mmap_widt_en insert 0 [lindex $sr 1]
                $mmap_mwid_en insert 0 [lindex $sr 2]
                $mmap_reso_cb set [lindex $sr 3]
            }
            14 {
                set txt [string range $r 3 end]
                $mmap_desc_txt insert end "$txt\n"
            }
        }
    }
    gui_disable_fields mmap
    update_mmap_canv
}

proc update_memory_fields {} {
    global mem_but_lb mem_name_en mem_sadd_en mem_widt_en
    global mem_depth_cb mem_acc_cb mem_dval_en mem_desc_txt
    global FullLst EntErrorLst

    gui_enable_fields mem
    gui_clear_fields mem

    set tmp [get_index_detail]
    set sel [split [lindex $tmp 0] "."]
    $mem_but_lb configure -text "Memory: [lindex $sel end]     Block: [lindex $sel end-1]"
    set mem_desc [lrange $FullLst [lindex $tmp 1] [lindex $tmp 3]]
    foreach r $mem_desc {
        set sr [split $r ","]
        if {[lindex $sr 0] == 6} {
            $mem_name_en insert 0 [lindex $sr 1]
            $mem_sadd_en insert 0 [lindex $sr 2]
            $mem_widt_en insert 0 [lindex $sr 3]
            set depth [size_to_mdepth [lindex $sr 4]]
            $mem_depth_cb set $depth
            $mem_acc_cb set [lindex $sr 5]
            $mem_dval_en insert 0 [lindex $sr 6]
        } elseif {[lindex $sr 0] == 14} {
            set txt [string range $r 3 end]
            $mem_desc_txt insert end "$txt\n"
        }
    }
    ##  check for and highlite errors
    if {$EntErrorLst != {}} {
        foreach ee $EntErrorLst {
            if {[lindex $ee 0] == [lindex $tmp 0]} {
                set elst [lindex $ee 1]
                set addr_err [lsearch $elst "addr"]
                if {$addr_err >= 0} {
                    $mem_but_lb configure -bg pink
                    $mem_sadd_en configure -bg pink
                    $mem_sadd_en configure -disabledbackground pink
                    $mem_sadd_en configure -highlightbackground pink
                    $mem_depth_cb configure -foreground red4
                    break
                }
            } else {
                $mem_but_lb configure -bg grey82
                $mem_sadd_en configure -bg white
                $mem_sadd_en configure -disabledbackground grey82
                $mem_sadd_en configure -highlightbackground grey82
                $mem_depth_cb configure -foreground black
            }
        }
    } else {
        $mem_but_lb configure -bg grey82
        $mem_sadd_en configure -bg white
        $mem_sadd_en configure -disabledbackground grey82
        $mem_sadd_en configure -highlightbackground grey82
        $mem_depth_cb configure -foreground black
    }
    gui_disable_fields mem
}

proc update_register_fields {} {
    global regd_lb curr_reg_type reg_name_en reg_addr_ent
    global reg_acc_cb reg_desc_tb reg_enb_ent reg_vis_ent
    global reg_testable_cb reg_volitile_cb
    global reg_testable reg_volitile FullLst EntErrorLst
    global reg_idx_cb1 reg_idx_cb2 reg_con_cb
    ##  get details of selected
    set tmp [get_index_detail]
    set reg_desc [lrange $FullLst [lindex $tmp 1] [lindex $tmp 3]]
    gui_enable_fields reg
    gui_clear_fields reg
    set reg_testable 1
    ##  split the name part
    set sel [split [lindex $tmp 0] "."]
    ## update the label
    $regd_lb configure -text "Register: [lindex $sel end]     of Block: [lindex $sel end-1]"
    ##  update register fields.
    foreach r $reg_desc {
        set sr [split $r ","]
        switch [lindex $sr 0] {
            10 {
                $reg_name_en insert 0 [lindex $sr 1]
                $reg_addr_ent insert 0 [lindex $sr 2]
                $reg_acc_cb set [lindex $sr 3]
            }
            15 {
                $reg_enb_ent insert 0 [lindex $sr 1]
            }
            16 {
                $reg_vis_ent insert 0 [lindex $sr 1]
            }
            17 {
                set reg_volitile [lindex $sr 1]
            }
            18 {
                set reg_testable [lindex $sr 1]
            }
            14 {
                set txt [string range $r 3 end]
                $reg_desc_tb insert end "$txt\n"
            }
        }
    }
    ##  check for and highlite errors
    if {$EntErrorLst != {}} {
        foreach ee $EntErrorLst {
            #puts "[lindex $ee 0]  [lindex $tmp 0]"
            if {[lindex $ee 0] == [lindex $tmp 0]} {
                #puts "Register Error found?"
                $regd_lb configure -bg pink
                $reg_addr_ent configure -bg pink
                $reg_addr_ent configure -disabledbackground pink
                $reg_addr_ent configure -highlightbackground pink
                break
            } else {
                $regd_lb configure -bg grey82
                $reg_addr_ent configure -bg white
                $reg_addr_ent configure -disabledbackground grey82
                $reg_addr_ent configure -highlightbackground grey82
            }
        }
    } else {
        $regd_lb configure -bg grey82
        $reg_addr_ent configure -bg white
        $reg_addr_ent configure -disabledbackground grey82
        $reg_addr_ent configure -highlightbackground grey82
    }
    gui_disable_fields reg
    update_reg_canv $tmp
}

proc update_reg_fields_fields  {} {
    global fldd_lb fldd_name_en fldd_sidx_eni fldd_sidx_ens fldd_sidx_cbc
    global fldd_acc_cb fldd_def_en fldd_desc_tb fldd_conc_cbc
    global fldd_range_min fldd_range_max fldd_enum_ntxt
    global FullLst EntErrorLst
    global fldd_enb_ent fldd_vis_ent fldd_modw_cb1 fldd_modw_cb2
    ## variables
    global fldd_testable fldd_volitile curr_fldd_type

    gui_enable_fields fld
    gui_clear_fields fld
    $fldd_conc_cbc deselect

    set tmp [get_index_detail]
    set sel [split [lindex $tmp 0] "."]
    $fldd_lb configure -text "Field: [lindex $sel end]     of Register: [lindex $sel end-1]"
    set fld_desc [lrange $FullLst [lindex $tmp 1] [lindex $tmp 3]]
    foreach r $fld_desc {
        set sr [split $r ","]
        switch [lindex $sr 0] {
            11 {
                $fldd_name_en insert 0 [lindex $sr 1]
                $fldd_sidx_eni insert 0 [lindex $sr 2]
                $fldd_sidx_ens insert 0 [lindex $sr 3]
                $fldd_acc_cb set [lindex $sr 4]
                $fldd_def_en insert 0 [lindex $sr 5]
                set curr_fldd_type [lindex $sr 6]
                update_flddtype_gui
            }
            12 {
                $fldd_range_min insert 0 [lindex $sr 1]
                $fldd_range_max insert 0 [lindex $sr 2]
            }
            13 {
                $fldd_enum_ntxt insert end "[lindex $sr 1],[lindex $sr 2]\n"
            }
            15 {
                $fldd_enb_ent insert 0 [lindex $sr 1]
            }
            16 {
                $fldd_vis_ent insert 0 [lindex $sr 1]
            }
            17 {
                set fldd_volitile [lindex $sr 1]
            }
            18 {
                set fldd_testable [lindex $sr 1]
            }
            14 {
                set txt [string range $r 3 end]
                $fldd_desc_tb insert end "$txt\n"
            }
            default {puts "ERROR: unsupported record type found in Field description"}
        }
    }
    ##  check for and highlite errors
    if {$EntErrorLst != {}} {
        foreach ee $EntErrorLst {
            if {[lindex $ee 0] == [lindex $tmp 0]} {
                set elst [lindex $ee 1]
                set addr_err [lsearch $elst "addr"]
                if {$addr_err >= 0} {
                    $fldd_lb configure -bg pink
                    $fldd_sidx_eni configure -bg pink
                    $fldd_sidx_eni configure -disabledbackground pink
                    $fldd_sidx_eni configure -highlightbackground pink
                    $fldd_sidx_ens configure -bg pink
                    $fldd_sidx_ens configure -disabledbackground pink
                    $fldd_sidx_ens configure -highlightbackground pink
                    break
                }
            } else {
                $fldd_lb configure -bg grey82
                $fldd_sidx_eni configure -bg white
                $fldd_sidx_eni configure -disabledbackground grey82
                $fldd_sidx_eni configure -highlightbackground grey82
                $fldd_sidx_ens configure -bg white
                $fldd_sidx_ens configure -disabledbackground grey82
                $fldd_sidx_ens configure -highlightbackground grey82
            }
        }
    } else {
        $fldd_lb configure -bg grey82
        $fldd_sidx_eni configure -bg white
        $fldd_sidx_eni configure -disabledbackground grey82
        $fldd_sidx_eni configure -highlightbackground grey82
        $fldd_sidx_ens configure -bg white
        $fldd_sidx_ens configure -disabledbackground grey82
        $fldd_sidx_ens configure -highlightbackground grey82
    }
    gui_disable_fields fld
}

###############################################
##  update the tree view proc
##    delete the tree view and load from FullLst
##    as the tree is build the IndexItemLst is regenerated.
##    at the end reopen the tree view like it was.
proc update_tree_view {} {
    global mmap_tree_tr FullLst ItemLst
    global IndexItemLst ItemOpenLst MemBLst

    ## see if there are no items on the tree view
    set its [$mmap_tree_tr children {}]
    #puts "update_tree_view $its"
    ## reset the IndexItemLst
    set IndexItemLst {}
    if {$its != {}} {
        foreach i $ItemLst {
            $mmap_tree_tr delete $i
        }
    }
    ## setup temp variables
    set ItemLst {}
    set MemBLst {}
    set cur_mmap ""
    set cur_blk  ""
    set cur_blk1  ""
    set cur_mem  ""
    set cur_reg  ""
    set cur_fld  ""
    set mmap_lst {}
    set blk_lst {}
    set mem_lst {}
    set reg_lst {}
    set fld_lst {}
    set idx -1
    ## if the full list is empty,
    if {$FullLst == {}} {
        #puts "Full List empty"
        gui_clear_fields mmap
        gui_enable_fields mmap
        #$mmap_buts_ad configure -state disabled
        #$mmap_buts_ed configure -state disabled
        #$mmap_buts_sv configure -state active
        return
    }
    ## itterate over the full list
    foreach r $FullLst {
        set sr [split $r ","]
        incr idx
        switch [lindex $sr 0] {
            1 {
                set item [$mmap_tree_tr insert {} end -id ".[lindex $sr 1]" -text [lindex $sr 1]]
                $mmap_tree_tr set $item TYPE "Mem Map"
                ## ItemLst is a list of top level items that can be deleted in the tree
                lappend ItemLst $item
                ## maintain the IndexItemLst
                if {$cur_mmap == ""} {
                    set mmap_lst ".[lindex $sr 1]"
                    lappend mmap_lst $idx
                } else {
                    lappend mmap_lst $idx
                    lappend IndexItemLst $mmap_lst
                    #puts "placing $mmap_lst"
                    set mmap_lst ".[lindex $sr 1]"
                    lappend mmap_lst $idx
                }
                if {[llength $reg_lst] == 2} {
                    lappend reg_lst $idx
                    lappend IndexItemLst $reg_lst
                }
                if {[llength $fld_lst] == 2} {
                    lappend fld_lst $idx
                    lappend IndexItemLst $fld_lst
                }
                if {[llength $mem_lst] == 2} {
                    lappend mem_lst $idx
                    lappend IndexItemLst $mem_lst
                }
                if {[llength $blk_lst] == 2} {
                    lappend blk_lst $idx
                    lappend IndexItemLst $blk_lst
                }
                ## update the current mmap
                set cur_mmap [lindex $sr 1]
                set cur_blk  ""
                set cur_blk1  ""
                set cur_reg  ""
            }
            3 {
                set id_str "[lindex $sr 6].[lindex $sr 1]"
                #if {$cur_mmap != ""} {
                #    append id_str ".$cur_mmap"
                #}
                #append id_str ".[lindex $sr 1]"
                set btype [lindex $sr 5]
                set block [$mmap_tree_tr insert "[lindex $sr 6]" end -id $id_str -text [lindex $sr 1]]
                $mmap_tree_tr set $block TYPE "Block $btype"
                ## maintain the IndexItemLst for current block
                if {$cur_blk == ""} {
                    set blk_lst $id_str
                    lappend blk_lst $idx
                } else {
                    lappend blk_lst $idx
                    lappend IndexItemLst $blk_lst
                    #puts "placing  $blk_lst"
                    set blk_lst $id_str
                    lappend blk_lst $idx
                }
                if {[llength $reg_lst] == 2} {
                    lappend reg_lst $idx
                    lappend IndexItemLst $reg_lst
                }
                if {[llength $fld_lst] == 2} {
                    lappend fld_lst $idx
                    lappend IndexItemLst $fld_lst
                }
                if {[llength $mem_lst] == 2} {
                    lappend mem_lst $idx
                    lappend IndexItemLst $mem_lst
                }
                ## update the current block
                set cur_blk [lindex $sr 1]
                lappend MemBLst $id_str
                set cur_reg  ""
                set cur_mem ""
            }
            6 {
                set id_str ""
                if {$cur_mmap != ""} {
                    append id_str ".$cur_mmap"
                }
                if {$cur_blk != ""} {
                    append id_str ".$cur_blk"
                }
                append id_str ".[lindex $sr 1]"
                #puts $id_str
                ## check if memory being added to top level
                set id_len [llength [split $id_str "."]]
                if {$id_len == 2} {
                    set block {}
                    lappend ItemLst $id_str
                }
                set mem_item [$mmap_tree_tr insert $block end -id $id_str -text [lindex $sr 1]]
                $mmap_tree_tr set $mem_item TYPE "Memory"
                ## maintain the IndexItemLst for current memory
                if {$cur_mem == ""} {
                    set mem_lst $id_str
                    lappend mem_lst $idx
                } else {
                    lappend mem_lst $idx
                    lappend IndexItemLst $mem_lst
                    #puts "placing  $mem_lst"
                    set mem_lst $id_str
                    lappend mem_lst $idx
                }
                if {[llength $reg_lst] == 2} {
                    lappend reg_lst $idx
                    lappend IndexItemLst $reg_lst
                }
                if {[llength $fld_lst] == 2} {
                    lappend fld_lst $idx
                    lappend IndexItemLst $fld_lst
                }
                ## set the current memory
                set cur_mem [lindex $sr 1]
            }
            10 {
                set id_str ""
                if {$cur_mmap != ""} {
                    append id_str ".$cur_mmap"
                }
                if {$cur_blk != ""} {
                    append id_str ".$cur_blk"
                }
                append id_str ".[lindex $sr 1]"
                set reg [$mmap_tree_tr insert $block end -id $id_str -text [lindex $sr 1]]
                $mmap_tree_tr set $reg TYPE "Register"
                ## maintain the IndexItemLst for this register or previous
                if {$cur_reg == ""} {
                    set reg_lst $id_str
                    lappend reg_lst $idx
                } else {
                    lappend reg_lst $idx
                    lappend IndexItemLst $reg_lst
                    set reg_lst $id_str
                    lappend reg_lst $idx
                    if {[llength $fld_lst] == 2} {
                        lappend fld_lst $idx
                        lappend IndexItemLst $fld_lst
                    }
                }
                if {[llength $mem_lst] == 2} {
                    lappend mem_lst $idx
                    lappend IndexItemLst $mem_lst
                }
                set cur_reg [lindex $sr 1]
                set cur_fld ""
                set cur_mem ""
            }
            11 {
                set id_str ""
                if {$cur_mmap != ""} {
                    append id_str ".$cur_mmap"
                }
                if {$cur_blk != ""} {
                    append id_str ".$cur_blk"
                }
                append id_str ".$cur_reg.[lindex $sr 1]"
                set rfield [$mmap_tree_tr insert $reg end -id $id_str -text [lindex $sr 1]]
                $mmap_tree_tr set $rfield TYPE "Register Field"
                #lappend ItemLst $item
                if {$cur_fld == ""} {
                    set fld_lst $id_str
                    lappend fld_lst $idx
                } else {
                    lappend fld_lst $idx
                    lappend IndexItemLst $fld_lst
                    set fld_lst $id_str
                    lappend fld_lst $idx
                }
                set cur_fld [lindex $sr 1]
            }
        }
    }

    ##  add items not terminated.
    if {[llength $mmap_lst] == 2} {
        lappend mmap_lst "end"
        lappend IndexItemLst $mmap_lst
    }
    if {[llength $blk_lst] == 2} {
        lappend blk_lst "end"
        lappend IndexItemLst $blk_lst
    }
    if {[llength $mem_lst] == 2} {
        lappend mem_lst "end"
        lappend IndexItemLst $mem_lst
    }
    if {[llength $reg_lst] == 2} {
        lappend reg_lst "end"
        lappend IndexItemLst $reg_lst
    }
    if {[llength $fld_lst] == 2} {
        lappend fld_lst "end"
        lappend IndexItemLst $fld_lst
    }
    ## reopen tree veiw items that were open before redraw
    set iidx 0
    foreach i $ItemOpenLst {
        set exi [$mmap_tree_tr exists $i]
        if {$exi == 1} {
            $mmap_tree_tr item $i -open true
            incr iidx
        } else {
            set ItemOpenLst [lreplace $ItemOpenLst $iidx $iidx]
        }
    }
    create_mem_map
    #foreach i $IndexItemLst {
    #    puts $i
    #}
}
################################################
## set the main buttons based on passed value
##  input:  mode  {mmap blk mem reg fld save}
proc set_button_mode {mode} {
    global mbut_lst ButtonMode
    ## unpack buttons
    foreach b $mbut_lst {
        pack forget $b
    }
    if {$mode != "blk"} {
        set ButtonMode $mode
    }
    ## switch on mode
    #$mmap_buts_ed configure -state disabled
    switch $mode {
        "mmap" {
            pack [lindex $mbut_lst 11] -side left
            pack [lindex $mbut_lst 12] -side left
            pack [lindex $mbut_lst 0] -side left
            pack [lindex $mbut_lst 10] -side right
            #$mmap_buts_ed configure -state normal

        }
        "mem" {
            pack [lindex $mbut_lst 5] -side left
            #pack [lindex $mbut_lst 1] -side left
            pack [lindex $mbut_lst 10] -side right
        }
        "reg" {
            pack [lindex $mbut_lst 6] -side left
            #pack [lindex $mbut_lst 2] -side left
            pack [lindex $mbut_lst 3] -side left
            pack [lindex $mbut_lst 10] -side right
        }
        "fld" {
            pack [lindex $mbut_lst 7] -side left
            pack [lindex $mbut_lst 3] -side left
            pack [lindex $mbut_lst 10] -side right
        }
        "save" {
            pack [lindex $mbut_lst 8] -side left
            pack [lindex $mbut_lst 9] -side right
        }
        "blk" {
            return
        }
        "init" {
            pack [lindex $mbut_lst 11] -side left
#            pack [lindex $mbut_lst 12] -side left
#            pack [lindex $mbut_lst 10] -side right
        }
        default {
            puts "ERROR:  unknown mode passed to set_button_mode  $mode"
        }
    }
}
##  based on the TYPES defined in the above update_tree_view
##  pack the correct detail frame when tree items selected.
##  and update the fields from the selection.
proc gui_pack_detail_fr {} {
    global mmap_tree_tr mem_map_frame ButtonMode
    global mem_block_fr regd fldd mem_fr mbut_lst
    ## get all needed info about selected item.
    set sel [$mmap_tree_tr selection]
    set par [$mmap_tree_tr parent $sel]
    set it  [$mmap_tree_tr item $sel -values]
    ##  unpack frames by default
    pack forget $mem_block_fr $regd $fldd $mem_fr $mem_map_frame
    ##  unpack buttons
    foreach b $mbut_lst {
        pack forget $b
    }
    ## needed for very first mmap added.
    if {$it == ""} {
        set it "{Mem Map}"
    }
    #puts "gui_pack_detail_fr $it"
    ## based on the TYPE, pack the appropreate frame
    ##  and update the main button frame with correct actions.
    switch $it {
        "{Mem Map}" {
            pack $mem_map_frame -anchor w -fill x
            update_map_fields
            set_button_mode mmap
        }
        "Memory" {
            pack $mem_fr -anchor w -fill x
            update_memory_fields
            set_button_mode mem
        }
        "Register" {
            pack $regd -anchor w -fill both
            update_register_fields
            set_button_mode reg
        }
        "{Register Field}" {
            pack $fldd -anchor w -fill both
            update_reg_fields_fields
            set_button_mode fld
        }
        default {
            set ButtonMode "blk"
            ## the default block, which there are 4 types.
            pack $mem_block_fr -anchor w -fill x
            update_block_fields
            #$mmap_buts_ed configure -state disabled
            ##puts $it
            #pack [lindex $mbut_lst 0] -side left
            pack [lindex $mbut_lst 4] -side left
            if {$it == "\{Block REG\}"} {
                pack [lindex $mbut_lst 2] -side left
                tooltip::tooltip [lindex $mbut_lst 2] "Add Register\nControl-a"
                pack [lindex $mbut_lst 10] -side right
                set ButtonMode "blk_reg"
            } elseif {$it == "\{Block ROM\}"} {
                pack [lindex $mbut_lst 1] -side left
                tooltip::tooltip [lindex $mbut_lst 1] "Add Memory\nControl-a"
                pack [lindex $mbut_lst 10] -side right
            } elseif {$it == "\{Block RAM\}"} {
                pack [lindex $mbut_lst 1] -side left
                tooltip::tooltip [lindex $mbut_lst 1] "Add Memory\nControl-a"
                pack [lindex $mbut_lst 10] -side right
            } elseif {$it == "\{Block MIX\}"} {
                pack [lindex $mbut_lst 1] -side left
                tooltip::tooltip [lindex $mbut_lst 1] "Add Memory\nControl-m"
                pack [lindex $mbut_lst 2] -side left
                tooltip::tooltip [lindex $mbut_lst 2] "Add Register\nControl-r"
                pack [lindex $mbut_lst 10] -side right
                set ButtonMode "blk_mix"
            }
        }
    }
}

proc pack_detail_frame {typ} {
    global mem_block_fr regd fldd mem_fr mbut_lst mem_map_frame
    global ilb
    ##  unpack frames by default
    pack forget $mem_block_fr $regd $fldd $mem_fr $mem_map_frame
    ## based on the TYPE, pack the appropreate frame
    ##
    switch $typ {
        "mmap" {
            pack $mem_map_frame -anchor w -fill x
            #pack $ilb -anchor se
        }
        "mem" {
            pack $mem_fr -anchor w -fill x
        }
        "reg" {
            pack $regd -anchor w -fill both
        }
        "fld" {
            pack $fldd -anchor w -fill both
        }
        "blk" {
            pack $mem_block_fr -anchor w -fill x
        }
        default {
            puts "ERROR:  unknown type passed to pack_detail_frame"
        }
    }
}

############################################
##  proc to update the field text box list pointer
##   as well, because this was a register button
##   or mouse click,  update the register details.
proc update_fld_lst {idx} {
    global FldLst CurrFldLst fldlstb RegLst
    global reg_label regd fldd current_reg reg_name_en

    set reg_label "Register Details  $idx"
    set current_reg $idx
    ##  unpack any previous detail frames.
    pack forget $regd
    pack forget $fldd
    ##  pack in register details frame
    pack $regd -fill both -expand 1
#   pack $regd
    $reg_name_en delete 0 end
    $reg_name_en insert 0 $current_reg
    ## find the index into register list
    set i [lsearch $RegLst $idx]
    ##  set the text list to coorisponding field list  list.
    set CurrFldLst [lindex $FldLst $i]
    #$ selection set 0 0

    #set lst [pack slaves $regd]
    #foreach l $lst {
    #   puts $l
    #}
}
#############################################
##  proc to update the details box when a field
##   is selected.
proc update_fld_detail {idx} {
    global field_label regd fldd current_reg

    #puts "$idx  selected."

    set field_label "Field: $idx     Register: $current_reg"
    ##  unpack any previous detail frames.
    pack forget $regd
    pack forget $fldd
    ##  pack in register details frame
    pack $fldd -fill both -expand 1
}

## update Register frame based on GUI selection of type.
proc update_regtype_gui {} {
    global curr_reg_type regd reg_idx_fr reg_acc_fr reg_con_fr
    global reg_idx_cb1 reg_idx_cb2 IndexFldLst FldLst
    global reg_full_fr

    #puts $curr_reg_type
    set wid_lst [pack slaves $regd]
    #foreach w $wid_lst {
    #   puts $w
    #}

    pack forget $reg_idx_fr
    pack forget $reg_con_fr
    if {$curr_reg_type == "reg"} {
        #puts "Regular Register selected."
    } elseif {$curr_reg_type == "idx"} {
        #puts "Indexed Register selected."
        pack $reg_idx_fr -after $reg_full_fr -anchor w -fill x
        $reg_idx_cb1 current 0
        set IndexFldLst [lindex $FldLst 0]
        $reg_idx_cb2 configure -values $IndexFldLst
        $reg_idx_cb2 current 0
    } elseif {$curr_reg_type == "alt"} {
        #puts "Alternate Register selected."
    } elseif {$curr_reg_type == "con"} {
        pack $reg_con_fr -after $reg_full_fr -anchor w -fill x
        #puts "Concat Register selected."
    }
}

## update the field frame based on the gui selection of type
proc update_flddtype_gui {} {
    global curr_fldd_type fldd_range_fr fldd_type_fr fldd_enum_fr

    pack forget $fldd_range_fr
    pack forget $fldd_enum_fr

    if {$curr_fldd_type == "ran"} {
        pack $fldd_range_fr -after $fldd_type_fr -anchor w -fill x

    } elseif {$curr_fldd_type == "enu"} {
        pack $fldd_enum_fr  -after $fldd_type_fr  -anchor w
    }
    #puts "Update Field type ...  $curr_fldd_type"
}

#############################################
#  memory Map Procs
proc add_memory_map {} {
    global mmap_name_en mmap_base_en mmap_size_cb mmap_widt_en
    global mmap_mwid_en mmap_reso_cb mmap_desc_txt
    global MemLst FullLst ItemLst mmap_tree_tr

    set rtn 0
    set name [$mmap_name_en get]
    if {$name == ""} {
        set reply [tk_dialog .dia "Entry Incomplete" \
        "A Name for the memory map must be supplied." "" 0 Ok]
        set rtn 1
        return $rtn
    }
    set id "."
    append id $name
    ## check for and get count of lines.
    set dlen [$mmap_desc_txt count -lines 0.0 end]
    ## check that the memory map does not exist
    set n_exist [find_index $id]
    #puts $n_exist
    if {$n_exist == ""} {
        set base [$mmap_base_en get]
        set size [$mmap_size_cb get]
        set size [mdepth_to_size $size]
        set width [$mmap_widt_en get]
        set min  [$mmap_mwid_en get]
        set reso [$mmap_reso_cb get]
        ##  check that all fields are filled out.
        if {$base == "" || $size == "" || $width == "" || $min == "" || $reso == ""} {
            set reply [tk_dialog .dia "Entry Incomplete" \
            "If a Memory Map is defined all fields must be completed." "" 0 Ok]
            set rtn 1
            return $rtn
        }
        lappend MemLst $name
        ## add to the full list
        lappend FullLst "1,$name,$base,$size"
        lappend FullLst "2,$width,$min,$reso"
        if {$dlen > 0} {
            set txt [$mmap_desc_txt get 0.0 end]
            set stxt [split $txt "\n"]
            for {set i 0} {$i < $dlen} {incr i} {
                if {[lindex $stxt $i] == "" && $i == [expr {$dlen - 1}]} {
                    break
                }
                lappend FullLst "14,[lindex $stxt $i]"
            }
        }

    } else {
        set reply [tk_dialog .dia "Duplicate Entry Attempted" \
        "Memory Map definitions must have a unique name." "" 0 Ok]
    }

    update_tree_view
    return $rtn
}
## gui_new_memory_map
proc gui_new_memory_map {} {
    global EditMode FieldEMode
    global  mmap_tree_tr

    $mmap_tree_tr configure -selectmode none
    gui_enable_fields mmap
    gui_clear_fields mmap
    set EditMode "New"
    set FieldEMode "New_MMap"
    #$mmap_buts_sv configure -state normal
    #$mmap_buts_ed configure -state disabled
    set_button_mode save
}
## gui_edit_memory_map
proc gui_edit_memory_map {} {
    global mmap_fld_lst EditMode
    global mmap_name_en MemLst FieldEMode
    global  mmap_tree_tr

    $mmap_tree_tr configure -selectmode none
    foreach f $mmap_fld_lst {
        $f configure -state normal
    }
    set name [$mmap_name_en get]
    set idx [lsearch $MemLst $name]
    set MemLst [lreplace $MemLst $idx $idx]
    set EditMode "Edit"
    set FieldEMode "Edit_MMap"
    set_button_mode save
}
## called from button press Save.
##   if EditMode is New, append a new Mmap
##   else edit the selected Mmap
proc gui_add_memory_map {} {
    global mmap_name_en mmap_base_en mmap_size_cb mmap_widt_en
    global mmap_mwid_en mmap_reso_cb mmap_desc_txt
    global mmap_fld_lst EditMode
    global mmap_tree_tr FullLst ItemLst MemLst FieldEMode CurrSelItem

    set rtn 0
    ## if this is new memory map, call add
    if {($FieldEMode == "New_MMap") || ($FullLst == {})} {
        add_memory_map
    ## else is an edit operation
    } else {
        ## replace item in full lst with new values
        ## get all needed info about selected item.
        set sel [$mmap_tree_tr selection]
        set idx_lst [get_index_detail]
        set start [lindex $idx_lst 1]
        set next [expr {$start + 1}]
        set iend 0
        set len [llength $FullLst]
        for {set i $next} {$i < $len} {incr i} {
            set r [lindex $FullLst $i]
            #puts $r
            set sr [split $r ","]
            set typ [lindex $sr 0]
            #puts $typ
            if {$typ == "1" || $typ == "3" || $typ == "6" || $typ == "10" || $typ == "11"} {
                break
            }
            set iend $i
        }

        set iend [expr {$iend - 1}]
        ################################################
        #puts "$idx_lst $iend"
        set name [$mmap_name_en get]
        #puts $name
        if {$name == ""} {
            set reply [tk_dialog .dia "Entry Incomplete" \
            "A Name for the memory map must be supplied." "" 0 Ok]
            set rtn 1
            return $rtn
        }
        ## check for and get count of lines.
        set dlen [$mmap_desc_txt count -lines 0.0 end]
        ## check that the memory map does not exist
        set id "."
        append id $name
        #puts "ID: $id   Sel:  $sel"
        set n_exist [find_index $id]
        if {$n_exist == "" || $sel == $id} {
            set base [$mmap_base_en get]
            set size [$mmap_size_cb get]
            set size [mdepth_to_size $size]
            set width [$mmap_widt_en get]
            set min  [$mmap_mwid_en get]
            set reso [$mmap_reso_cb get]
            ##  check that all fields are filled out.
            if {$base == "" || $size == "" || $width == "" || $min == "" || $reso == ""} {
                set reply [tk_dialog .dia "Entry Incomplete" \
                "If a Memory Map is defined all fields must be completed." "" 0 Ok]
            set rtn 1
            return $rtn
            }
            lappend MemLst $name
            ## update the current selected item
            set CurrSelItem "."
            append  CurrSelItem $name
            ## add to the full list
            set tlst {}
            lappend tlst "1,$name,$base,$size"
            lappend tlst "2,$width,$min,$reso"
            if {$dlen > 0} {
                set txt [$mmap_desc_txt get 0.0 end]
                set stxt [split $txt "\n"]
                for {set i 0} {$i < $dlen} {incr i} {
                    if {[lindex $stxt $i] == "" && $i == [expr {$dlen - 1}]} {
                        break
                    }
                    lappend tlst "14,[lindex $stxt $i]"
                }
            }
            # delete from list the item being replaced
            set FullLst [lreplace $FullLst $start $iend+1]
            #puts_FullLst
            ## insert the new records into the full list
            set idx $start
            foreach l $tlst {
                set FullLst [linsert $FullLst $idx $l]
                incr idx
            }
            ## step past current Mmap
            incr start
            ##  Update the parent field in the blocks below
            for {set idx $start} {$idx < $len} {incr idx} {
                set r [lindex $FullLst $idx]
                set sr [split $r ","]
                set rtyp [lindex $sr 0]
                #puts "rtype :  $rtyp"
                if {$rtyp == 1} {
                    break
                } elseif {$rtyp == 3} {
                    set tname "."
                    append tname $name
                    set sr [lreplace $sr end end $tname]
                    set tstr ""
                    set first 0
                    foreach i $sr {
                        if {$first == 1} {
                            append tstr ","
                        }
                        set first 1
                        append tstr $i
                    }
                    set FullLst [lreplace $FullLst $idx $idx $tstr]
                }
            }
        } else {
            set reply [tk_dialog .dia "Duplicate Entry Attempted" \
            "Memory Map definitions must have a unique name." "" 0 Ok]
        }
    }
    update_tree_view
    set EditMode ""

    set rtn 1
    return $rtn
#end of gui_add_memory_map
}
#############################################
##  block management procs
## edit block from gui
proc gui_edit_block {} {
    global blk_fld_lst FieldEMode mbut_lst  mmap_tree_tr mblk_name_en
    ## disable selection changes
    $mmap_tree_tr configure -selectmode none
    ## unpack buttons
    foreach b $mbut_lst {
        pack forget $b
    }
    ## enable changes
    foreach f $blk_fld_lst {
        $f configure -state normal
    }
    ## set edit type
    set FieldEMode "Block"
    set_button_mode save
    focus $mblk_name_en
}
##  add block from gui
proc gui_add_block {} {
    global mmap_tree_tr FieldEMode mblk_name_en

    ## disable selection changes
    $mmap_tree_tr configure -selectmode none
    ## put up a new clear block frame
    pack_detail_frame blk
    gui_enable_fields blk
    gui_clear_fields blk
    ##  set edit mode to Add_Block
    set FieldEMode "Add_Block"
    set_button_mode save
    focus $mblk_name_en
}
## save new block from gui
proc save_add_block {} {
    global MemLst mmap_tree_tr FullLst FieldEMode
    global mblk_name_en mblk_start_en mblk_depth_cb mblk_acc_cb
    global mblk_acc_cb mblk_typ_cb mblk_desc_txt MemBLst
    global curr_detail_frame mblkframe mem_block_fr msizes
    global  mmap_reso_cb mmap_widt_en

    set rtn 0
    set id [$mmap_tree_tr selection]
    ## get parent id and see if not top level.
    set par [$mmap_tree_tr parent $id]
    set spar [split $par "."]
    set slen [llength $spar]
    ##  nested blocks should never happen because of button
    ##    availability to the user.
    if {$slen > 1} {
        set reply [tk_dialog .dia "Nested Block Attempted" \
        "Block nesting is currently not supported." "" 0 Ok]
        set rtn 1
        return $rtn
    }
    ## get the type
    set it  [$mmap_tree_tr item $id -values]
    ## get the name from gui Check for duplicate name attempt
    set name [$mblk_name_en get]
    ##  part of hard coding to not have blocks in blocks
    ##   will have to be changed to have this feature.
    set bid $id
    append bid "." $name
    set n_exist [find_index $bid]
    if {$n_exist != ""} {
        set reply [tk_dialog .dia "Duplicate Block name Attempted" \
        "Block definitions must have a unique name." "" 0 Ok]
        set rtn 1
        return $rtn
    }
    set start [$mblk_start_en get]
    set depth [$mblk_depth_cb get]
    set depth [mdepth_to_size $depth]
    set reso  [$mmap_reso_cb get]
    set width [$mmap_widt_en get]
    set access [$mblk_acc_cb get]
    set btype [$mblk_typ_cb get]
    set desc [$mblk_desc_txt get 0.0 end]
    #############################################################################  Memory map check
    set mspec "blk"
    lappend mspec $id
    set stat [scan $start "%lx" saddr]
    set stat [scan $depth "%lx" ddepth]
    if {$reso == "Byte"} {
        set ddepth [expr {$ddepth - ($width / 8)}]
    } else {
        set ddepth [expr {$ddepth - 1}]
    }
    lappend mspec $saddr $ddepth
    ###############################################################################
    set idx [find_index $id]

    set ipoint [lindex $idx 2]

    set len [llength $FullLst]
    ##puts "Len:  $len  rtn idx:  $ipoint"
    set r "3,$name,$start,$depth,$access,$btype,$id"

    set dlen [$mblk_desc_txt count -lines 0.0 end]
    set sdesc [split $desc "\n"]
    for {set i 0} {$i < $dlen} {incr i} {
        if {[lindex $sdesc $i] == "" && $i == [expr {$dlen - 1}]} {
            break
        }
        lappend r "14,[lindex $sdesc $i]"
    }
    puts "Ipoint:  $ipoint   Len:  $len"
    set eidx [lindex $idx 1]
    if {$ipoint >= $len  || $ipoint == "end"} {
        foreach l $r {
            set FullLst [linsert $FullLst end $l]
        }
    } else {
        foreach l $r {
            set FullLst [linsert $FullLst $ipoint $l]
            incr ipoint
        }
    }
    ## update tree view
    update_tree_view
    set rtn [check_address $mspec]
    return $rtn
## end of gui_add_block
}
##  update the block with entry items.
proc edit_update_block {} {
    ## list of block info fields see XXXXXgui file
    global blk_fld_lst FieldEMode CurrSelItem mmap_reso_cb mmap_widt_en
    set rtn 0
    ## get details of selected item
    set idx_lst [get_index_detail]
    #puts $idx_lst
    set id [lindex $idx_lst 0]
    set start [lindex $idx_lst 1]
    set rend [lindex $idx_lst 3]
    set sid [split $id "."]
    set idlen [llength $sid]
    ## get info from fields
    set name [[lindex $blk_fld_lst 0] get]
    ##  name and test for existance.
    ## get parent
    set sid [split $id "."]
    set lst [string last "." $id]
    set par [string range $id 0 $lst]
    append par $name
    set ex [find_index $par]
    ## if we found some item with the same name and in add field mode
    if {($ex != {}) && ($id != $par)} {
        set reply [tk_dialog .dia "Duplicate Block name Attempted" \
        "Block definitions must have a unique name within a given Memory Map." "" 0 Ok]
        set rtn 1
        return $rtn
    }
    set  CurrSelItem $par
    set startaddr [[lindex $blk_fld_lst 1] get]
    set depth [[lindex $blk_fld_lst 2] get]
    set depth [mdepth_to_size $depth]
    set conv [scan [expr {$depth + $startaddr}] "%lx" ddepth]
    set reso  [$mmap_reso_cb get]
    set width [$mmap_widt_en get]
    ############################################################################<<<<<<<<<<<<<<  memory map check
    ##  check that the block address is ok
    set mspec "blk"
#    lappend mspec $id
    lappend mspec $par
    set stat [scan [[lindex $blk_fld_lst 1] get] "%lx" saddr]
    if {$reso == "Byte"} {
        set ddepth [expr {$ddepth - ($width / 8)}]
    } else {
        set ddepth [expr {$ddepth - 1}]
    }
    lappend mspec $saddr $ddepth
#    set rtn [check_address $mspec]
    #####
    set btype [[lindex $blk_fld_lst 3] get]
    set acces [[lindex $blk_fld_lst 5] get]
    set recs {}
    set trec "3,"
    append trec $name "," $startaddr "," $depth "," $acces "," $btype
    if {$idlen == 3} {
        append trec ",." [lindex $sid 1]
    }
    lappend recs $trec
    set desc [lindex $blk_fld_lst 4]
    #puts $desc
    set recs [append_desc_recs $recs $desc]
    ##puts "Block update\n $recs\nStart: $start\nEnd: $rend\n$recs"
    replace_records $start $rend $recs
    ## update the tree view
    update_tree_view
    set rtn [check_address $mspec]
    return $rtn
##  end of  edit_update_block
}

##########################################################
##  memory add and edit gui commands
proc gui_add_memory {} {
    global mmap_tree_tr FieldEMode mem_name_en

    ## disable selection changes
    $mmap_tree_tr configure -selectmode none
    ## put up a new clear block frame
    pack_detail_frame mem
    gui_enable_fields mem
    gui_clear_fields mem
    ##  set edit mode to Add_Memory
    set FieldEMode "Add_Memory"
    set_button_mode save
    focus $mem_name_en
}
proc save_add_memory {} {
    global mmap_tree_tr mem_fld_lst
    set rtn 0

    ## get details of selected item
    set idx_lst [get_index_detail]
    set len [llength $idx_lst]
    #puts $len
    if {$len != 1} {
        set id [lindex $idx_lst 0]
        set start [lindex $idx_lst 1]
        set lastr [lindex $idx_lst 2]
        set end [lindex $idx_lst 3]
        set sid [split $id "."]
        set idlen [llength $sid]
        set it  [$mmap_tree_tr item $id -values]
    } else {
        set id "."
        set start 0
        set lastr 0
    }
    set par $id
    ##  get the field values from gui
    set name [[lindex $mem_fld_lst 0] get]
    append par "." $name
    #puts $par
    set ex [find_index $par]
    if {$ex != {}} {
        set reply [tk_dialog .dia "Duplicate Memory name Attempted" \
        "Memory definitions must have a unique name within a given block." "" 0 Ok]
        set rtn 1
        return $rtn
    }
    set addr [[lindex $mem_fld_lst 1] get]
    set width [[lindex $mem_fld_lst 2] get]
    set depth [[lindex $mem_fld_lst 3] get]
    set depth [mdepth_to_size $depth]
    #####################################################################   memory map check
    set blkaddr [lindex [get_block_addr $id] 0]
    #puts $blkaddr
    set mspec "mem"
    lappend mspec $par
    set stat [scan $addr "%lx" saddr]
    set saddr [expr {wide($saddr + $blkaddr)}]
    set stat [scan $depth "%lx" ddepth]
    #puts "$saddr  $ddepth  $blkaddr"
    set ddepth [expr {wide($saddr + $ddepth)}]
    lappend mspec $saddr $ddepth
#    set rtn [check_address $mspec]
    ########################################################################
    set acc [[lindex $mem_fld_lst 4] get]
    set def [[lindex $mem_fld_lst 5] get]
    set desc [[lindex $mem_fld_lst 6] get 0.0 end]
    set dlen [[lindex $mem_fld_lst 6] count -lines 0.0 end]

    set r {}
    set tr "6,$name,$addr,$width,$depth,$acc,$def"
    lappend r $tr
    set sdesc [split $desc "\n"]
    for {set i 0} {$i < $dlen} {incr i} {
        if {[lindex $sdesc $i] == "" && $i == [expr {$dlen - 1}]} {
            break
        }
        lappend r "14,[lindex $sdesc $i]"
        #puts $t
    }
    #Sputs $r
    insert_records $r $lastr
    update_tree_view
    set rtn [check_address $mspec]
    return $rtn
    #gui_pack_detail_fr
}
proc gui_edit_memory {} {
    global mmap_tree_tr FieldEMode mem_name_en

    ## disable selection changes
    $mmap_tree_tr configure -selectmode none
    ## assume memory selected, as it should be.
    gui_enable_fields mem
    ##  set edit mode to Edit_Memory
    set FieldEMode "Edit_Memory"
    set_button_mode save
    focus $mem_name_en
}
proc edit_update_memory {} {
    global mmap_tree_tr mem_fld_lst CurrSelItem

    set rtn 0
    ## get details of selected item
    set idx_lst [get_index_detail]
    #puts $idx_lst
    set len [llength $idx_lst]
    #puts $len
    # assme memory still selected
    set id [lindex $idx_lst 0]
    set start [lindex $idx_lst 1]
    if {[lindex $idx_lst 2] != "end"} {
        set lastr [expr {[lindex $idx_lst 2] - 1}]
    } else {
        set lastr [lindex $idx_lst 2]
    }
    set end [lindex $idx_lst 3]
    set sid [split $id "."]
    set idlen [llength $sid]
    set it  [$mmap_tree_tr item $id -values]
    set lst [string last "." $id]
    set par [string range $id 0 $lst]
    ##  get the field values from gui
    ## check for duplicate names
    set name [[lindex $mem_fld_lst 0] get]
    append par $name
    #puts $par
    set ex [find_index $par]
    if {($ex != {}) && ($id != $par)} {
        set reply [tk_dialog .dia "Duplicate Memory name Attempted" \
        "Memory definitions must have a unique name within a given block." "" 0 Ok]
        set rtn 1
        return $rtn
    }
    set CurrSelItem $par
    set addr [[lindex $mem_fld_lst 1] get]
    #puts $addr
    set width [[lindex $mem_fld_lst 2] get]
    set depth [[lindex $mem_fld_lst 3] get]
    set depth [mdepth_to_size $depth]
    ## create memory id
    set b_id [lindex $sid 0]
    append b_id "." [lindex $sid 1] "." [lindex $sid 2]
    #####################################################################   memory map check
    set blkaddr [lindex [get_block_addr $b_id] 0]
    set mspec "mem"
    lappend mspec $par
    set stat [scan $addr "%lx" saddr]
    set reso [get_reso]
    set saddr [expr {wide($saddr + $blkaddr)}]
    set stat [scan $depth "%lx" ddepth]
    set ddepth [expr {wide(($saddr + $ddepth) - $reso)}]
    lappend mspec $saddr $ddepth
    #set rtn [check_address $mspec]
    ########################################################################
    set acc [[lindex $mem_fld_lst 4] get]
    set def [[lindex $mem_fld_lst 5] get]
    set desc [[lindex $mem_fld_lst 6] get 0.0 end]
    set dlen [[lindex $mem_fld_lst 6] count -lines 0.0 end]

    set r {}
    set tr "6,$name,$addr,$width,$depth,$acc,$def"
    lappend r $tr
    set sdesc [split $desc "\n"]
    for {set i 0} {$i < $dlen} {incr i} {
        if {[lindex $sdesc $i] == "" && $i == [expr {$dlen - 1}]} {
            break
        }
        lappend r "14,[lindex $sdesc $i]"
        #puts $t
    }
    #puts $r
    #puts "$start $lastr\n $r"
    #puts "Memory update\n $r\nStart: $start\nEnd: $lastr"
    replace_records $start $lastr $r
    update_tree_view
    set rtn [check_address $mspec]
    return $rtn
}
##########################################################
##  Register add and edit gui commands
proc gui_add_register {} {
    global mmap_tree_tr FieldEMode curr_reg_type reg_name_en

    ## disable selection changes
    $mmap_tree_tr configure -selectmode none
    ## put up a new clear block frame
    pack_detail_frame reg
    gui_enable_fields reg
    gui_clear_fields reg
    ##  set edit mode to Add_Memory
    set FieldEMode "Add_Register"
    set_button_mode save
    update_reg_canv "."
    focus $reg_name_en
}
proc save_add_register {} {
    global mmap_tree_tr reg_fld_lst curr_reg_type
    global mmap_reso_cb mmap_widt_en

    ##  create the resolution multiplyer.
    set width [$mmap_widt_en get]
    set reso [$mmap_reso_cb get]
    if {$reso == "Byte"} {
        set reg_offset [expr {$width / 8}]
    } else {
        set reg_offset 1
    }

    set rtn 0
    ## get details of selected item
    set idx_lst [get_index_detail]
    #puts $idx_lst
    set len [llength $idx_lst]
    #puts $len
    # assume block/register still selected
    set id [lindex $idx_lst 0]
    set start [lindex $idx_lst 1]
##    if {[lindex $idx_lst 2] != "end"} {
##        set lastr [expr {[lindex $idx_lst 2] - 1}]
    set lastr [lindex $idx_lst 2]
##    } else {
##        set lastr [lindex $idx_lst 2]
##    }
    set end [lindex $idx_lst 3]
    set sid [split $id "."]
    set lst [string last "." $id]
    set par [string range $id 0 $lst]
    ## get the values from the fields
    set name [[lindex $reg_fld_lst 0] get]
    ## check for duplicates
    append par $name
    set ex [find_index $par]
    if {$ex != {}} {
        set reply [tk_dialog .dia "Duplicate Register name Attempted" \
        "Register definitions must have a unique name within a given block." "" 0 Ok]
        set rtn 1
        return $rtn
    }
    #puts "Found:  $ex"
    set addr [[lindex $reg_fld_lst 1] get]
    ##################################################################
    #puts $sid
    set b_id $id
    #puts $sid
    append b_id "." $name
    set blkaddr [lindex [get_block_addr $id] 0]
    #puts $blkaddr
    set mspec "reg"
    lappend mspec $b_id
    set stat [scan $addr "%lx" raddr]
    set raddr [expr {wide($raddr * $reg_offset)}]
    set saddr [expr {wide($raddr + $blkaddr)}]
    lappend mspec $saddr
    #puts $mspec
    #set rtn [check_address $mspec]
    ##################################################################
    set acce [[lindex $reg_fld_lst 2] get]
    set rtyp $curr_reg_type
    set desc [lindex $reg_fld_lst 3]

    set r "10,$name,$addr,$acce"
    set r [append_desc_recs $r $desc]
    #puts "$r  $lastr"
    insert_records $r $lastr
    update_tree_view
    set rtn [check_address $mspec]
    return $rtn
}
proc gui_edit_register {} {
    global mmap_tree_tr FieldEMode curr_reg_type reg_name_en

    ## disable selection changes
    $mmap_tree_tr configure -selectmode none
    ## put up a new clear block frame
    pack_detail_frame reg
    gui_enable_fields reg
    #gui_clear_fields reg
    ##  set edit mode to Add_Memory
    set FieldEMode "Edit_Register"
    set_button_mode save
    focus $reg_name_en
}
proc edit_update_register {} {
    global reg_fld_lst curr_reg_type CurrSelItem
    global mmap_reso_cb mmap_widt_en

    ##  create the resolution multiplyer.
    set width [$mmap_widt_en get]
    set reso [$mmap_reso_cb get]
    if {$reso == "Byte"} {
        set reg_offset [expr {$width / 8}]
    } else {
        set reg_offset 1
    }

    set rtn 0
    ## get details of selected item
    set idx_lst [get_index_detail]
    #puts $idx_lst
    set len [llength $idx_lst]
    # assume block/register still selected
    set id [lindex $idx_lst 0]
    set start [lindex $idx_lst 1]
    if {[lindex $idx_lst 2] != "end"} {
        set lastr [expr {[lindex $idx_lst 2] - 1}]
    } else {
        set lastr [lindex $idx_lst 2]
    }
    set end [lindex $idx_lst 3]
    set sid [split $id "."]
    set lst [string last "." $id]
    set par [string range $id 0 $lst]
    ## get the values from the fields
    set name [[lindex $reg_fld_lst 0] get]
    #check for duplicate name.
    append par $name
    set ex [find_index $par]
    if {($ex != {}) && ($id != $par)} {
        set reply [tk_dialog .dia "Duplicate Register name Attempted" \
        "Register definitions must have a unique name within a given block." "" 0 Ok]
        set rtn 1
        return $rtn
    }
    set CurrSelItem $par
    set addr [[lindex $reg_fld_lst 1] get]
    ####################################################################
    #puts $sid
    set b_id "."
    append b_id [lindex $sid 1] "." [lindex $sid 2]
    set blkaddr [lindex [get_block_addr $b_id] 0]
    set mspec "reg"
    lappend mspec $par
    set stat [scan $addr "%lx" raddr]
    set raddr [expr {wide($raddr * $reg_offset)}]
    set saddr [expr {wide($raddr + $blkaddr)}]
    lappend mspec $saddr
    #puts $mspec
#    set rtn [check_address $mspec]
    ####################################################################
    set acce [[lindex $reg_fld_lst 2] get]
    set rtyp $curr_reg_type
    set desc [lindex $reg_fld_lst 3]

    set r "10,$name,$addr,$acce"
    set r [append_desc_recs $r $desc]
    #puts "Register Update\n$r  \nStart: $start \nEnd: $end"
    replace_records $start $end $r
    update_tree_view
    set rtn [check_address $mspec]
    return $rtn
}
##########################################################
##  Field add and edit gui commands
##   Input:  op   operation
##      Ad   add field
##      Ed   edit field
proc gui_add_field {op} {
    global mmap_tree_tr FieldEMode curr_reg_type fldd_name_en

    ## disable selection changes
    $mmap_tree_tr configure -selectmode none
    ## put up a new clear block frame
    pack_detail_frame fld
    gui_enable_fields fld
    if {$op == "Ad"} {
        gui_clear_fields fld
        ##  set edit mode to Add_Field
        set FieldEMode "Add_Field"
        focus $fldd_name_en
    } else {
        set FieldEMode "Edit_Field"
        focus $fldd_name_en
    }
    set_button_mode save
}
proc save_add_field {} {
    global fld_fld_lst curr_reg_type curr_fldd_type mmap_tree_tr
    global FieldEMode CurrSelItem FullLst
    set rtn 0
    ## get details of selected item
    set idx_lst [get_index_detail]
    #puts $idx_lst
    set len [llength $idx_lst]
    # assume register/field still selected
    set id [lindex $idx_lst 0]
    set start [lindex $idx_lst 1]
    if {[lindex $idx_lst 2] != "end"} {
        set lastr [expr {[lindex $idx_lst 2] - 1}]
    } else {
        set lastr [lindex $idx_lst 2]
    }
    set end [lindex $idx_lst 3]
    ## get the values from the fields
    ## get parent
    set sid [split $id "."]
    set lst [string last "." $id]
    set par [string range $id 0 $lst-1]
    ##  name and test for existance.
    set name [[lindex $fld_fld_lst 0] get]
    ##  depending on edit mode,  create new_id
    if {$FieldEMode == "Add_Field"} {
        set new_id $id
        append new_id "." $name
    } else {
	    set new_id $par
	    append new_id "." $name
    }
    #append par $name
    #puts "$id\n$par"
    set ex [find_index $new_id]
    ## if we found some item with the same name and in add field mode
    if {($ex != {}) && ($FieldEMode == "Add_Field")} {
        set reply [tk_dialog .dia "Duplicate Register Field name Attempted" \
        "Register Field definitions must have a unique name within a given Register." "" 0 Ok]
        set rtn 1
        return $rtn
    ## else if editing and name already exists, return
    } elseif {($ex != {}) && ($new_id != $id)} {
        set reply [tk_dialog .dia "Duplicate Register Field name Attempted" \
        "Register Field definitions must have a unique name within a given Register." "" 0 Ok]
        set rtn 1
        return $rtn
    }
    set fidx [[lindex $fld_fld_lst 1] get]
    set fsize [[lindex $fld_fld_lst 2] get]
    ## check the start and end that it is in bounds
    set map_id ".[lindex $sid 1]"
    set mmap_idx [find_index $map_id]
    #puts "$map_id   $mmap_idx"
    set flstidx [lindex $mmap_idx 1]
    incr flstidx
    set r [lindex $FullLst $flstidx]
    set sr [split $r ","]
    set width [lindex $sr 1]
    #puts "Width:  $width  "
    set flidx [expr {$fsize + $fidx - 1}]
    if {$flidx >= $width || $fidx >= $width} {
        set reply [tk_dialog .dia "Out of bounds Field add or edit" \
        "Field index and size must be with in the Memory map data width." "" 0 Ok]
        set rtn 1
        return $rtn
    }
    ##############################################################################################
    ##  Address checking   field bits.
    set mspec "reg"
    ## is a register or field  selected?
    if {[llength $sid] <= 4} {
        lappend mspec $id
    } else {
        set b_id "."
        append b_id [lindex $sid 1] "." [lindex $sid 2] "." [lindex $sid 3]
        lappend mspec $b_id
    }
    #  Not checking reg address,  set to 0
    lappend mspec "00000000"
    set bit_lst $fidx
    set nexti [expr {$fidx + 1}]
    set iend [expr {$fidx + $fsize}]
    for {set i $nexti} {$i < $iend} {incr i} {
        lappend bit_lst $i
    }
    lappend mspec $name
    lappend mspec $bit_lst
    #puts $mspec
    ##############################################################################################
    set facce [[lindex $fld_fld_lst 3] get]
    set frstv [[lindex $fld_fld_lst 4] get]
    set r "11,$name,$fidx,$fsize,$facce,$frstv,$curr_fldd_type"
    switch $curr_fldd_type {
        "ran" {
            set fmin [[lindex $fld_fld_lst 11] get]
            set fmax [[lindex $fld_fld_lst 12] get]
            lappend r "12,$fmin,$fmax"
        }
        "enu" {
            set enum_en [lindex $fld_fld_lst 13]
            set txt [$enum_en get 0.0 end]
            set dlen [$enum_en count -lines 0.0 end]
            set sdesc [split $txt "\n"]
            for {set i 0} {$i < $dlen} {incr i} {
                if {[lindex $sdesc $i] == "" && $i == [expr {$dlen - 1}]} {
                    break
                }
                lappend r "13,[lindex $sdesc $i]"
            }
        }
        "res" {
            if {$FieldEMode != "Edit_Field"} {
                set sid [split $id "."]
                set idlen [llength $sid]
                set it  [$mmap_tree_tr item $id -values]
                set eidx [expr {$fidx + ($fsize - 1)}]
                set name [lindex $sid 3]
                if {$eidx != $fidx} {
                    append name "_RESERV_$eidx"
                    append name "_" $fidx
                } else {
                    append name "_RESERV_$fidx"
                }
            }
            set r "11,$name,$fidx,$fsize,RO,$frstv,$curr_fldd_type"
        }
    }
    set facce $curr_reg_type
    set desc [lindex $fld_fld_lst 10]

    set r [append_desc_recs $r $desc]
    if {$FieldEMode == "Add_Field"} {
        if {$lastr != "end"} {
            incr lastr
        }
        insert_records $r $lastr
        set CurrSelItem $id
    } else {
        replace_records $start $end $r
        set CurrSelItem $par
    }

    update_tree_view
    create_register_map $mspec
    set rtn [check_address $mspec]

    return $rtn
}
##############################################################
##  GUI  save command
proc gui_save {} {
    global blk_fld_lst FieldEMode mbut_lst mmap_tree_tr
    global CurrSelItem

    set rtn 0
    ## get currently selected item
    if {$CurrSelItem == ""} {
        set CurrSelItem [$mmap_tree_tr selection]
    }
    ## re-enable the tree for browsing
    $mmap_tree_tr configure -selectmode browse

    ## disable changes
    foreach f $blk_fld_lst {
        $f configure -state disable
    }

    switch $FieldEMode {
        "Block" {set rtn [edit_update_block]}
        "Add_Block" {set rtn [save_add_block]}
        "Add_Register" {set rtn [save_add_register]}
        "Add_Field" {set rtn [save_add_field]}
        "Add_Memory" {set rtn [save_add_memory]}
        "New_MMap" {set rtn [gui_add_memory_map]}
        "Edit_Memory" {set rtn [edit_update_memory]}
        "Edit_Register" {set rtn [edit_update_register]}
        "Edit_Field" {set rtn [save_add_field]}
        "Edit_MMap" {set rtn [gui_add_memory_map]}
        default {puts "ERROR:  gui_save got unknown type $FieldEMode"}
    }
    #puts "$FieldEMode had return of: $rtn"
    if {$rtn == 0} {
        foreach b $mbut_lst {
            pack forget $b
        }
        set $FieldEMode ""
        #gui_pack_detail_fr
        gui_title_update 1
    }
    #if {[$mmap_tree_tr exists $CurrSelItem] == 1} {
    $mmap_tree_tr selection set $CurrSelItem
    $mmap_tree_tr focus $CurrSelItem
    focus $mmap_tree_tr
    #}
    set CurrSelItem ""
# end of gui_save
}
##  GUI  cancel command
proc gui_cancel {} {
    global FieldEMode mbut_lst mmap_tree_tr
    global FullLst CurrSelItem

    if {$FullLst == {}} {
        set_button_mode init
        return
    }

    $mmap_tree_tr configure -selectmode browse
    set CurrSelItem [$mmap_tree_tr selection]
    ##  set up focus
    #puts $CurrSelItem
    #$mmap_tree_tr selection set $CurrSelItem
    $mmap_tree_tr focus $CurrSelItem
    focus $mmap_tree_tr
    $mmap_tree_tr focus $CurrSelItem

    set $FieldEMode ""
    gui_pack_detail_fr
    set CurrSelItem ""
# end of gui_cancel
}

################################################
##  gui  delete id
proc gui_delete {} {
    global FullLst mmap_tree_tr EntErrorLst MemLst
    global version
    ## get details of selected item
    set idx_lst [get_index_detail]
    set id [lindex $idx_lst 0]
    ## get the item above this one for reselection
    set previous [$mmap_tree_tr prev [lindex $idx_lst 0]]
    if {$previous == {}} {
        set previous [$mmap_tree_tr parent [lindex $idx_lst 0]]
    }
    #puts $previous
    #puts $idx_lst
    if {[lindex $idx_lst 2] == "end"} {
        set FullLst [lreplace $FullLst [lindex $idx_lst 1] end]
    } else {
        set last [expr {[lindex $idx_lst 2] - 1}]
        set FullLst [lreplace $FullLst [lindex $idx_lst 1] $last]
    }
    update_tree_view
    if {$previous != ""} {
        $mmap_tree_tr selection set $previous
    }
    gui_title_update 1
    ##  if full list is now empty  init  mode
    if {$FullLst == {}} {
        set_button_mode init
        pack_detail_frame mmap
        gui_enable_fields mmap
        gui_clear_fields mmap
        update_mmap_canv
        set MemLst {}
    }
    ##  Check entity error list
    if {$EntErrorLst != {}} {
        set idx 0
        foreach ee $EntErrorLst {
            set eid [lindex $ee 0]
            if {$eid == $id} {
                set EntErrorLst [lreplace $EntErrorLst $idx $idx]
                break
            }
            incr idx
        }
    }
}

#########################################################
##  proc to update  the title line of GUI
##     stat  0 = not Mod,   1 =  Mod
proc gui_title_update {stat} {
    global version  FileName FileMod

    if {$stat == 1} {
        wm title . "Register Work Bench $version   -->> $FileName   **"
        set FileMod 1
    } else {
        wm title . "Register Work Bench $version   -->> $FileName"
        set FileMod 0
    }
}

############################################
##  group of text wid activated by a check button
##   memory map
proc gui_show_mmap_desc {} {
    global mmap_desc_txt mmap_desc_ckb mmem_desc_en
    global pwmm

    if {$mmem_desc_en == 0} {
        pack forget $mmap_desc_txt
        #$pwmm sash place 0 4 100
    } else {
        pack $mmap_desc_txt -side left -fill both
        #$pwmm sash place 0 4 180
    }
}
##   block description
proc gui_show_mblk_desc {} {
    global mblk_desc_txt mblk_desc_ckb block_desc_en

    if {$block_desc_en == 0} {
        pack forget $mblk_desc_txt
    } else {
        pack $mblk_desc_txt -side left -fill both
    }
}
##  memory description
proc gui_show_mem_desc {} {
    global mem_desc_txt mem_desc_ckb memory_desc_en

    if {$memory_desc_en == 0} {
        pack forget $mem_desc_txt
    } else {
        pack $mem_desc_txt -anchor w -fill both
    }
}

##  register description
proc gui_show_reg_desc {} {
    global reg_desc_tb reg_desc_en

    if {$reg_desc_en == 0} {
        pack forget $reg_desc_tb
    } else {
        pack $reg_desc_tb -side left -fill both
    }
}
##  field description
proc gui_show_fldd_desc {} {
    global fldd_desc_tb fldd_desc_en

    if {$fldd_desc_en == 0} {
        pack forget $fldd_desc_tb
    } else {
        pack $fldd_desc_tb -side left -fill both
    }
}
###########################################################
##  configuration Tab  procs
proc gui_set_file {} {
    global file_load_en FileName FileMod
    ## get file name from user

    set file_name [tk_getOpenFile]
    ## update file name entry
    $file_load_en delete 0 end
    $file_load_en insert end $file_name
    set FileName $file_name
}
proc gui_load_file {} {
    global FullLst file_load_en mmap_tree_tr
    global version prgbar helpVar FileName FileMod

    ##   if file loaded and modified ...
    if {$FileMod == 1} {
        set reply [tk_dialog .dia "Full List Empty" \
            "The current data base has been modified.\
            Do you wish to save the changes?" "" 0 Yes No Cancel]
        #puts "Loading File !!!   $reply"
        if {$reply == 0} {
            save_file $FileName
        } elseif {$reply == 2} {
            return
        }
    }

    ## reset the full list list
    set FullLst {}
    ## get file name from user entry
    #set file_name [$file_load_en get]
    #if {$file_name == ""} {
        set file_name [tk_getOpenFile]
        $file_load_en delete 0 end
        $file_load_en insert end $file_name
        #puts "gui_load_file  loading file ..."
    #}
    set helpVar "Loading File:  $file_name ..."
    update
    ## load the file
    if {$file_name != ""} {
        load_file $file_name
        update_tree_view
        $mmap_tree_tr configure -selectmode browse
        ##  identify and select the top item
        set is [$mmap_tree_tr identify row 25 30]
        #puts $is
        $mmap_tree_tr selection set $is
        $mmap_tree_tr focus $is
        focus $mmap_tree_tr
        set FileName $file_name
        gui_title_update 0
    }
    set helpVar "File Load Complete"
}
proc gui_set_sfile {} {
    global file_save_en
    ## get file name from user
    set file_name [tk_getSaveFile]
    ## update file name entry
    $file_save_en delete 0 end
    $file_save_en insert end $file_name
}
proc gui_save_file {} {
    global FullLst file_save_en

    ## get file name from user entry
    set file_name [$file_save_en get]
    if {$file_name == ""} {
        gui_set_sfile
        set file_name [$file_save_en get]
    }
    ## save the file
    if {$file_name != ""} {
        save_file $file_name
        gui_title_update 0
    }
}
proc gui_close {} {
    global FullLst
    global mmap_tree_tr mem_map_frame ButtonMode
    global mem_block_fr regd fldd mem_fr mbut_lst
    ##  unpack frames by default
    pack forget $mem_block_fr $regd $fldd $mem_fr $mem_map_frame
    ##  unpack buttons
    foreach b $mbut_lst {
        pack forget $b
    }
    set FullLst {}
    pack $mem_map_frame -anchor w -fill x
    #update_map_fields
    set_button_mode init
    gui_enable_fields mmap
    gui_clear_fields mmap
    update_tree_view
    gui_disable_fields mmap
}
proc gui_show_about {} {
    global version
    set reply [tk_dialog .dia "About Register Work Bench"\
            "The Register Work Bench $version.\n\
            By XtremeEDA  :  Ken Campbell"\
            "" 0 Ok]}
#####################################################################
##  HTML generation GUI  interface
proc gui_gen_html {} {
    global html_save_en FullLst
    global mmap_name_en
    ##  check to see if there is a data base loaded.
    if {$FullLst == {}} {
        set reply [tk_dialog .dia "Full List Empty" \
            "The data base is empty, load a regx file ..." "" 0 Ok]
        return
    }
    ##  if there is no name in the entry, make one and continue
    set fname [$html_save_en get]
    if {$fname == ""} {
        #set fn [$mmap_name_en get]
        set fn "html_doc"
        $html_save_en delete 0 end
        $html_save_en insert end $fn
    } else {
        set fn $fname
    }
    gen_html $fn
}

proc gui_set_hfile {} {
    global html_save_en
    #set file_name [tk_getOpenFile]
    set file_name [tk_chooseDirectory]
    ## update file name entry
    if {$file_name != ""} {
        $html_save_en delete 0 end
        $html_save_en insert end $file_name
    }
}

proc gset_file {ent} {
    set file_name [tk_getOpenFile]
    $ent delete 0 end
    $ent insert end $file_name
}
#########################################################
##  C Header file generation GUI interface
proc gui_gen_ifile {} {
    global cgen_save_en FullLst
    global mmap_name_en RegFMaskPre RegFMaskSuf
    global inc_en_lst RegAddrPre RegAddrSuf RegMaskPre RegMaskSuf
    ##  check to see if there is a data base loaded.
    if {$FullLst == {}} {
        set reply [tk_dialog .dia "Full List Empty" \
            "The data base is empty, load a regx file ..." "" 0 Ok]
        return
    }
    ##  if there is no name in the entry, make one and continue
    set fname [$cgen_save_en get]
    if {$fname == ""} {
        set fn [$mmap_name_en get]
        append fn "_include.h"
        $cgen_save_en delete 0 end
        $cgen_save_en insert end $fn
    } else {
        set fn $fname
    }
    ## get prefix suffix data
    set RegAddrPre [[lindex $inc_en_lst 0] get]
    set RegAddrSuf [[lindex $inc_en_lst 1] get]
    set RegMaskPre [[lindex $inc_en_lst 2] get]
    set RegMaskSuf [[lindex $inc_en_lst 3] get]
    set RegFMaskPre [[lindex $inc_en_lst 4] get]
    set RegFMaskSuf [[lindex $inc_en_lst 5] get]
    #puts "$RegAddrPre $RegAddrSuf $RegMaskPre $RegMaskSuf $RegFMaskPre $RegFMaskSuf"
    gen_cinclude $fn
}

proc gui_set_ifile {} {
    global cgen_save_en
    set file_name [tk_getOpenFile]
    ## update file name entry
    $cgen_save_en delete 0 end
    $cgen_save_en insert end $file_name
}
#############################################################
##  Update or create  gui_ini.tcl file
##     update or create the gui_ini.tcl file with new user
##     values.  Input,  variable name and new value.
proc gui_ini_update {var value} {

    set has_ini [file exists "gui_ini.tcl"]
    ##  if file exists,  update
    if {$has_ini == 1} {
        ##load file to memory
        set fh [open "gui_ini.tcl" r]
        set flst {}
        set nlst {}
        while {![eof $fh]} {
            lappend flst [gets $fh]
        }
        close $fh
        ## check for global variable
        set gfound 0
        foreach l $flst {
            set isg [string first "global $var" $l]
            if {$isg >= 0} {
                set gfound 1
            }
        }
        ## if global exists, just update the set statement.
        set sfound 0
        if {$gfound == 1} {
            foreach l $flst {
                set isset [string first "set $var" $l]
                if {$isset >= 0} {
                    set sfound 1
                    set tmp "    set $var \{$value\}"
                    lappend nlst $tmp
                } else {
                    lappend nlst $l
                }
            }
            ##  If there was no set statement,  why was there a global
            ##   this is an issue that may have to be addressed ... later
        ##  no global found, add both to file.
        } else {
            foreach l $flst {
                set isproc [string first "proc gui_ini" $l]
                if {$isproc >= 0} {
                    lappend nlst $l
                    set tmp "    global $var"
                    lappend nlst $tmp
                    set tmp "    set $var \{$value\}"
                    lappend nlst $tmp
                } else {
                    lappend nlst $l
                }
            }
        }
        set fh [open "gui_ini.tcl" w]
        foreach l $nlst {
            puts $fh $l
        }
        close $fh
    ## if not exist  create and update.
    } else {
        set fh [open "gui_ini.tcl" w]
        puts $fh "proc gui_ini_update \{var value\} \{"
        puts $fh "    global $var"
        puts $fh "    set $var \{$value\}"
        puts $fh "\}"
        close $fh
    }
}

###########################################################################
##  Message, continue
proc dbg_msg { msg } {
  tk_messageBox -message $msg -type ok
}

#########################################################
##  dev functions
proc gui_source_comm {} {
    source "src/reg_common.tcl"
    source "src/reg_workbench.tcl"
    source "src/reg_graphics.tcl"
    #source "reg_events.tcl"
}

proc gui_source_test {} {
    global mmap_tree_tr ItemLst MemLst helpVar
    global msizes

    source "reg_vhdl.tcl"
}