#! /usr/bin/env wish
############################################################################
##
## Copyright 2014  Ken Campbell
##
##   Licensed under the Apache License, Version 2.0 (the "License");
##   you may not use this file except in compliance with the License.
##   You may obtain a copy of the License at
##
##     http://www.apache.org/licenses/LICENSE-2.0
##
##   Unless required by applicable law or agreed to in writing, software
##   distributed under the License is distributed on an "AS IS" BASIS,
##   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
##   See the License for the specific language governing permissions and
##   limitations under the License.
##
#####################################
##
##   Description :
##        This is the top file of the Register Workbench application.
##        This applicattion implements the Register Workbench
##           It enables the user to define a register/memory map for
##           a device.  This is stored in a application specific format.
##        Many output can be generated from the data base.
##
##########################################
#  Packages
package require Ttk
package require Tk
package require cksum 1.1.3
package require crc32 1.3
package require tooltip
##package require Iwidgets 4.0

set version "VHDL 0.12"
wm title . "Register Work Bench $version"

##  put all the variables in one file.
source src/reg_vars.tcl
# This is the menu
set mb [menu .mb1 -type menubar -tearoff 0]
. configure -menu $mb

# This is the message and command line frame
set c [ttk::frame .f1 -borderwidth 4 -relief sunken]
set cmd_ent [entry $c.cmd1]
pack $cmd_ent -side bottom -anchor s -expand 1 -fill x -padx 2
set hlp_lb [label $c.hlb -textvariable helpVar -justify left]
set prgbar [ttk::progressbar $c.pb -length 100]
pack $hlp_lb -side left -fill x -padx 4
pack $prgbar -side right
pack .f1 -side bottom -anchor s -fill x

# This is the notebook frame.
ttk::frame .f2
pack .f2 -side bottom -fill both -expand 1
set w .f2
## Make the notebook and set up Ctrl+Tab traversal
set nb [ttk::notebook $w.note]
pack $nb -fill both -expand 1 -padx 2 -pady 3
ttk::notebook::enableTraversal $nb

##  frame for the paned window for memory maps.
set pwmframe [frame $nb.pwmf1 -borderwidth 4 -relief raised]
# create vertical paned window
set pwmm [panedwindow $pwmframe.pwmm -borderwidth 4 -relief sunken -sashrelief raised \
                    -sashwidth 4 -orient vertical]
## add the top and bottom frames
#set topframe [frame $pwmm.top]
set botframe [frame $pwmm.bot]
#$pwmm add $topframe $botframe
#$pwmm paneconfigure $topframe -minsize 50
$pwmm paneconfigure $botframe -minsize 50
## add horizontal panedwindow to bottom section
set pwm [panedwindow $botframe.pwm -borderwidth 4 -relief sunken -sashrelief raised \
                    -sashwidth 4]

# frames for each section left and right
set mmapframe [frame $pwm.mmap]
set mblkframe [frame $pwm.mblk]
$pwm add $mmapframe
$pwm paneconfigure $mmapframe -minsize 50
$pwm paneconfigure $mblkframe -minsize 50
pack $pwm -fill x
pack $pwmm -fill both


##  memory Map  tab
$nb add $pwmframe -text  "Memory Map" -underline 0

##  memory tree frame
set mmap_tree_fr [frame $mmapframe.tfr  -borderwidth 4 -relief sunken]
set mmap_tree_tr [ttk::treeview $mmap_tree_fr.tr1 -height 30 -columns { TYPE } -displaycolumns { TYPE } \
    -selectmode browse]
pack $mmap_tree_tr -side left -fill x
pack $mmap_tree_fr -anchor w -fill both

$mmap_tree_tr heading \#0 -text "Memory Map Tree"
$mmap_tree_tr heading \#1 -text "Type"

##################################
##  button frame
set mbut_fr [frame $mblkframe.btfr1  -borderwidth 4 -relief sunken]
set mbut_ab [button $mbut_fr.bt1 -text "Add Block" -command gui_add_block]
set mbut_am [button $mbut_fr.bt2 -text "Add Memory" -command gui_add_memory]
set mbut_ar [button $mbut_fr.bt3 -text "Add Register" -command gui_add_register]
set mbut_af [button $mbut_fr.bt4 -text "Add Field" -command {gui_add_field "Ad"}]
set mbut_eb [button $mbut_fr.bt5 -text "Edit Block" -command gui_edit_block]
set mbut_em [button $mbut_fr.bt6 -text "Edit Memory" -command gui_edit_memory]
set mbut_er [button $mbut_fr.bt7 -text "Edit Register" -command gui_edit_register]
set mbut_ef [button $mbut_fr.bt8 -text "Edit Field" -command {gui_add_field "Ed"}]
set mbut_sv [button $mbut_fr.bt9 -text "Save" -command {gui_save}]
set mbut_ca [button $mbut_fr.bt10 -text "Cancel" -command {gui_cancel}]
set mbut_del [button $mbut_fr.bt11 -text "Delete" -command {gui_delete}]
set mbut_mma [button $mbut_fr.bt12 -text "Add Memory Map" -command gui_new_memory_map]
set mbut_mme [button $mbut_fr.bt13 -text "Edit Memory Map" -command gui_edit_memory_map]

set mbut_lst {}
lappend mbut_lst $mbut_ab $mbut_am $mbut_ar $mbut_af $mbut_eb \
$mbut_em $mbut_er $mbut_ef $mbut_sv $mbut_ca $mbut_del $mbut_mma $mbut_mme
pack $mbut_fr -anchor n -fill x -pady 10
##  static tool tips
tooltip::tooltip $mbut_ab "Add Block\nControl-a"
tooltip::tooltip $mbut_am "Add Memory\nControl-a"
tooltip::tooltip $mbut_ar "Add Register\nControl-a"
tooltip::tooltip $mbut_af "Add Field\nControl-a"
tooltip::tooltip $mbut_eb "Edit Block\nControl-e"
tooltip::tooltip $mbut_em "Edit Memory\nControl-e"
tooltip::tooltip $mbut_er "Edit Register\nControl-e"
tooltip::tooltip $mbut_ef "Edit field\nControl-e"
tooltip::tooltip $mbut_sv "Save Edits or Addistions\nControl-s"
tooltip::tooltip $mbut_ca "Cancel Edits\nControl-c"
tooltip::tooltip $mbut_del "Delete Item\nControl-d"
tooltip::tooltip $mbut_mme "Edit Memory Map\nControl-e"
## some dynamic tool tips are in reg_common.tcl  <<<===  Still same name?

##################################################################3
##  memory map frame and contents.
set mem_map_frame [frame $mblkframe.mmf1 -borderwidth 4 -relief sunken]
##  memory map fields
#  Name frame
set mmap_name_fr [frame $mem_map_frame.nfr -borderwidth 4 -relief sunken]
set mmap_name_lb [label $mmap_name_fr.lb -text "Memory Map Name: "]
set mmap_name_en [entry $mmap_name_fr.en1 -width 35 -validate key -vcmd {val_name %W %P}]
pack $mmap_name_lb -side left
pack $mmap_name_en -side left
pack $mmap_name_fr -anchor w
##  development frame, with dev buttons
#set dev_buts_fr [frame $topframe.dvfr  -borderwidth 4 -relief sunken]
set dev_buts_bt1 [button $mmap_name_fr.bt1  -text "Source common" -command "gui_source_comm"]
set dev_buts_bt2 [button $mmap_name_fr.bt2  -text "Test" -command "gui_source_test"]
pack $dev_buts_bt1 $dev_buts_bt2 -side left -padx 10
#main wid frame
set ttopframe [frame $mem_map_frame.ttfr]
#  Base address frame
set mmap_base_fr [frame $ttopframe.bfr  -borderwidth 4 -relief sunken]
set mmap_base_lb [label $mmap_base_fr.lb1 -text "Base Address: "]
set mmap_base_en [entry $mmap_base_fr.en1 -width 12 -validate key -vcmd {val_hex %W %P}]
pack $mmap_base_lb -side left
pack $mmap_base_en -side left
#  Size  frame
set mmap_size_fr [frame $ttopframe.sfr -borderwidth 4 -relief sunken]
set mmap_size_lb [label $mmap_size_fr.lb1 -text "Memory Size: "]
set mmap_size_cb [ttk::combobox $mmap_size_fr.cb1 -values $msizes -state readonly -width 5]
pack $mmap_size_lb -side left
pack $mmap_size_cb -side left
#  Width  frame
set mmap_widt_fr [frame $ttopframe.wfr -borderwidth 4 -relief sunken]
set mmap_widt_lb [label $mmap_widt_fr.lb1 -text "Data Width: "]
set mmap_widt_en [entry $mmap_widt_fr.en1 -width 5 -validate key -vcmd {val_dec %W %P}]
pack $mmap_widt_lb $mmap_widt_en -side left
#  Min Width frame
set mmap_mwid_fr [frame $ttopframe.nwfr -borderwidth 4 -relief sunken]
set mmap_mwid_lb [label $mmap_mwid_fr.lb1 -text "Min Access Width: "]
set mmap_mwid_en [entry $mmap_mwid_fr.en -width 4 -validate key -vcmd {val_dec %W %P}]
pack $mmap_mwid_lb $mmap_mwid_en -side left
# resolotion frame
set mmap_reso_fr [frame $ttopframe.refr -borderwidth 4 -relief sunken]
set mmap_reso_lb [label $mmap_reso_fr.lb1 -text "Resolution: "]
set mmap_reso_cb [ttk::combobox $mmap_reso_fr.cb1 -values { Byte Word } -state readonly -width 6]
pack $mmap_reso_lb $mmap_reso_cb -side left
pack $mmap_base_fr $mmap_size_fr $mmap_widt_fr $mmap_mwid_fr $mmap_reso_fr -anchor nw -side left
pack $ttopframe -anchor w
# Description Frame  displays only when check button checked.
set mmap_desc_fr [frame $mem_map_frame.defr -borderwidth 4 -relief sunken]
set mmap_desc_ckb [checkbutton $mmap_desc_fr.enbut -text "Description" -command gui_show_mmap_desc \
                   -variable mmem_desc_en]
set mmap_desc_txt [text $mmap_desc_fr.txt -height 6]
pack $mmap_desc_ckb -side left
pack $mmap_desc_fr -anchor nw
## create list of mmap entry items.
set mmap_fld_lst {}
lappend mmap_fld_lst $mmap_name_en $mmap_base_en $mmap_widt_en $mmap_mwid_en $mmap_size_cb \
    $mmap_reso_cb $mmap_desc_txt

################################
##  Canvas for pic of memory map
set mscrollr {0c 0c 0c 100c}
set mmap_canv_fr [frame $mem_map_frame.cav1 -borderwidth 4 -relief sunken]
set mmap_vsb [scrollbar $mem_map_frame.vsb -orient vertical -command {$mmap_canv_fr.canv yview}]
set mmap_cav [canvas $mmap_canv_fr.canv -bg white -width 650 -scrollregion $mscrollr \
              -yscrollincrement 8 -yscrollcommand {$mem_map_frame.vsb set}]
pack $mmap_cav -side left
pack $mmap_vsb -side right -fill y
pack $mmap_canv_fr -anchor w -fill x

##  logo   XEDA
image create photo ilogo
ilogo configure -file "logo.gif"
set ilb [label $mem_map_frame.ilb1 -image ilogo]
##set ilb [label $mblkframe.ilb1 -image ilogo]
pack $ilb -anchor se


##################################################################################
##  the block frame and contents.
set mem_block_fr [frame $mblkframe.mbfr]
##  button frame
set mblk_but_fr [frame $mem_block_fr.bfr -borderwidth 4 -relief sunken]
set mblk_but_lb [label $mblk_but_fr.lb1 -text "Block Spec"]
pack $mblk_but_lb -side left -fill x
pack $mblk_but_fr -anchor w -fill x
## Name frame  memory block
set mblk_name_fr [frame $mem_block_fr.nfr -borderwidth 4 -relief sunken]
set mblk_name_lb [label $mblk_name_fr.lb1 -text "Block Name: "]
set mblk_name_en [entry $mblk_name_fr.en1 -width 25 -validate key -vcmd {val_name %W %P}]
pack $mblk_name_lb -side left
pack $mblk_name_en -side left
pack $mblk_name_fr -anchor w -fill x
##  memory block start address
set mblk_start_fr [frame $mem_block_fr.sfr -borderwidth 4 -relief sunken]
set mblk_start_lb [label $mblk_start_fr.lb1 -text "Block Start Address: "]
set mblk_start_en [entry $mblk_start_fr.en1 -width 12 -validate key -vcmd {val_hex %W %P}]
pack $mblk_start_lb $mblk_start_en -side left
pack $mblk_start_fr -anchor w -fill x
#  memory block depth
set mblk_depth_fr [frame $mem_block_fr.szfr -borderwidth 4 -relief sunken]
set mblk_depth_lb [label $mblk_depth_fr.lb1 -text "Block Depth : "]
set mblk_depth_cb [ttk::combobox $mblk_depth_fr.cb1 -values $msizes -state readonly -width 5]
pack $mblk_depth_lb -side left
pack $mblk_depth_cb -side left
pack $mblk_depth_fr  -anchor w -fill x
##  memory block access type
set mblk_acc_fr [frame $mem_block_fr.accf -borderwidth 4 -relief sunken]
set mblk_acc_lb [label $mblk_acc_fr.acclb -text "Access Type: "]
set mblk_acc_cb [ttk::combobox $mblk_acc_fr.cb1 -textvariable block_acc_type -values \
                    $baccess_type_lst -state readonly -width 5]
set mblk_typ_lb [label $mblk_acc_fr.lb1 -text "Block Type: "]
set mblk_typ_cb [ttk::combobox $mblk_acc_fr.tcb -values $block_type_lst -state readonly -width 5]
pack $mblk_acc_lb $mblk_acc_cb $mblk_typ_lb $mblk_typ_cb -side left
pack $mblk_acc_fr -anchor w
$mblk_acc_cb set RW
# Description Frame  displays only when check button checked.
set mblk_desc_fr [frame $mem_block_fr.defr1 -borderwidth 4 -relief sunken]
set mblk_desc_ckb [checkbutton $mblk_desc_fr.enbut -text "Description" -command gui_show_mblk_desc \
                   -variable block_desc_en]
set mblk_desc_txt [text $mblk_desc_fr.txt -height 6]
pack $mblk_desc_ckb -side left
pack $mblk_desc_fr -anchor nw
## create list of block entry items
set blk_fld_lst {}
lappend blk_fld_lst $mblk_name_en $mblk_start_en $mblk_depth_cb $mblk_typ_cb $mblk_desc_txt $mblk_acc_cb

################################
##  Canvas for pic of block usage map
set bscrollr {0c 0c 0c 500c}
set blk_canv_fr [frame $mem_block_fr.cav1 -borderwidth 4 -relief sunken]
set blk_vsb [scrollbar $blk_canv_fr.vsb -orient vertical -command {$blk_canv_fr.canv yview}]
set blk_cav [canvas $blk_canv_fr.canv -bg white -width 650 -scrollregion $bscrollr \
              -yscrollincrement 8 -yscrollcommand {$blk_canv_fr.vsb set}]
pack $blk_cav -side left
pack $blk_vsb -side right -fill y
pack $blk_canv_fr -anchor w -fill x


###########################################################################
##  Memory definition entries.
##  memory frame
set mem_fr [frame $mblkframe.mfr]
set mem_but_fr [frame $mem_fr.btfr1 -borderwidth 4 -relief sunken]
set mem_but_lb [label $mem_but_fr.lb1 -text ""]
pack $mem_but_lb -side left -fill x
pack $mem_but_fr -anchor w -fill x
##  name entry frame
set mem_name_fr [frame $mem_fr.memfr1 -borderwidth 4 -relief sunken]
set mem_name_lb [label $mem_name_fr.lb1 -text "Memory Name: "]
set mem_name_en [entry $mem_name_fr.en1 -width 26 -validate key -vcmd {val_name %W %P}]
pack $mem_name_lb $mem_name_en -side left
pack $mem_name_fr -anchor w
## Start address entry frame
set mem_sadd_fr [frame $mem_fr.saddfr -borderwidth 4 -relief sunken]
set mem_sadd_lb [label $mem_sadd_fr.lb1 -text "Memory Start Address: "]
set mem_sadd_en [entry $mem_sadd_fr.en1 -width 12 -validate key -vcmd {val_hex %W %P}]
pack $mem_sadd_lb $mem_sadd_en -side left
pack $mem_sadd_fr -anchor w
#  memory depth
set mem_depth_fr [frame $mem_fr.szfr2 -borderwidth 4 -relief sunken]
set mem_depth_lb [label $mem_depth_fr.lb1 -text "Memory Depth : "]
set mem_depth_cb [ttk::combobox $mem_depth_fr.cb1 -values $msizes -state readonly -width 5]
pack $mem_depth_lb -side left
pack $mem_depth_cb -side left
pack $mem_depth_fr  -anchor w
## Memory Width frame
set mem_widt_fr [frame $mem_fr.widtfr  -borderwidth 4 -relief sunken]
set mem_widt_lb [label $mem_widt_fr.lb1 -text "Memory Width: "]
set mem_widt_en [entry $mem_widt_fr.en1 -width 5 -validate key -vcmd {val_dec %W %P}]
pack $mem_widt_lb $mem_widt_en -side left
pack $mem_widt_fr -anchor w
##  memory  access type
set mem_acc_fr [frame $mem_fr.maccf -borderwidth 4 -relief sunken]
set mem_acc_lb [label $mem_acc_fr.acclb -text "Memory Access Type: "]
set mem_acc_cb [ttk::combobox $mem_acc_fr.cb1 -textvariable memory_acc_type -values \
                    $baccess_type_lst -state readonly -width 5]
set mem_dval_lb [label $mem_acc_fr.lb1 -text "Memory Default Value : "]
set mem_dval_en [entry $mem_acc_fr.en -width 12]
pack $mem_acc_lb $mem_acc_cb $mem_dval_lb $mem_dval_en -side left
pack $mem_acc_fr -anchor w
$mem_acc_cb set RW
# Description Frame  displays only when check button checked.
set mem_desc_fr [frame $mem_fr.defr2 -borderwidth 4 -relief sunken]
set mem_desc_ckb [checkbutton $mem_desc_fr.enbut -text "Description" -command gui_show_mem_desc \
                   -variable memory_desc_en]
set mem_desc_txt [text $mem_desc_fr.txt -height 6]
pack $mem_desc_ckb -side left
pack $mem_desc_fr -anchor nw
## list of memory entry items
set mem_fld_lst {}
lappend mem_fld_lst $mem_name_en $mem_sadd_en $mem_widt_en $mem_depth_cb \
    $mem_acc_cb $mem_dval_en $mem_desc_txt

#################################################
##  register detail frame
set regd [frame $mblkframe.rdf1]
## button frame
set regd_but_fr [frame $regd.buf1  -borderwidth 4 -relief sunken]
set regd_lb [label $regd_but_fr.lb1  -text ""]
set but_fr1 [frame $regd_but_fr.bf2]
pack $regd_lb -side left -fill x
pack $but_fr1 -side right -fill x
pack $regd_but_fr -fill x
##  Register type selection
set reg_type_fr [frame $regd.typf -borderwidth 4 -relief sunken]
set reg_type_lb [label $reg_type_fr.typlb -text "Register Type: "]
set reg_tp_rb1  [radiobutton $reg_type_fr.rb1 -text "Regular" -variable curr_reg_type \
                    -value "reg" -command update_regtype_gui]
set reg_tp_rb2  [radiobutton $reg_type_fr.rb2 -text "Alternate" -variable curr_reg_type \
                    -value "alt" -command update_regtype_gui]
set reg_tp_rb3  [radiobutton $reg_type_fr.rb3 -text "Indexed" -variable curr_reg_type \
                    -value "idx" -command update_regtype_gui]
set reg_tp_rb4  [radiobutton $reg_type_fr.rb4 -text "Concatinated" -variable curr_reg_type \
                    -value "con" -command update_regtype_gui]
pack $reg_type_lb $reg_tp_rb1 $reg_tp_rb2 $reg_tp_rb3 $reg_tp_rb4 -side left
pack $reg_type_fr -anchor w -fill x
##  Name Frame
set reg_name_fr [frame $regd.naf1 -borderwidth 4 -relief sunken]
set reg_name_lb [label $reg_name_fr.lb1 -text "Register Name"]
set reg_name_en [entry $reg_name_fr.en1 -width 30 -validate key -vcmd {val_name %W %P}]
pack $reg_name_lb -side left
pack $reg_name_en -side left -padx 10
pack $reg_name_fr -anchor w -fill x
set reg_full_fr [frame $regd.fufr]
## address frame
set reg_addr_fr [frame $reg_full_fr.adf1 -borderwidth 4 -relief sunken]
set reg_addr_lbl [label $reg_addr_fr.lbadd -text "Register Address: "]
set reg_addr_ent [entry $reg_addr_fr.enadd -validate key -vcmd {val_hex %W %P}]
pack $reg_addr_lbl -side left
pack $reg_addr_ent -side left
pack $reg_addr_fr -side left
##  access type
set reg_acc_fr [frame $reg_full_fr.accf -borderwidth 4 -relief sunken]
set reg_acc_lb [label $reg_acc_fr.acclb -text "Access Type:      "]
set reg_acc_cb [ttk::combobox $reg_acc_fr.cb1 -textvariable curr_acc_type -values \
                    $access_type_lst -state readonly -width 5]
pack $reg_acc_lb -side left
pack $reg_acc_cb -side left
pack $reg_acc_fr -side left -fill x -expand 1
pack $reg_full_fr -anchor w -fill x -expand 1
$reg_acc_cb set RW
##  description text box
set reg_desc_fr [frame $regd.desf1 -borderwidth 4 -relief sunken]
set reg_but_fr  [frame $reg_desc_fr.bfr]
set reg_desc_lb [label $reg_but_fr.deslb -text "Register Description"]
set reg_desc_ckb [checkbutton $reg_but_fr.enbut -text "Show" -command gui_show_reg_desc \
                   -variable reg_desc_en -relief raised]
set reg_desc_tb [text $reg_desc_fr.txt1 -height 6]
pack $reg_desc_ckb -side left
pack $reg_desc_lb -side left -fill x
pack $reg_but_fr -anchor w
pack $reg_desc_fr -anchor w -fill x
## Enabled entry
set reg_enb_fr [frame $regd.enf -borderwidth 4 -relief sunken]
set reg_enb_lb [label $reg_enb_fr.enl1 -text "Enabled: "]
set reg_enb_ent [entry $reg_enb_fr.ent1]
pack $reg_enb_lb -side left
pack $reg_enb_ent -fill x
pack $reg_enb_fr -fill x
## Visible entry
set reg_vis_fr [frame $regd.visf -borderwidth 4 -relief sunken]
set reg_vis_lb [label $reg_vis_fr.enl1 -text "Visible: "]
set reg_vis_ent [entry $reg_vis_fr.ent1]
pack $reg_vis_lb -side left
pack $reg_vis_ent -fill x
pack $reg_vis_fr -fill x
##  Verification frame / items
set reg_verif_fr [frame $regd.verf -borderwidth 4 -relief sunken]
set reg_verif_lb [label $reg_verif_fr.enl1 -text "Verificaiton Items: "]
set reg_testable_cb [checkbutton $reg_verif_fr.cb1 -text "Testable" -variable reg_testable]
set reg_volitile_cb [checkbutton $reg_verif_fr.cb2 -text "Volitile" -variable reg_volitile]
pack $reg_verif_lb $reg_testable_cb $reg_volitile_cb -side left
pack $reg_verif_fr -fill x
##  Indexed selection frame
set reg_idx_fr [frame $regd.idxf -borderwidth 4 -relief sunken]
set reg_idx_lb [label $reg_idx_fr.idxrlb -text "Indexed Register: "]
set reg_idx_cb1 [ttk::combobox $reg_idx_fr.cb1 -values $RegLst -state readonly -width 20]
set reg_idx_lb1 [label $reg_idx_fr.idxflb -text "Indexed Field: "]
set reg_idx_cb2 [ttk::combobox $reg_idx_fr.cb2 -values $IndexFldLst -state readonly -width 15]
set reg_idx_lb2 [label $reg_idx_fr.idxelb -text "Index value: "]
set reg_idx_en [entry $reg_idx_fr.ent -width 12]
pack $reg_idx_lb -side left
pack $reg_idx_cb1 -side left
pack $reg_idx_lb1 -side left
pack $reg_idx_cb2 -side left
pack $reg_idx_lb2 -side left
pack $reg_idx_en -side left

##  Concatinated frame
set reg_con_fr [frame $regd.conf -borderwidth 4 -relief sunken]
set reg_con_cb [checkbutton $reg_con_fr.cb1 -text "Concatination Start"]
pack $reg_con_cb -side left


###################################################################  <<<=== temp code
##  Canvas for pic of register
set reg_canv_fr [frame $regd.cav1 -borderwidth 4 -relief sunken]
set reg_cav [canvas $reg_canv_fr.canv -bg white -width 650 -height 280]
pack $reg_cav -side left
pack $reg_canv_fr -anchor w -fill x

## draw the top and bottom lines for reg bits
#$reg_cav create line 5 150 645 150
#$reg_cav create line 5 130 645 130
## draw the dividers, bit numbers and color box. (tag items)
##  tags  er (enable rectangle) bn (Bit Number text)
set bit_txt "31"
for {set i 0} {$i <= 32} {incr i} {
    set x [expr {($i * 20) + 5}]
    set xt [expr {($i * 20) + 10}]
    #$reg_cav create line $x 150 $x 130
    if {$i < 32} {
        set x2 [expr {$x + 20}]
        $reg_cav create rectangle $x 150 $x2 130  -fill green -tags er$bit_txt
    }
    $reg_cav create text $xt 135 -text "$bit_txt" -anchor nw -tags bn$bit_txt
    set bit_txt [expr {$bit_txt - 1}]

}

##  Tags  bt (bit text)  bl (bit lines)
$reg_cav create text 480 10 -anchor ne  -text "0" -tags bt0
$reg_cav create line 635 125 635 15 -tags bl0
$reg_cav create line 635 15 485 15 -tags bl0
$reg_cav create text 480 25 -anchor ne  -text "1" -tags bt1
$reg_cav create line 615 125 615 30 -tags bl1
$reg_cav create line 615 30 485 30 -tags bl1
$reg_cav create text 480 40 -anchor ne  -text "2" -tags bt2
$reg_cav create line 595 125 595 45 -tags bl2
$reg_cav create line 595 45 485 45 -tags bl2
$reg_cav create text 480 55 -anchor ne  -text "3" -tags bt3
$reg_cav create line 575 125 575 60 -tags bl3
$reg_cav create line 575 60 485 60 -tags bl3
$reg_cav create text 480 70 -anchor ne  -text "4" -tags bt4
$reg_cav create line 555 125 555 75 -tags bl4
$reg_cav create line 555 75 485 75 -tags bl4
$reg_cav create text 480 85 -anchor ne  -text "5" -tags bt5
$reg_cav create line 535 125 535 90 -tags bl5
$reg_cav create line 535 90 485 90 -tags bl5
$reg_cav create text 480 100 -anchor ne -text "6" -tags bt6
$reg_cav create line 515 125 515 105 -tags bl6
$reg_cav create line 515 105 485 105 -tags bl6
$reg_cav create text 480 115 -anchor ne -text "7" -tags bt7
$reg_cav create line 495 125 495 120 -tags bl7
$reg_cav create line 495 120 485 120 -tags bl7

$reg_cav create text 500 155 -anchor nw -text "8" -tags bt8
$reg_cav create line 475 155 475 160 -tags bl8
$reg_cav create line 475 160 495 160 -tags bl8
$reg_cav create text 500 170 -anchor nw -text "9" -tags bt9
$reg_cav create line 455 155 455 175 -tags bl9
$reg_cav create line 455 175 495 175 -tags bl9
$reg_cav create text 500 185 -anchor nw -text "10" -tags bt10
$reg_cav create line 435 155 435 190 -tags bl10
$reg_cav create line 435 190 495 190 -tags bl10
$reg_cav create text 500 200 -anchor nw -text "11" -tags bt11
$reg_cav create line 415 155 415 205 -tags bl11
$reg_cav create line 415 205 495 205 -tags bl11
$reg_cav create text 500 215 -anchor nw -text "12" -tags bt12
$reg_cav create line 395 155 395 220 -tags bl12
$reg_cav create line 395 220 495 220 -tags bl12
$reg_cav create text 500 230 -anchor nw -text "13" -tags bt13
$reg_cav create line 375 155 375 235 -tags bl13
$reg_cav create line 375 235 495 235 -tags bl13
$reg_cav create text 500 245 -anchor nw -text "14" -tags bt14
$reg_cav create line 355 155 355 250 -tags bl14
$reg_cav create line 355 250 495 250 -tags bl14
$reg_cav create text 500 260 -anchor nw -text "15" -tags bt15
$reg_cav create line 335 155 335 265 -tags bl15
$reg_cav create line 335 265 495 265 -tags bl15

$reg_cav create text 160 10 -anchor ne  -text "16" -tags bt16
$reg_cav create line 315 125 315 15 -tags bl16
$reg_cav create line 315 15 165 15 -tags bl16
$reg_cav create text 160 25 -anchor ne  -text "17" -tags bt17
$reg_cav create line 295 125 295 30 -tags bl17
$reg_cav create line 295 30 165 30 -tags bl17
$reg_cav create text 160 40 -anchor ne  -text "18" -tags bt18
$reg_cav create line 275 125 275 45 -tags bl18
$reg_cav create line 275 45 165 45 -tags bl18
$reg_cav create text 160 55 -anchor ne  -text "19" -tags bt19
$reg_cav create line 255 125 255 60 -tags bl19
$reg_cav create line 255 60 165 60 -tags bl19
$reg_cav create text 160 70 -anchor ne  -text "20" -tags bt20
$reg_cav create line 235 125 235 75 -tags bl20
$reg_cav create line 235 75 165 75 -tags bl20
$reg_cav create text 160 85 -anchor ne  -text "21" -tags bt21
$reg_cav create line 215 125 215 90 -tags bl21
$reg_cav create line 215 90 165 90 -tags bl21
$reg_cav create text 160 100 -anchor ne -text "22" -tags bt22
$reg_cav create line 195 125 195 105 -tags bl22
$reg_cav create line 195 105 165 105 -tags bl22
$reg_cav create text 160 115 -anchor ne -text "23" -tags bt23
$reg_cav create line 175 125 175 120 -tags bl23
$reg_cav create line 175 120 165 120 -tags bl23

$reg_cav create text 180 155 -anchor nw -text "24" -tags bt24
$reg_cav create line 155 155 155 160 -tags bl24
$reg_cav create line 155 160 175 160 -tags bl24
$reg_cav create text 180 170 -anchor nw -text "25" -tags bt25
$reg_cav create line 135 155 135 175 -tags bl25
$reg_cav create line 135 175 175 175 -tags bl25
$reg_cav create text 180 185 -anchor nw -text "26" -tags bt26
$reg_cav create line 115 155 115 190 -tags bl26
$reg_cav create line 115 190 175 190 -tags bl26
$reg_cav create text 180 200 -anchor nw -text "27" -tags bt27
$reg_cav create line 95 155 95 205 -tags bl27
$reg_cav create line 95 205 175 205 -tags bl27
$reg_cav create text 180 215 -anchor nw -text "28" -tags bt28
$reg_cav create line 75 155 75 220 -tags bl28
$reg_cav create line 75 220 175 220 -tags bl28
$reg_cav create text 180 230 -anchor nw -text "29" -tags bt29
$reg_cav create line 55 155 55 235 -tags bl29
$reg_cav create line 55 235 175 235 -tags bl29
$reg_cav create text 180 245 -anchor nw -text "30" -tags bt30
$reg_cav create line 35 155 35 250 -tags bl30
$reg_cav create line 35 250 175 250 -tags bl30
$reg_cav create text 180 260 -anchor nw -text "31" -tags bt31
$reg_cav create line 15 155 15 265 -tags bl31
$reg_cav create line 15 265 175 265 -tags bl31


####################################################################

# register entry items list
set reg_fld_lst {}
lappend reg_fld_lst $reg_name_en $reg_addr_ent $reg_acc_cb $reg_desc_tb $reg_enb_ent \
    $reg_vis_ent $reg_testable_cb $reg_volitile_cb  $reg_idx_cb1 $reg_idx_cb2 $reg_idx_en \
    $reg_con_cb $reg_tp_rb1 $reg_tp_rb2 $reg_tp_rb3 $reg_tp_rb4

################################################
##  Field detail frame
set fldd [frame $mblkframe.fdl1]
##  Button and title lable frame
set fldd_but_fr [frame $fldd.bfr1 -borderwidth 4 -relief sunken]
set fldd_lb [label $fldd_but_fr.lb1  -text ""]
pack $fldd_lb -side left
pack $fldd_but_fr -anchor w -fill x

##  Name Frame
set fldd_name_fr [frame $fldd.nfr1 -borderwidth 4 -relief sunken]
set fldd_name_lb [label $fldd_name_fr.lb1 -text "Field Name: "]
set fldd_name_en [entry $fldd_name_fr.en1 -width 30 -validate key -vcmd {val_name %W %P}]
pack $fldd_name_lb -side left
pack $fldd_name_en -side left
pack $fldd_name_fr -anchor w -fill x
##  size, index concat frame
set fldd_sidx_fr [frame $fldd.sidx -borderwidth 4 -relief sunken]
set fldd_sidx_lb1 [label $fldd_sidx_fr.lb1 -text "Index: "]
set fldd_sidx_lb2 [label $fldd_sidx_fr.lb2 -text "Size: "]
set fldd_sidx_eni [entry $fldd_sidx_fr.en1 -width 3 -validate key -vcmd {val_dec %W %P}]
set fldd_sidx_ens [entry $fldd_sidx_fr.en2 -width 4 -validate key -vcmd {val_dec %W %P}]
pack $fldd_sidx_lb1 $fldd_sidx_eni $fldd_sidx_lb2 $fldd_sidx_ens -side left
pack $fldd_sidx_fr -anchor w -fill x
##  access type
set fldd_acc_lb [label $fldd_sidx_fr.acclb -text "Access Type: "]
set fldd_acc_cb [ttk::combobox $fldd_sidx_fr.cb1 -textvariable curr_acc_type -values \
                    $access_type_lst -state readonly -width 5]
pack $fldd_acc_lb -side left
pack $fldd_acc_cb -side left
$fldd_acc_cb set RW
##  default Value
set fldd_def_lb [label $fldd_sidx_fr.lb -text "Reset Value: "]
set fldd_def_en [entry $fldd_sidx_fr.en -width 12 -validate key -vcmd {val_hex %W %P}]
pack $fldd_def_lb -side left
pack $fldd_def_en -side left
##  concatination field
set fldd_conc_fr  [frame $fldd.ccfr -borderwidth 4 -relief sunken]
set fldd_conc_lb3 [label $fldd_conc_fr.lb3 -text "Concatinate: "]
set fldd_conc_cbc [checkbutton $fldd_conc_fr.cb1]
pack $fldd_conc_lb3 $fldd_conc_cbc -side left
pack $fldd_conc_fr -anchor w -fill x


##  Register type selection
set fldd_type_fr [frame $fldd.typf -borderwidth 4 -relief sunken]
set fldd_type_lb [label $fldd_type_fr.typlb -text "Field Type: "]
set fldd_tp_rb1  [radiobutton $fldd_type_fr.rb1 -text "Boolean" -variable curr_fldd_type \
                    -value "boo" -command update_flddtype_gui]
set fldd_tp_rb2  [radiobutton $fldd_type_fr.rb2 -text "Ranged" -variable curr_fldd_type \
                    -value "ran" -command update_flddtype_gui]
set fldd_tp_rb3  [radiobutton $fldd_type_fr.rb3 -text "Enumerated" -variable curr_fldd_type \
                    -value "enu" -command update_flddtype_gui]
set fldd_tp_rb4  [radiobutton $fldd_type_fr.rb4 -text "Reserved" -variable curr_fldd_type \
                    -value "res" -command update_flddtype_gui]
pack $fldd_type_lb $fldd_tp_rb1 $fldd_tp_rb2 $fldd_tp_rb3 $fldd_tp_rb4 -side left
pack $fldd_type_fr -anchor w -fill x

##  description text box
set fldd_desc_fr [frame $fldd.desf1 -borderwidth 4 -relief sunken]
set fldd_but_fr  [frame $fldd_desc_fr.bfr]
set fldd_desc_lb [label $fldd_but_fr.deslb -text "Field Description"]
set fldd_desc_ckb [checkbutton $fldd_but_fr.enbut -text "Show" -command gui_show_fldd_desc \
                   -variable fldd_desc_en -relief raised]
set fldd_desc_tb [text $fldd_desc_fr.txt1 -height 12]
pack $fldd_desc_ckb -side left
pack $fldd_desc_lb -side left -fill x
pack $fldd_but_fr -anchor w
pack $fldd_desc_fr -anchor w -fill x

##  Ranged Frame
set fldd_range_fr [frame $fldd.ranf1 -borderwidth 4 -relief sunken]
set fldd_range_lb1 [label $fldd_range_fr.lb1 -text "Min: "]
set fldd_range_min [entry $fldd_range_fr.en1 -width 12 -validate key -vcmd {val_hex %W %P}]
set fldd_range_lb2 [label $fldd_range_fr.lb2 -text "Max: "]
set fldd_range_max [entry $fldd_range_fr.en2 -width 12 -validate key -vcmd {val_hex %W %P}]
pack $fldd_range_lb1 $fldd_range_min $fldd_range_lb2 $fldd_range_max -side left

##  Enumerated Frame
set fldd_enum_fr [frame $fldd.enufr -borderwidth 4 -relief sunken]
set fldd_enum_lb1 [label $fldd_enum_fr.lb1 -text "Enumerated values"]
set fldd_enum_ntxt [text $fldd_enum_fr.txtn -width 25 -height 8]
pack $fldd_enum_lb1 -anchor w -fill x
pack $fldd_enum_ntxt -side left
## Enabled entry
set fldd_enb_fr [frame $fldd.enf -borderwidth 4 -relief sunken]
set fldd_enb_lb [label $fldd_enb_fr.enl1 -text "Enabled: "]
set fldd_enb_ent [entry $fldd_enb_fr.ent1]
pack $fldd_enb_lb -side left
pack $fldd_enb_ent -fill x
pack $fldd_enb_fr -fill x
## Visible entry
set fldd_vis_fr [frame $fldd.visf -borderwidth 4 -relief sunken]
set fldd_vis_lb [label $fldd_vis_fr.enl1 -text "Visible: "]
set fldd_vis_ent [entry $fldd_vis_fr.ent1]
pack $fldd_vis_lb -side left
pack $fldd_vis_ent -fill x
pack $fldd_vis_fr -fill x
##  Verification frame / items
set fldd_verif_fr [frame $fldd.verf -borderwidth 4 -relief sunken]
set fldd_verif_lb [label $fldd_verif_fr.enl1 -text "Verificaiton Items: "]
set fldd_testable_cb [checkbutton $fldd_verif_fr.cb1 -text "Testable" -variable fldd_testable]
set fldd_volitile_cb [checkbutton $fldd_verif_fr.cb2 -text "Volitile" -variable fldd_volitile]
pack $fldd_verif_lb $fldd_testable_cb $fldd_volitile_cb -side left
pack $fldd_verif_fr -fill x

##  modified Write / Read frame
set fldd_modw_fr [frame $fldd.modwfr -borderwidth 4 -relief sunken]
set fldd_modw_lb [label $fldd_modw_fr.lb -text "Modify On Write: "]
set fldd_modw_cb1 [ttk::combobox $fldd_modw_fr.cb1 -values $modify_wr_lst -state readonly -width 14]
set fldd_modw_lb1 [label $fldd_modw_fr.lb1 -text "Modify On Read: "]
set fldd_modw_cb2 [ttk::combobox $fldd_modw_fr.cb2  -values $modify_rd_lst -state readonly -width 14]

pack $fldd_modw_lb $fldd_modw_cb1 -side left
pack $fldd_modw_lb1 $fldd_modw_cb2 -side left
pack $fldd_modw_fr  -anchor w -fill x
## field entry items.
set fld_fld_lst {}
lappend fld_fld_lst $fldd_name_en $fldd_sidx_eni $fldd_sidx_ens $fldd_acc_cb $fldd_def_en \
    $fldd_conc_cbc $fldd_tp_rb1 $fldd_tp_rb2 $fldd_tp_rb3 $fldd_tp_rb4 $fldd_desc_tb \
    $fldd_range_min $fldd_range_max $fldd_enum_ntxt $fldd_enb_ent $fldd_vis_ent \
    $fldd_testable_cb $fldd_volitile_cb $fldd_modw_cb1 $fldd_modw_cb2

##  set up some default colors.   <<<<<<<<<<================   ??
##tk_setPalette background wheat1 disabledForeground black activeBackground white

###############################################################################
##  control Tab
set reg_ctl_fr [frame $nb.ctlfr -borderwidth 4 -relief raised -bg lightblue]
$nb add $reg_ctl_fr  -text  "Tool Controls" -underline 0

set file_ctl_fr [frame $reg_ctl_fr.fctl -borderwidth 4 -relief sunken]
set file_load_lb [label $file_ctl_fr.lb1 -text "Load / Save Config File"]
###  file load frame
set file_load_fr [frame $file_ctl_fr.ldfr1 -borderwidth 4 -relief sunken]
set file_load_ldb [button $file_load_fr.bt2 -text "Load File" -command gui_load_file]
set file_load_en [entry $file_load_fr.en1 -width 80]
set file_load_bt [button $file_load_fr.bt1 -text "Browse..." -command gui_set_file]
pack $file_load_lb -anchor n
pack $file_load_ldb -side left -padx 5
pack $file_load_en -side left -fill x
pack $file_load_bt -side right -padx 5
pack $file_load_fr -anchor w

###  file save frame
set file_save_fr [frame $file_ctl_fr.svfr1 -borderwidth 4 -relief sunken]
set file_save_ldb [button $file_save_fr.bt2 -text "Save File" -command gui_save_file]
set file_save_en [entry $file_save_fr.en1 -width 80]
set file_save_bt [button $file_save_fr.bt1 -text "Browse..." -command gui_set_sfile]
pack $file_save_ldb -side left -padx 5
pack $file_save_en -side left -fill x
pack $file_save_bt -side right -padx 5
pack $file_save_fr -anchor w
pack $file_ctl_fr -anchor w -pady 5

##  HTML control frame
set html_ctl_fr [frame $reg_ctl_fr.htmlfr -borderwidth 4 -relief sunken]
set html_lb [label $html_ctl_fr.lb1 -text "HTML Gen"]
set html_save_fr [frame $html_ctl_fr.svfr1 -borderwidth 4 -relief sunken]
#set html_save_lb [label $html_save_fr.lb1 -text "HTML Output File "]
set html_save_en [entry $html_save_fr.en1 -width 80]
set html_save_bt [button $html_save_fr.bt1 -text "Browse..." -command gui_set_hfile]
set html_save_gen [button $html_save_fr.bt2 -text "Gen HTML" -command gui_gen_html]
#pack $html_save_lb -side left -padx 5
pack $html_lb -anchor n
pack $html_save_gen -side left -padx 5
pack $html_save_en -side left
pack $html_save_bt -side right -padx 5
pack $html_save_fr -side left
pack $html_ctl_fr -anchor w -pady 5

##  C header generation frame
set cgen_ctl_fr [frame $reg_ctl_fr.cgenfr -borderwidth 4 -relief sunken]
set cgen_lb [label $cgen_ctl_fr.lb1 -text "C Header Gen"]
set cgen_save_fr [frame $cgen_ctl_fr.svfr1 -borderwidth 4 -relief sunken]
set cgen_save_en [entry $cgen_save_fr.en1 -width 80]
set cgen_save_bt [button $cgen_save_fr.bt1 -text "Browse..." -command gui_set_ifile]
set cgen_save_gen [button $cgen_save_fr.bt2 -text "Gen C Include" -command gui_gen_ifile]
## address wids
set cgen_add_fr [frame $cgen_ctl_fr.opadd -borderwidth 4 -relief sunken]
set cgen_add_cb [checkbutton $cgen_add_fr.addr -text "Regiser Address" -variable RegAddrEn]
set cgen_add_plb [label $cgen_add_fr.plb -text "Prefix:"]
set cgen_add_pen [entry $cgen_add_fr.pen -width 10]
set cgen_add_slb [label $cgen_add_fr.slb -text "Suffix:"]
set cgen_add_sen [entry $cgen_add_fr.sen -width 10]
set cgen_add_cb1 [checkbutton $cgen_add_fr.rel -text "Relative/Absolute" -variable RegAddrAbs]
##  reg mask
set cgen_reg_fr [frame $cgen_ctl_fr.opreg -borderwidth 4 -relief sunken]
set cgen_reg_cb [checkbutton $cgen_reg_fr.reg -text "Regiser Masks" -variable RegMaskEn]
set cgen_reg_plb [label $cgen_reg_fr.plb -text "Prefix:"]
set cgen_reg_pen [entry $cgen_reg_fr.pen -width 10]
set cgen_reg_slb [label $cgen_reg_fr.slb -text "Suffix:"]
set cgen_reg_sen [entry $cgen_reg_fr.sen -width 10]
##  fld mask
set cgen_fld_fr [frame $cgen_ctl_fr.opfld -borderwidth 4 -relief sunken]
set cgen_fld_cb [checkbutton $cgen_fld_fr.fld -text "Field Masks" -variable RegFMaskEn]
set cgen_fld_plb [label $cgen_fld_fr.plb -text "Prefix:"]
set cgen_fld_pen [entry $cgen_fld_fr.pen -width 10]
set cgen_fld_slb [label $cgen_fld_fr.slb -text "Suffix:"]
set cgen_fld_sen [entry $cgen_fld_fr.sen -width 10]

##  save frame
pack $cgen_lb -anchor n
pack $cgen_save_gen -side left -padx 5
pack $cgen_save_en -side left
pack $cgen_save_bt -side left -padx 5
pack $cgen_save_fr  -anchor w
# address frame
pack $cgen_add_cb $cgen_add_plb $cgen_add_pen $cgen_add_slb $cgen_add_sen -side left
pack $cgen_add_cb1 -side left -padx 10
pack $cgen_add_fr -anchor w
# reg frame
pack $cgen_reg_cb $cgen_reg_plb $cgen_reg_pen $cgen_reg_slb $cgen_reg_sen  -side left
pack $cgen_reg_fr -anchor w
# field frame
pack $cgen_fld_cb $cgen_fld_plb $cgen_fld_pen $cgen_fld_slb $cgen_fld_sen  -side left
pack $cgen_fld_fr -anchor w
pack $cgen_ctl_fr -anchor w -pady 5
##  field list for entries  pre and suf
lappend inc_en_lst $cgen_add_pen $cgen_add_sen $cgen_reg_pen $cgen_reg_sen $cgen_fld_pen $cgen_fld_sen


#########################################################################
##  source other files
source src/reg_events.tcl
source src/reg_common.tcl
source src/reg_workbench.tcl
source src/reg_validate.tcl
source src/reg_graphics.tcl
source src/reg_menu.tcl

source src/reg_modules.tcl

# Create a menu
set m [menu .popupMenu]

#######################################################################
##  initial tool state.
pack $mem_map_frame -anchor nw
set_button_mode init

#################################################
##  Load the gui_ini if it exists
##   This must be the last thing done,
##   as you want to load the user changes / additions.
set has_ini [file exists "gui_ini.tcl"]
if {$has_ini == 1} {
    source "gui_ini.tcl"
    gui_ini
}
