#! /usr/bin/env wish
##-------------------------------------------------------------------------------
##--                     Copyright 2008 Sckoarn
##--                        All Rights Reserved
##
##           This program is free software; you can redistribute it and/or modify
##               it under the terms of the GNU General Public License as published by
##               the Free Software Foundation; either version 2 of the License, or
##               (at your option) any later version.
##           
##               This program is distributed in the hope that it will be useful,
##               but WITHOUT ANY WARRANTY; without even the implied warranty of
##               MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
##               GNU General Public License for more details.
##           
##               You should have received a copy of the GNU General Public License
##               along with this program; if not, write to the Free Software
##               Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
##-------------------------------------------------------------------------------
##-- $Author: sckoarn $
##--
##-- $Date: 2007/09/02 04:01:43 $
##--
##-- $Name:  $
##--
##-- $Id:  $
##--
##-- $Source:  $
##--
##-- Description :
##--      This application assists the user by eabling the user to create their
##           own collection of items and BPO's to calculate manufacture cost.
##--      
##------------------------------------------------------------------------------

## package requires
package require Iwidgets 4.0

source "evemngr_vars.tcl"
source "common.tcl"

## set the current version info
set version "v0.01"
## put up a title on the main window boarder
wm title . "Eve Manager $version"

#############################################################
##  The Tabs widget  -width 760 -height 670 
iwidgets::tabnotebook .tnb -tabbackground grey55 -background grey80 -backdrop grey40
pack .tnb -padx 2 -pady 2 -fill both -expand yes
.tnb configure -tabpos n



#set helpVar ""

## Buttons frame 1
set f1 [frame .f]
set dump [button $f1.dmp -text "Config Save" -command {write_setup}]
set load [button $f1.load -text "Config Load" -command {load_setup}]
#button $f1.br1 -text "Add Item" -command {make_item $f2}
#button $f1.brx -text "Dump XMD" -command {dbg_msg "This feature is not available yet."}
#button $f1.brx -text "Add Frame" -command {make_frame $sfpbo1}
#button $f1.brt -text "Add Page" -command {add_page .tnb}
button $f1.br3 -text "Exit" -command "exit"
#pack $f1.br1 -side left -expand 1
#pack $f1.brx -side left -expand 1
#pack $f1.brt -side left -expand 1
pack $dump -side left
pack $load -side left
pack $f1.br3 -side right -padx 20
pack $f1 -fill x -side bottom
set msg_lb [label .mlb1 -justify left -text "Welcome" -textvariable helpVar]
pack $msg_lb -side left -fill x

########################################################
##  Items Page
set page [.tnb add -label "Items"]

.tnb view "Items"

## the Scrolled frame for items list
set main_lst [iwidgets::scrolledframe $page.sfi1 -borderwidth 2 -width 240 \
    -labeltext "Items\n Market Cost" -hscrollmode none]
set sfitems1 [$page.sfi1 childsite]
pack $page.sfi1 -side left -fill y

set manuf_lst [iwidgets::scrolledframe $page.sfi3 -borderwidth 2 -width 240 \
    -labeltext "Items Cost\n Manufactured"]
set sfitems3 [$page.sfi3 childsite]
pack $page.sfi3 -side left -fill y

set invi_lst [iwidgets::scrolledframe $page.sfi2 -borderwidth 2\
    -labeltext "Inventory\n       Quanity         Unit Cost        Total Value        Market Value                                                              "]
set sfitems2 [$page.sfi2 childsite]
pack $page.sfi2 -side left -expand yes -fill both

set f2 [frame $sfitems1.fr2]

pack $f2 -fill x

########################################################
##  BPO Page 1
set bpop1 [.tnb add -label "BPO P1"]

## the Scrolled frame for items list
set bpo_lst1 [iwidgets::scrolledframe $bpop1.sfb1 -borderwidth 2 -width 350\
    -labeltext "BPO's 1" -hscrollmode none]
set sfpbo1 [$bpop1.sfb1 childsite]
pack $bpop1.sfb1 -side left -fill y

set bpo_lst2 [iwidgets::scrolledframe $bpop1.sfb2 -borderwidth 2 -width 350\
    -labeltext "BPO's 2" -hscrollmode none]
set sfpbo2 [$bpop1.sfb2 childsite]
pack $bpop1.sfb2 -side left -fill y


########################################################
##  options pate 1
set option_page [.tnb add -label "Options"]

##  working directory
set work_fr [frame $option_page.wf]
set wdir [iwidgets::entryfield $work_fr.ent1 -labeltext "Working Directory"]
set wbut [button $work_fr.br1 -text "Browse" -command {browsed_from_set $wdir $wdir}]
pack $wbut -side right
pack $wdir -fill x
pack $work_fr -fill x
##  working file
set work_fi [frame $option_page.wfi]
set wfile [iwidgets::entryfield $work_fi.ent1 -labeltext "Working File"]
set fbut [button $work_fi.br1 -text "Browse" -command {browse_set_entry $wdir $wfile}]
pack $fbut -side right
pack $wfile -fill x
pack $work_fi -fill x

##  Manufacturing info
set manu_fr [labelframe $option_page.mfr -text "Manufacture Costs"]
set inst_cost [iwidgets::entryfield $manu_fr.en1 -labeltext "Installation Cost" \
               -validate numeric]
set time_cost [iwidgets::entryfield $manu_fr.en2 -labeltext "Cost / Hour"  \
               -validate numeric]
set tmp_lst {$inst_cost $time_cost}
eval iwidgets::Labeledwidget::alignlabels $tmp_lst

$time_cost insert 0 333
$inst_cost insert 0 1000

pack $inst_cost
pack $time_cost
pack $manu_fr -anchor w
