#! /usr/bin/env wish
##-------------------------------------------------------------------------------
##--                     Copyright 2007 Sckoarn
##--                        All Rights Reserved
##
##           This program is free software; you can redistribute it and/or modify
##               it under the terms of the GNU General Public License as published by
##               the Free Software Foundation; either version 2 of the License, or
##               (at your option) any later version.
##           
##               This program is distributed in the hope that it will be useful,
##               but WITHOUT ANY WARRANTY; without even the implied warranty of
##               MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
##               GNU General Public License for more details.
##           
##               You should have received a copy of the GNU General Public License
##               along with this program; if not, write to the Free Software
##               Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
##-------------------------------------------------------------------------------
##-- $Author: sckoarn $
##--
##-- $Date: 2007/09/02 04:01:43 $
##--
##-- $Name:  $
##--
##-- $Id:  $
##--
##-- $Source:  $
##--
##-- Description :
##--      This application assists the user by eabling the user to create their
##           own collection of items and BPO's to calculate manufacture cost.
##--      
##------------------------------------------------------------------------------

#########################################################################
##  browse and get directory
##    Using extfileselectiondialog get a directory and update the
##    field passed to it
proc browsed_from_set { src dest } {
    set wdir [$src get]
    if {$wdir == ""} {
        iwidgets::extfileselectiondialog .dsb -modality application -fileson false
    } else {
        iwidgets::extfileselectiondialog .dsb -modality application -fileson false \
        -directory $wdir
    }

  if {[.dsb activate]} {
      set dchoice [.dsb get]
      $dest configure -state normal
      $dest delete 0 end
      $dest insert 0 "$dchoice"
      $dest configure -state readonly
  }
  destroy .dsb
}
#########################################################################
##  browse and get file name
##    Using extfileselectiondialog get a directory and update the
##    field passed to it
proc browse_set_entry { src dest } {

    set wdir [$src get]
    if {$wdir == ""} {
        iwidgets::extfileselectiondialog .dsb -modality application
    } else {
        iwidgets::extfileselectiondialog .dsb -modality application -directory $wdir
    }

  if {[.dsb activate]} {
      set dchoice [.dsb get]
      #$dest configure -state normal
      $dest delete 0 end
      $dest insert 0 "$dchoice"
      #$dest configure -state readonly
  }
  destroy .dsb
}
######################################
## get user input
proc get_user_input {text1 text2} {
    
    iwidgets::promptdialog .pd -title "$text1" -modality application \
    -labeltext "$text2"
    .pd center
    .pd activate
    set text [.pd get]
    destroy .pd
    
    return $text
    
}
###########################################################################
##  Message, continue
proc usr_msg { msg } {
  tk_messageBox -message $msg -type ok
}
###################################################################################

set item 2

#########################################################################
##  Clear the tool for config reload
proc clear_mngr {} {
    global item melist bpo_frame_lst items_list inven_list
    
    foreach i $melist {
	    destroy $i
    }
    
    foreach i $bpo_frame_lst {
	    puts $i
	    destroy $i
    }
    foreach i $items_list {
	    destroy $i
    }
    foreach i $inven_list {
	    destroy $i
    }
    update
    set item 2
}
#######################################3
## Proc to make a frame and pack it
proc make_frame {page} {

    global item melist bpo_frame_lst
    
    set i_list ""
    foreach i $melist {
        lappend i_list [$i cget -labeltext]
    }
    ##puts $page $item
    puts $i_list
    ## put out dialog to get BPO title
    iwidgets::promptdialog .pd -title "BPO Title" -modality application \
    -labeltext "Title text:"

    .pd hide 1
    .pd hide 2
    .pd center
    .pd activate
    set text [.pd get]
    
    set fx [frame $page.frx$item]
    set lab [label $fx.labe$item -text "$text" -background tan]
    pack $lab -fill x
    pack $fx
    ##puts $fx
    lappend bpo_frame_lst $fx
    
    destroy .pd
    
    ## create selection dialog
    iwidgets::selectiondialog .pd -selectionlabel "Item for BPO" -modality application
    .pd hide 1
    .pd center
    .pd buttonconfigure 2 -text "Done"
    ## insert the list of items
    foreach i $i_list {
        .pd insert items end $i
    }
    
    set lab_lst {}
    set item_lst {}
    set done 0
    while {$done == 0} {
        if {[.pd activate]} {
            set text [.pd get]
            ## if this item as not been added to the frame
            if {[lsearch $item_lst $text] < 0} {
                lappend item_lst $text
                set f1 [frame $fx.f$item]
                set trit [iwidgets::entryfield $f1.itqu$item -labeltext "$text" \
                          -validate real -command mngr_update]
                lappend lab_lst $trit
                pack $trit -side left
                set trit [iwidgets::entryfield $f1.val$item]
                incr item
                pack $trit -side left
                pack $f1
            }
            ##.pd clear
        } else {
            set done 1
        }
    }
    ## add manufacture cost
    set f1 [frame $fx.f$item]
    set trit [iwidgets::entryfield $f1.uintrc$item -labeltext "Units/ Run" \
              -validate numeric -command mngr_update]
    pack $trit -side right
    pack $f1 -anchor e
    incr item
    ## add manufacture cost
    set f1 [frame $fx.f$item]
    set trit [iwidgets::entryfield $f1.unitc$item -labeltext "Manuf Time (min)" \
              -validate real -command mngr_update]
    pack $trit -side right
    pack $f1 -anchor e
    incr item
    ## how many units this run
    set f1 [frame $fx.f$item]
    set trit [iwidgets::entryfield $f1.unitn$item -labeltext "Runs"  \
              -validate numeric -command mngr_update]
    pack $trit -side right
    pack $f1 -anchor e
    incr item
    ## total cost of run
    set f1 [frame $fx.f$item]
    set trit [iwidgets::entryfield $f1.total$item -labeltext "Total cost"]
    pack $trit -side right
    pack $f1 -anchor e
    incr item
    ## total cost of unit
    set f1 [frame $fx.f$item]
    set trit [iwidgets::entryfield $f1.unit$item -labeltext "Unit cost"]
    pack $trit -side right
    pack $f1 -anchor e
    incr item
    
    eval iwidgets::Labeledwidget::alignlabels $lab_lst
    destroy .pd
}

##############################################
##  update the items list
proc items_update {} {
    global melist items_list f2 val_list sfitems3 inven_list inven_lbls
    
    
    set melist {}
    set items_list {}
    set val_list {}
    
    set ilst [winfo children $f2]
    foreach i $ilst {
        lappend melist $i
        lappend items_list [$i cget -labeltext]
        lappend val_list [$i get]
    }
    
    set ilst [winfo children $sfitems3]
    foreach i $ilst {
        lappend melist $i
        lappend items_list [$i cget -labeltext]
        lappend val_list [$i get]
    }
    
    foreach i $inven_list {
        set ilst [winfo children $i]
        set qua [[lindex $ilst 0] get]
        if {$qua != ""} {
	        set txt [[lindex $ilst 0] cget -labeltext]
	        set idx [lsearch $items_list $txt]
	        set val [lindex $val_list $idx]
	        set tot [lindex $ilst end]
	        $tot delete 0 end
	        ##[format "%.2f" [expr {double($ + $)}]]
	        $tot insert 0 [format "%.2f" [expr {double($qua * $val)}]]
	        ##puts "$txt   $qua  $idx val $val"
        }
    }
    
    mngr_update
}
#########################################################################
##  Update the tool fields after a change in something.
proc mngr_update {} {
    global melist bpo_frame_lst val_list items_list
    global inst_cost time_cost
    
    ##puts $items_list
    
    foreach fr $bpo_frame_lst {
        set tot_cost1 0
        set tot_cost2 0
        
        set ilst [winfo children $fr]
        
        set bpo_name [[lindex $ilst 0] cget -text]
        #puts $bpo_name
        foreach itm $ilst {
            set flst [winfo children $itm]
            #puts $flst
            #puts $itm
            set ite [lindex $flst 0]
            
            if {[string first "itqu" $ite] > 0} {
                #puts "Doing Item"
                #puts "Val List: $val_list"
                set total [lindex $flst 1]
                set itext [$ite cget -labeltext]
                set quant [$ite get]
                set item_idx [lsearch $items_list $itext]
                set cost [lindex $val_list $item_idx]
                if {$quant != "" } {
	                if {$quant == "."} {
		                set quant 0
		                $ite insert 0 0
	                }
	                if {$cost != ""} {
                        set tot_val [expr ($cost * $quant)]
                        set tot_cost1 [expr ($tot_val + $tot_cost1)]
                        $total delete 0 end
                        $total insert 0 $tot_val
                    } else {
                        $total delete 0 end
                        $total insert 0 0
                    }
                } else {
                    $total delete 0 end
                    $total insert 0 0
                }
                ##puts "$item_idx $itext $cost $quant $tot_val"
            } elseif {[string first "uintrc" $ite] > 0} {
                set unit_run [$ite get]
                if {$unit_run == ""} {
                    set unit_run 1
                }
                #puts "Doing Units per Run: $unit_run"
                
            } elseif {[string first "unitc" $ite] > 0} {
                #puts "Doing Lab cost"
                set lab_cost 0
                set instal_cost 0
                set run_t [$ite get]
                #puts $run_t
                if {$run_t != "" } {
                    set instal_cost [$inst_cost get]
                    set tmp_cost [$time_cost get]
                    if {$tmp_cost != ""} {
	                    if {$run_t != 0} {
                            #puts $tmp_cost
                            set min_cost [expr { double(double($tmp_cost) / 60.000) } ]
                            #puts $min_cost
                            set lab_cost [expr $min_cost * $run_t]
                            #puts $lab_cost
                        } else {
                            set min_cost 0
                            set lab_cost 0
                            set instal_cost 0
                        }
                    }
                    set tot_cost1 [expr ($lab_cost + $tot_cost1)]
                }
                
            } elseif {[string first "unitn" $ite] > 0} {
                #puts "Doing number of runs"
                set num_units [$ite get]
                if {$num_units != "" } {
                    if {$instal_cost > 0 && $num_units > 0} {
                        set inst_cost_pr [expr $instal_cost / $num_units]
                        set tot_cost2 [expr { (($tot_cost1 * $num_units) + $instal_cost) }]
                    } else {
                        set inst_cost_pr 0
                        set tot_cost2 0
                    }
                } else {
	                set inst_cost_pr 0
                }
            } elseif {[string first "total" $ite] > 0} {
                #puts "Doing Total"
                $ite delete 0 end
                $ite insert 0 $tot_cost2
            } elseif {[string first "unit" $ite] > 0} {
                #puts "Doing Unit Cost total"
                set tot_unit_cost [expr { double(($tot_cost1 + $inst_cost_pr) / $unit_run) }]
                $ite delete 0 end
                $ite insert 0 $tot_unit_cost
            }
        }
        ## if this item was on the bpo item list, up date the items list
        set lst_idx [lsearch $items_list $bpo_name]
        if {$lst_idx >= 0} {
	        set loc [lindex $melist $lst_idx]
	        #puts $melist
	        #puts "found BPO item: $bpo_name"
	        #puts $loc
	        $loc delete 0 end
	        $loc insert 0 $tot_unit_cost
	        set val_list [lreplace $val_list $lst_idx $lst_idx $tot_unit_cost]
        }
        
    }
    ##puts $val_list
}
###################################################
##  proc to make an item on the itmes list
proc make_item {fr} {
    global item melist sfitems2 inven_list inven_lbls val_list items_list
    
    iwidgets::promptdialog .pd -title "Item text Input" -modality application \
    -labeltext "Item text:"

    .pd center
    .pd activate
    set txt [.pd get]
    
    set nitem [iwidgets::entryfield $fr.it$item -width 10 -labeltext "$txt" \
               -justify right -command items_update -validate real]
    pack $nitem
    incr item
    
    lappend melist $nitem
    lappend items_list $txt
    
    eval iwidgets::Labeledwidget::alignlabels $melist
    
    destroy .pd
    ## add to the inventory list this item
    set tmp_fr [frame $sfitems2.inf$item]
    incr item
    set iqu  [iwidgets::entryfield $tmp_fr.itiv$item -width 14 -labeltext "$txt" \
              -validate real -justify right]
    incr item
    set iqu1  [iwidgets::entryfield $tmp_fr.itva$item -width 14 -justify right];
    incr item
    set iqu2  [iwidgets::entryfield $tmp_fr.itvat$item -width 14 -validate numeric -justify right];
    incr item
    set iqu3  [iwidgets::entryfield $tmp_fr.itmva$item -width 14 -justify right];
    incr item
    
    pack $iqu $iqu1 $iqu2 $iqu3 -side left
    pack $tmp_fr
    lappend inven_list $tmp_fr
    lappend inven_lbls $iqu
    eval iwidgets::Labeledwidget::alignlabels $inven_lbls

}

######################################################
##  proc to add a page to the page tabs
proc add_page {book} {
    
    iwidgets::promptdialog .pd -title "New Page Input" -modality application \
    -labeltext "Page Tab text:"

    .pd center
    .pd activate
    set text [.pd get]
    
    set page [$book add -label "$text"]
    
    destroy .pd
    
}

###########################################################
##  proc to edit the label text
proc edit_label {lbl} {
    set usrt [get_user_input "Edit lable text" "Label Text:"]
    
    $lbl configure -text $usrt
    puts $usrt
}

############################################################
##  proc to delete an item from the scroled item window
proc delete_item {wid} {
    global melist inven_list inven_lbls val_list items_list
    
    set idx [string first ".it" $wid]
    ## instead of presenting a list, force user to be over item
    if {$idx < 0} {
	    usr_msg "Need to have the curser\nover an inventory item."
	    return
    }
    
	set more [string first "." $wid [expr {$idx + 1}] ]
	set itwid [string range $wid 0 [expr {$more - 1}]]
	
	set ditem [$itwid cget -labeltext]
	puts $itwid
	puts "Item to delete: $ditem"
	
	#puts $melist
	set meidx [lsearch $melist $itwid]
	puts $meidx
	#puts $inven_list
	set invidx [lindex $inven_list $meidx]
	puts $invidx
	set  val [lindex $val_list $meidx]
	##puts $val_list
	puts $val
	
	#puts $items_list
#    # if current target is a label  strip
#    set lbl [string first ".label" $wid]
#    if {$lbl > 0} {
#        set dwid [string range $wid 0 [expr {$lbl - 1}]]
#        destroy $dwid
#    }
    
#    # if current target is an entry field  strip
#    set lbl [string first ".lwchildsite.entry" $wid]
#    if {$lbl > 0} {
#        set dwid [string range $wid 0 [expr {$lbl - 1}]]
#        destroy $dwid
#    }
}

################################################################
##  deleate bpo frame
proc delete_frame {wid} {
	
	global bpo_frame_lst
	
	#puts $wid
	#puts $bpo_frame_lst
	
	set frame [string first ".frx" $wid]
	set more [string first "." $wid [expr {$frame + 1}] ]
	if {$more > 0} {
		#puts $more
		set wid [string range $wid 0 [expr {$more - 1}]]
	}
	destroy $wid
	set bpo_idx [lsearch $bpo_frame_lst $wid]
	set bpo_frame_lst [lreplace $bpo_frame_lst $bpo_idx $bpo_idx]
	#puts $bpo_frame_lst
}

################################################################
##  Add inventroy to the inventory window
proc add_inventory {wid task} {
	global inven_list inven_lbls val_list items_list
	
	set frame [string first ".inf" $wid]
	set frame_ptr ""
	## if user clicked in a item frame
	if {$frame > 0} {
		## create the frame pointer
	    set more [string first "." $wid [expr {$frame + 1}] ]
	    set frame_ptr [string range $wid 0 [expr {$more - 1}]]
	    set idx [lsearch $inven_list $frame_ptr]
	    set lt  [lindex $inven_lbls $idx]
	    set ltext [$lt cget -labeltext]
	    #puts "Was in a frame"
    } else {
        ## create selection dialog
        iwidgets::selectiondialog .pd -selectionlabel "Add Items Too" -modality application
        .pd hide 1
        .pd center
        .pd buttonconfigure 2 -text "Done"
        ## insert the list of items
        foreach i $inven_lbls {
	         set t [$i cget -labeltext]
            .pd insert items end $t
        }
        ## get selection from user
        if {[.pd activate]} {
            set ltext [.pd get]
            set idx  [.pd curselection]
        }    
        destroy .pd
        ## set frame pointer from list index
        set frame_ptr [lindex $inven_list $idx]
        #puts "Was in the window"
    }
	#puts "selected $ltext at index: $idx"
    #puts $frame_ptr
    ## get the list of entries
    set field_lst [winfo children $frame_ptr]
    ## enble them
    foreach e $field_lst {
	    $e configure -state normal
    }
    
    set cur_quant_ptr [lindex $field_lst 0]
    set cur_ppu_ptr [lindex $field_lst 1]
    set cur_quant [$cur_quant_ptr get]
    if {$cur_quant == ""} {
	    set cur_quant 0
    }
    set cur_tot_ptr [lindex $field_lst 2]
    set cur_mark_ptr [lindex $field_lst 3]
    set cur_tot [$cur_tot_ptr get]
    if {$cur_tot == ""} {
	    set cur_tot 0
    }
    
    #puts "$cur_quant  $cur_tot"
    ## put out dialog to get number of items
    iwidgets::promptdialog .pd -title "Number of $ltext" -validate numeric -modality application \
    -labeltext "Number:"

    .pd hide 1
    .pd hide 2
    .pd center
    .pd activate
    set usr_quant [.pd get]
    if {$task == 0} {
        ## put out dialog to get total cost of those items
        .pd configure -title "Cost of $usr_quant $ltext"
        .pd configure -labeltext "Cost:"
        .pd configure -validate real
        .pd clear
        .pd activate
        set usr_cost [.pd get]
    }
    destroy .pd
    
    set cur_price [$cur_ppu_ptr get]
    set m_idx     [lsearch $items_list $ltext]
    ## calculate new values
    if {$task == 0} {
        set new_quant [expr {$usr_quant + $cur_quant}]
        set new_tot   [format "%.2f" [expr {double($usr_cost + $cur_tot)}]]
        if {$new_quant > 0} {
            set new_ppu   [format "%.2f" [expr { double($new_tot / $new_quant) }]]
        } else {
    	    set new_ppu 0
        }
        set cur_mval  [lindex $val_list $m_idx]
        set new_mval [format "%.2f" [expr { double($cur_mval * $new_quant) }]]
    } else {
        set new_quant [expr {$cur_quant - $usr_quant}]
        set new_tot   [format "%.2f" [expr {double($cur_tot - ($usr_quant * $cur_price))}]]
        set new_ppu  $cur_price
        set cur_mval  [lindex $val_list $m_idx]
        set new_mval [format "%.2f" [expr {double($cur_mval * $new_quant)}]]
    }
    
    #puts "New Quant is: $new_quant"
    #puts "New Price Per Unit: $new_ppu"
    #puts "New Total Value:  $new_tot"
    #puts "New Market value:  $new_mval"
    
    $cur_quant_ptr delete 0 end
    $cur_quant_ptr insert end $new_quant
    $cur_ppu_ptr delete 0 end
    $cur_ppu_ptr insert end $new_ppu
    $cur_tot_ptr delete 0 end
    $cur_tot_ptr insert end $new_tot
    $cur_mark_ptr delete 0 end
    $cur_mark_ptr insert end $new_mval
    
    ## Disable entries
    foreach e $field_lst {
	    $e configure -state readonly
    }
}

################################################################
##  Add to the Manufactered list a BPO item
proc add_bpo_it {} {
	global bpo_frame_lst item sfitems3 melist val_list items_list
	global sfitems2 inven_list inven_lbls bpo_items_list
	
	set bpo_txt_lst {}
	set bpo_val_lst {}
    ## the list of BPO frames
    foreach fr $bpo_frame_lst {
        set ilst [winfo children $fr]
        set label_item [lindex $ilst 0]
        #puts [$label_item cget -text]
        lappend bpo_txt_lst [$label_item cget -text]
        
        set ucost [lindex $ilst end]
        set ulst [winfo children $ucost]
        set ucost [lindex $ulst end]
        #puts [$ucost get]
        lappend bpo_val_lst [$ucost get]
#        foreach l $ilst {
#	        puts $l
#        }
    }
    # create selection list
    iwidgets::selectiondialog .pd -selectionlabel "BPO Item" -modality application
    .pd hide 1
    .pd center
    .pd buttonconfigure 2 -text "Done"
    ## insert the list of items
    foreach i $bpo_txt_lst {
        .pd insert items end $i
    }
    
    if {[.pd activate]} {
        set text [.pd get]
        lappend items_list $text
        set trit [iwidgets::entryfield $sfitems3.itqu$item -labeltext "$text" \
                  -validate numeric]
        lappend melist $trit
        set idx [lsearch $bpo_txt_lst $text]
        lappend val_list [lindex $bpo_val_lst $idx]
        $trit insert end [lindex $bpo_val_lst $idx]
        lappend bpo_items_list $trit
        incr item
        pack $trit
    }    
    destroy .pd
    
    ## add to the inventory list this item
    set tmp_fr [frame $sfitems2.inf$item]
    incr item
    set iqu  [iwidgets::entryfield $tmp_fr.itiv$item -width 12 -labeltext "$text" -validate real]
    incr item
    set iqu1  [iwidgets::entryfield $tmp_fr.itva$item -width 12];
    incr item
    set iqu2  [iwidgets::entryfield $tmp_fr.itvat$item -width 12 -validate numeric];
    incr item
    set iqu3  [iwidgets::entryfield $tmp_fr.itmva$item -width 12];
    incr item
    
    pack $iqu $iqu1 $iqu2 $iqu3 -side left
    pack $tmp_fr
    lappend inven_list $tmp_fr
    lappend inven_lbls $iqu
    eval iwidgets::Labeledwidget::alignlabels $inven_lbls
    eval iwidgets::Labeledwidget::alignlabels $bpo_items_list
}
##############################################################
##  proc to save the current setup and contents
proc write_setup {} {
    
    global bpo_frame_lst f2 wfile sfitems2 version sfitems3
    global inst_cost time_cost
    
    set file_name [$wfile get]
    set fh [open $file_name w]
    
    puts $fh "** Evemngr Version $version"
    
    ## The list of items
    set ilst [winfo children $f2]
    foreach l $ilst {
        puts $fh $l
        puts $fh [winfo class $l]
        puts $fh [$l cget -labeltext]
        puts $fh [$l get]
    }
    ## The list of BPO items
    set ilst [winfo children $sfitems3]
    puts $ilst
    foreach l $ilst {
        puts $fh $l
        puts $fh [winfo class $l]
        puts $fh [$l cget -labeltext]
        puts $fh [$l get]
    }
    ## list of inventory items
    set ilst [winfo children $sfitems2]
    foreach l $ilst {
        puts $fh $l
        puts $fh [winfo class $l]
        #puts $l
        set elst [winfo children $l]
        foreach j $elst {
            #puts $j
            puts $fh $j
            puts $fh [winfo class $j]
            puts $fh [$j cget -labeltext]
            puts $fh [$j get]
        }
    }
    
    ## the list of BPO frames
    foreach fr $bpo_frame_lst {
        puts $fh $fr
        puts $fh [winfo class $fr]
        set ilst [winfo children $fr]
        foreach l $ilst {
            puts $fh $l
            puts $fh [winfo class $l]
            if {[string first "labe" $l] > 0} {
                    puts $fh [$l cget -text]
                }
            set wlst [winfo children $l]
            foreach w $wlst {
                puts $fh $w
                if {[string first "itqu" $w] > 0} {
                    puts $fh [winfo class $w]
                    puts $fh [$w cget -labeltext]
                    puts $fh [$w get]
                } else {
                    puts $fh [winfo class $w]
                    #puts $w
                    puts $fh [$w get]
                }
            }
        }
    }
    ## save the manufacturing cost stats
    set inst [$inst_cost get]
    set itime [$time_cost get]
    puts $fh "manu $inst $itime"
    
    close $fh
}

###############################################
##  proc to load a setup
proc load_setup {} {
    
    global melist bpo_frame_lst item val_list items_list wfile
    global inven_list inven_lbls wdir bpo_items_list
    global inst_cost time_cost
    
    if {$item > 2} {
	    puts $bpo_frame_lst
	    clear_mngr
    }
    
    set bpo_frame_lst {}
    set items_flist {}
    set tmp_inv_lst {}
    set melist {}
    
##    if {[llength $melist] == 0} {
##	    puts "Clearing Manager"
##	    mngr_clear
##    }
    
    set file_name [$wfile get]
    ## if there is no file in the file spec, get it
    if {$file_name == ""} {
        browse_set_entry $wdir $wfile
        set file_name [$wfile get]
    }
    
    set fh [open $file_name r]
    
    while {[gets $fh l] >= 0} {
        if {[string first "." $l] == 0} {
            # stor the object address
            set addr $l
            #puts $l
            gets $fh l
            #puts $l
            ## if this is part of the items list
            if {[string first "sfi" $addr] >= 0} {
                if {[string first "Entryfield" $l] == 0} {
                    gets $fh txt
                    gets $fh val
                    lappend melist $addr
                    lappend val_list $val
                    lappend items_list $txt
                    if {[string first "sfi3" $addr] >= 0} {
	                    lappend bpo_items_list $addr
                    } else {
	                    lappend items_flist $addr
                    }
                    set tmpw [iwidgets::entryfield $addr -labeltext "$txt" -width 9 \
                    -validate real -command items_update -justify right]
                    $addr insert end $val
                    pack $addr -fill x
                    incr item
                } elseif {[string first "Frame" $l] == 0} {
                    #pack the frame
                    pack [frame $addr]
                    lappend  inven_list $addr
                    incr item
                    gets $fh addr
                    #puts $addr
                    gets $fh l
                    gets $fh txt
                    set tmpw [iwidgets::entryfield $addr -labeltext "$txt" -justify right \
                              -validate real -width 12]
                    pack $addr -side left
                    lappend tmp_inv_lst $tmpw
                    incr item
                    gets $fh l
                    $addr insert 0 $l
                    for {set i 0} {$i<3} {incr i} {
                        gets $fh addr
                        #puts $addr
                        gets $fh l
                        gets $fh txt
                        set tmpw [iwidgets::entryfield $addr -validate numeric -justify right -width 14]
                        pack $addr -side left
                        incr item
                        gets $fh l
                        $addr insert 0 $l
                    }
                    
                }
            ## if this is a BPO frame
            } elseif {[string first "Frame" $l] == 0} {
                # pack the frame
                pack [frame $addr] -fill x
                # append addr to BPO frame list
                lappend bpo_frame_lst $addr
                #get address of the label
                gets $fh addr
                gets $fh l
                gets $fh txt
                pack [label $addr -text $txt -background tan] -fill x
                ## do the items list
                set done 0
                set tlst {}
                while {$done == 0} {
                    gets $fh addr
                    gets $fh l
                    gets $fh addr1
                    if {[string first "itqu" $addr1] > 0} {
                        lappend tlst $addr1
                        pack [frame $addr] -fill x
                        incr item
                        gets $fh l
                        gets $fh txt
                        gets $fh val
                        pack [iwidgets::entryfield $addr1 -labeltext $txt \
                              -validate real -command mngr_update] -side left
                        $addr1 insert end $val
                        gets $fh addr
                        gets $fh l                        
                        gets $fh val
                        pack [entry $addr] -side left
                    } else {
                        incr done
                    }
                }
                eval iwidgets::Labeledwidget::alignlabels $tlst
                
                set tlst {}
                ## now the last 5
                pack [frame $addr] -anchor e -fill x
                gets $fh l
                gets $fh val
                pack [iwidgets::entryfield $addr1 -labeltext "Units/ Run" \
                      -validate numeric -command mngr_update]
                $addr1 insert end $val
                lappend tlst $addr1
                incr item
                gets $fh addr
                gets $fh l
                pack [frame $addr] -anchor e -fill x
                gets $fh addr
                gets $fh l
                gets $fh val
                pack [iwidgets::entryfield $addr -labeltext "Manuf Time (min)" \
                      -validate real -command mngr_update]
                incr item
                $addr insert end $val
                lappend tlst $addr
                gets $fh addr
                gets $fh l
                pack [frame $addr] -anchor e -fill x
                gets $fh addr
                gets $fh l
                gets $fh val
                pack [iwidgets::entryfield $addr -labeltext "Runs"]
                lappend tlst $addr
                incr item
                gets $fh addr
                gets $fh l
                pack [frame $addr] -anchor e -fill x
                gets $fh addr
                gets $fh l
                gets $fh val
                pack [iwidgets::entryfield $addr -labeltext "Total cost"]
                lappend tlst $addr
                incr item
                gets $fh addr
                gets $fh l
                pack [frame $addr] -anchor e -fill x
                gets $fh addr
                gets $fh l
                gets $fh val
                pack [iwidgets::entryfield $addr -labeltext "Unit cost"]
                lappend tlst $addr
                incr item
                eval iwidgets::Labeledwidget::alignlabels $tlst
            }
        ## if is manufacturing stats load them
        } elseif {[string first "manu" $l] == 0} {
	        set manul [split $l " "]
	        $inst_cost delete 0 end
	        $inst_cost insert 0 [lindex $manul 1]
	        $time_cost delete 0 end
	        $time_cost insert 0 [lindex $manul 2]
        }
        
    ## end while
    }
    close $fh
    eval iwidgets::Labeledwidget::alignlabels $bpo_items_list
    eval iwidgets::Labeledwidget::alignlabels $items_flist
    eval iwidgets::Labeledwidget::alignlabels $tmp_inv_lst
    set  inven_lbls $tmp_inv_lst
    
    #puts $melist

    mngr_update
    #puts $melist
}

##############################
bind . <F12> {catch {console show}}

#############
##  
bind . <Motion> "+mouse_move %W %x %y"
############
##  the zone and action for mouse movement
proc mouse_move {wid x y} {
    global helpVar c_wid
    
    #set helpVar "x: $x y: $y Win: $wid"
    #set c_wid $wid
    
    #if {[string first $tm_cav $wid] == 0} {
    #    if {$x > 9 & $x < 522 & $y > 90 & $y < 111} {
    #        set range [$tone_sel configure -range]
    #        set sran  [lindex $range 4]
    #        set sel_tone [expr $x - 10]
    #        if {($sel_tone >= [lindex $sran 0]) & ($sel_tone <= [lindex $sran 1])} {
    #            $tone_sel delete 0 end
    #            $tone_sel insert 0 $sel_tone
    #            set prev_tone [dec_tone_sel $tm_cav $tone_sel $prev_tone]
    #            ##set helpVar "Win: $wid  \n x: $x y: $y  Range: $sran"
    #        }
    #    }
    #}
}

##bind . <ButtonPress-1> "+select_1 %W"

##proc select_1 {wid} {
##    global l_wid l_wid_state helpVar
##    
##    if {[string first ".tnb" $wid] == 0} {
##        if {$l_wid != ""} {
##            
##            $l_wid configure -relief $l_wid_state
####            $l_wid configure -background
##        }
##        set l_wid $wid
##        set l_wid_state [lindex [split [$wid configure -relief] { }] end]
##        set helpVar $l_wid_state
##        $wid configure -relief raised
##    }
##}


#########################################################
##  right click menu pop up control
bind . <ButtonPress-3> "+select_2 %W %X %Y"

proc select_2 {wid x y} {
    global l_wid l_wid_state helpVar m f2 
    global main_lst bpo_lst1 sfpbo1 bpo_lst2 sfpbo2
    global sfitems2 invi_lst manuf_lst
    
    # only effective inside the tabs canvus
    if {[string first ".tnb" $wid] == 0} {

        $m delete 0 end
        #puts "$wid\n$sfitems1"
        if {[string first $main_lst $wid] == 0} {
            # add a new item to the item
            $m add command -label "Add Item" -command "make_item $f2"
            # if it is a label wid add edit command
            if {[string first "label" $wid] > 0} {
                $m add command -label "Edit Item" -command "edit_label $wid"
            }
            # add command to delete this item
            $m add command -label "Delete Item" -command "delete_item $wid"
            # pop up the menu
            tk_popup $m $x $y
        } elseif {[string first $bpo_lst1 $wid] == 0} {
            # add a new item to the item
            $m add command -label "Add frame" -command "make_frame $sfpbo1"
            set idx [string first "frx" $wid]
            set idx [string first "." $wid $idx]
            set idx1 [string first "." $wid [expr {$idx + 1}]]
            ##puts $idx
            ##puts $idx1
            # add command to delete this item
            $m add command -label "Delete frame" -command "delete_frame $wid"
            # pop up the menu
            tk_popup $m $x $y
        } elseif {[string first $bpo_lst2 $wid] == 0} {
            # add a new item to the item
            $m add command -label "Add frame" -command "make_frame $sfpbo2"
            set idx [string first "frx" $wid]
            set idx [string first "." $wid $idx]
            set idx1 [string first "." $wid [expr {$idx + 1}]]
            ##puts $idx
            ##puts $idx1
            # add command to delete this item
            $m add command -label "Delete frame" -command "delete_frame $wid"
            # pop up the menu
            tk_popup $m $x $y
        } elseif {[string first $invi_lst $wid] == 0} {
            # add inventory to the system
            $m add command -label "Add Inventory" -command "add_inventory $wid 0"
            # remove inventory from the system
            $m add command -label "Remove Inventory" -command "add_inventory $wid 1"
            # pop up the menu
            tk_popup $m $x $y
        } elseif {[string first $manuf_lst $wid] == 0} {
            # add inventory to the system
            $m add command -label "Add BPO Item" -command add_bpo_it
            # remove inventory from the system
            $m add command -label "Remove BPO Item" -command remove_bpo_it
            # pop up the menu
            tk_popup $m $x $y
        }
    }
}

##########################################
bind . <KeyPress> "pressed_key  %W %X %Y"

proc pressed_key {wid x y} {
    items_update
}

# Create a menu
set m [menu .popupMenu]
#$m add command -label "Example 1" -command bell
#$m add command -label "Example 2" -command bell

# Create something to attach it to
#pack [label .l -text "Click me!"]

